"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const config_1 = require("@trezor/connect/lib/data/config");
const transportInfo_1 = require("@trezor/connect/lib/data/transportInfo");
const udevInfo_1 = require("@trezor/connect/lib/data/udevInfo");
const exports_1 = require("@trezor/connect/lib/exports");
const factory_1 = require("@trezor/connect/lib/factory");
const core_in_module_1 = require("@trezor/connect/lib/impl/core-in-module");
const dynamic_1 = require("@trezor/connect/lib/impl/dynamic");
const connect_common_1 = require("@trezor/connect-common");
const utils_1 = require("@trezor/utils");
const impl = new dynamic_1.TrezorConnectDynamic({
    implementations: [
        {
            type: 'core-in-module',
            impl: new core_in_module_1.CoreInModule((message) => {
                if (message.event === exports_1.TRANSPORT_EVENT) {
                    const platform = (0, connect_common_1.getInstallerPackage)();
                    message.payload.bridge = (0, utils_1.cloneObject)((0, transportInfo_1.suggestBridgeInstaller)(platform));
                    message.payload.udev = (0, utils_1.cloneObject)((0, udevInfo_1.suggestUdevInstaller)(platform));
                }
                return message;
            }),
        },
    ],
    getInitTarget: () => 'core-in-module',
    handleBeforeCall: () => new Promise(resolve => resolve()),
    handleErrorFallback: () => new Promise(resolve => resolve(false)),
});
const disableWebUSB = () => {
    if (!impl.lastSettings) {
        throw exports_1.ERRORS.TypedError('Init_NotInitialized');
    }
    impl.getTarget().handleCoreMessage({ type: exports_1.TRANSPORT.DISABLE_WEBUSB });
};
const requestWebUSBDevice = async () => {
    try {
        await window.navigator.usb.requestDevice({ filters: config_1.config.webusb });
        impl.getTarget().handleCoreMessage({ type: exports_1.TRANSPORT.REQUEST_DEVICE });
    }
    catch {
    }
};
const TrezorConnect = (0, factory_1.factory)({
    eventEmitter: impl.eventEmitter,
    init: impl.init.bind(impl),
    call: impl.call.bind(impl),
    setTransports: impl.setTransports.bind(impl),
    manifest: impl.manifest.bind(impl),
    requestLogin: impl.requestLogin.bind(impl),
    uiResponse: impl.uiResponse.bind(impl),
    cancel: impl.cancel.bind(impl),
    dispose: impl.dispose.bind(impl),
}, {
    disableWebUSB: disableWebUSB.bind(impl),
    requestWebUSBDevice: requestWebUSBDevice.bind(impl),
});
exports.default = TrezorConnect;
tslib_1.__exportStar(require("@trezor/connect/lib/exports"), exports);
if (typeof window !== 'undefined') {
    window.addEventListener('beforeunload', () => {
        impl.dispose();
    });
}
//# sourceMappingURL=index.js.map