"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseConnectSettings = exports.getEnv = void 0;
const connectSettings_1 = require("@trezor/connect/lib/data/connectSettings");
const getEnv = () => {
    if (typeof chrome !== 'undefined' && typeof chrome.runtime?.onConnect !== 'undefined') {
        return 'webextension';
    }
    if (typeof navigator !== 'undefined') {
        if (typeof navigator.product === 'string' &&
            navigator.product.toLowerCase() === 'reactnative') {
            return 'react-native';
        }
        const userAgent = navigator.userAgent.toLowerCase();
        if (userAgent.indexOf(' electron/') > -1) {
            return 'electron';
        }
    }
    return 'web';
};
exports.getEnv = getEnv;
const parseConnectSettings = (input = {}) => {
    const settings = { popup: true, ...input };
    let globalSrc;
    if (typeof window !== 'undefined') {
        globalSrc = window.__TREZOR_CONNECT_SRC;
    }
    else if (typeof global !== 'undefined') {
        globalSrc = global.__TREZOR_CONNECT_SRC;
    }
    if (typeof globalSrc === 'string') {
        settings.connectSrc = globalSrc;
        settings.debug = true;
    }
    if (typeof input.env !== 'string') {
        settings.env = (0, exports.getEnv)();
    }
    return (0, connectSettings_1.parseConnectSettings)(settings);
};
exports.parseConnectSettings = parseConnectSettings;
//# sourceMappingURL=connectSettings.js.map