"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceWorkerWindowChannel = void 0;
const connect_common_1 = require("@trezor/connect-common");
class ServiceWorkerWindowChannel extends connect_common_1.AbstractMessageChannel {
    port;
    name;
    allowSelfOrigin;
    currentId;
    constructor({ name, channel, logger, lazyHandshake, legacyMode, allowSelfOrigin = false, currentId, }) {
        super({
            channel,
            sendFn: (message) => {
                if (!this.port)
                    throw new Error('port not assigned');
                this.port.postMessage(message);
            },
            logger,
            lazyHandshake,
            legacyMode,
        });
        this.name = name;
        this.allowSelfOrigin = allowSelfOrigin;
        this.currentId = currentId;
        this.connect();
    }
    connect() {
        chrome.runtime.onConnect.addListener(port => {
            if (port.name !== this.name)
                return;
            if (this.currentId?.() && this.currentId?.() !== port.sender?.tab?.id)
                return;
            this.port = port;
            this.port.onMessage.addListener((message, { sender }) => {
                if (!sender) {
                    this.logger?.error('service-worker-window', 'no sender');
                    return;
                }
                const { origin } = sender;
                const whitelist = [
                    'https://connect.trezor.io',
                    'https://staging-connect.trezor.io',
                    'https://suite.corp.sldev.cz',
                    'https://dev.suite.sldev.cz',
                    'http://localhost:8088',
                ];
                const webextensionId = chrome?.runtime?.id;
                if (webextensionId) {
                    whitelist.push(`chrome-extension://${webextensionId}`);
                }
                const webextensionUrl = chrome?.runtime?.getURL('');
                if (webextensionUrl) {
                    whitelist.push(webextensionUrl.slice(0, -1));
                }
                if (!origin) {
                    this.logger?.error('connect-webextension/messageChannel/extensionPort/onMessage', 'no origin');
                    return;
                }
                if (!whitelist.includes(origin)) {
                    this.logger?.error('connect-webextension/messageChannel/extensionPort/onMessage', 'origin not whitelisted', origin);
                    return;
                }
                if (origin === self.origin && !this.allowSelfOrigin) {
                    return;
                }
                this.onMessage(message);
            });
        });
        this.isConnected = true;
    }
    disconnect() {
        if (!this.isConnected)
            return;
        this.port?.disconnect();
        this.clear();
        this.isConnected = false;
    }
}
exports.ServiceWorkerWindowChannel = ServiceWorkerWindowChannel;
//# sourceMappingURL=serviceworker-window.js.map