"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.storage = void 0;
const utils_1 = require("@trezor/utils");
const storageVersion = 2;
const storageName = `storage_v${storageVersion}`;
const getEmptyState = () => ({
    origin: {},
});
let memoryStorage = getEmptyState();
const getPermanentStorage = () => {
    const ls = localStorage.getItem(storageName);
    return ls ? JSON.parse(ls) : getEmptyState();
};
class Storage extends utils_1.TypedEmitter {
    save(getNewState, temporary = false) {
        if (temporary || !global.window) {
            memoryStorage = getNewState(memoryStorage);
            return;
        }
        try {
            const newState = getNewState(getPermanentStorage());
            localStorage.setItem(storageName, JSON.stringify(newState));
            this.emit('changed', newState);
        }
        catch {
            console.warn('long term storage not available');
            memoryStorage = getNewState(memoryStorage);
        }
    }
    saveForOrigin(getNewState, origin, temporary = false) {
        this.save(state => ({
            ...state,
            origin: {
                ...state.origin,
                [origin]: getNewState(state.origin?.[origin] || {}),
            },
        }), temporary);
    }
    load(temporary = false) {
        if (temporary || !global?.window?.localStorage) {
            return memoryStorage;
        }
        try {
            return getPermanentStorage();
        }
        catch {
            console.warn('long term storage not available');
            return memoryStorage;
        }
    }
    loadForOrigin(origin, temporary = false) {
        const state = this.load(temporary);
        return state.origin?.[origin] || {};
    }
}
const storage = new Storage();
exports.storage = storage;
//# sourceMappingURL=storage.js.map