"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.prioritizeEndpoints = void 0;
const utils_1 = require("@trezor/utils");
const prioritizeEndpoints = (urls) => urls
    .map((url) => {
    const hostname = (0, utils_1.parseHostname)(url);
    let priority = Math.random();
    if (hostname === 'localhost' || hostname === '127.0.0.1') {
        priority += 2;
    }
    else if (hostname?.endsWith('.onion')) {
        priority += 1;
    }
    return [url, priority];
})
    .sort(([, a], [, b]) => b - a)
    .map(([url]) => url);
exports.prioritizeEndpoints = prioritizeEndpoints;
//# sourceMappingURL=utils.js.map