import type { AddressNotification, BlockNotification, FiatRatesNotification, FilterRequestParams, MempoolTransactionNotification, Send } from '@trezor/blockchain-link-types/lib/blockbook';
import type { GetCurrentFiatRates, GetFiatRatesForTimestamps, GetFiatRatesTickersList } from '@trezor/blockchain-link-types/lib/messages';
import type { AccountBalanceHistoryParams, AccountInfoParams, EstimateFeeParams, RpcCallParams } from '@trezor/blockchain-link-types/lib/params';
import { BaseWebsocket } from '../baseWebsocket';
interface BlockbookEvents {
    block: BlockNotification;
    mempool: MempoolTransactionNotification;
    notification: AddressNotification;
    fiatRates: FiatRatesNotification;
}
export declare class BlockbookAPI extends BaseWebsocket<BlockbookEvents> {
    protected createWebsocket(): import("ws");
    protected ping(): Promise<import("@trezor/blockchain-link-types/lib/blockbook-api").WsBlockHashRes>;
    send: Send;
    getServerInfo(): Promise<import("@trezor/blockchain-link-types/lib/blockbook-api").WsInfoRes>;
    getBlockHash(block: number): Promise<import("@trezor/blockchain-link-types/lib/blockbook-api").WsBlockHashRes>;
    getBlock(block: number | string): Promise<import("@trezor/blockchain-link-types/lib/blockbook").Block>;
    getBlockFilter(blockHash: string, filterParams?: FilterRequestParams): Promise<import("@trezor/blockchain-link-types/lib/blockbook").FilterResponse & {
        blockFilter: string;
    }>;
    getBlockFiltersBatch(bestKnownBlockHash: string, pageSize?: number, filterParams?: FilterRequestParams): Promise<import("@trezor/blockchain-link-types/lib/blockbook").FilterResponse & {
        blockFiltersBatch: `${string}:${string}:${string}`[];
    }>;
    getMempoolFilters(fromTimestamp?: number, filterParams?: FilterRequestParams): Promise<import("@trezor/blockchain-link-types/lib/blockbook").FilterResponse & import("@trezor/blockchain-link-types/lib/blockbook-api").MempoolTxidFilterEntries>;
    getAccountInfo(payload: AccountInfoParams): Promise<import("@trezor/blockchain-link-types/lib/blockbook").AccountInfo>;
    getAccountUtxo(descriptor: string): Promise<import("@trezor/blockchain-link-types/lib/blockbook").AccountUtxo>;
    getTransaction(txid: string): Promise<import("@trezor/blockchain-link-types/lib/blockbook").Transaction>;
    pushTransaction(hex: string, disableAlternativeRPC?: boolean): Promise<import("@trezor/blockchain-link-types/lib/blockbook").Push>;
    estimateFee(payload: EstimateFeeParams): Promise<import("@trezor/blockchain-link-types/lib/blockbook").Fee>;
    rpcCall(payload: RpcCallParams): Promise<{
        data: string;
    }>;
    getCurrentFiatRates(payload: GetCurrentFiatRates['payload']): Promise<import("@trezor/blockchain-link-types/lib/blockbook").TimestampedFiatRates>;
    getAccountBalanceHistory(payload: AccountBalanceHistoryParams): Promise<import("@trezor/blockchain-link-types").AccountBalanceHistory[]>;
    getFiatRatesForTimestamps(payload: GetFiatRatesForTimestamps['payload']): Promise<import("@trezor/blockchain-link-types/lib/blockbook").FiatRatesForTimestamp>;
    getFiatRatesTickersList(payload: GetFiatRatesTickersList['payload']): Promise<import("@trezor/blockchain-link-types/lib/blockbook").AvailableCurrencies>;
    subscribeAddresses(addresses: string[]): Promise<import("@trezor/blockchain-link-types/lib/blockbook").Subscribe>;
    unsubscribeAddresses(): Promise<import("@trezor/blockchain-link-types/lib/blockbook").Subscribe> | {
        subscribed: boolean;
    };
    subscribeBlock(): Promise<import("@trezor/blockchain-link-types/lib/blockbook").Subscribe>;
    unsubscribeBlock(): Promise<import("@trezor/blockchain-link-types/lib/blockbook").Subscribe> | {
        subscribed: boolean;
    };
    subscribeFiatRates(currency?: string): Promise<import("@trezor/blockchain-link-types/lib/blockbook").Subscribe>;
    unsubscribeFiatRates(): Promise<import("@trezor/blockchain-link-types/lib/blockbook").Subscribe> | {
        subscribed: boolean;
    };
    subscribeMempool(): Promise<import("@trezor/blockchain-link-types/lib/blockbook").Subscribe>;
    unsubscribeMempool(): Promise<import("@trezor/blockchain-link-types/lib/blockbook").Subscribe> | {
        subscribed: boolean;
    };
}
export {};
//# sourceMappingURL=websocket.d.ts.map