import { SocksProxyAgent } from 'socks-proxy-agent';
import type { BlockchainSettings, Response } from '@trezor/blockchain-link-types';
import type { Message } from '@trezor/blockchain-link-types/lib/messages';
import { WorkerState } from './state';
export declare const CONTEXT: string;
export type ContextType<API> = {
    connect: () => Promise<API>;
    post: (r: Response) => void;
    state: WorkerState;
};
export declare abstract class BaseWorker<API> {
    api: API | undefined;
    proxyAgent: SocksProxyAgent | undefined;
    settings: Partial<BlockchainSettings>;
    state: WorkerState;
    post: (data: Response) => void;
    constructor();
    debug(...args: any[]): void;
    cleanup(): void;
    protected abstract isConnected(api: API | undefined): api is API;
    protected abstract tryConnect(url: string): Promise<API>;
    private connectPromise?;
    connect(): Promise<API>;
    private connectRecursive;
    disconnect(): void;
    messageHandler(event: {
        data: Message;
    }): Promise<true | undefined>;
    errorResponse(id: number, error: unknown): void;
    postMessage(data: Message): void;
    onmessage(_evt: {
        data: Response;
    }): void;
    onmessageerror(_error: Error): void;
    onerror(_error: Error): void;
    terminate(): void;
}
//# sourceMappingURL=baseWorker.d.ts.map