import type { VinVout } from '@trezor/blockchain-link-types/lib/blockbook';
import type { EnhancedVinVout, Transaction } from '@trezor/blockchain-link-types/lib/common';
import { BigNumberValue } from '@trezor/utils/lib/bigNumber';
export type Addresses = ({
    address: string;
} | string)[] | string;
export declare const isAccountOwned: (addresses: string[]) => (vinVout: VinVout) => boolean;
export declare const filterTargets: (addresses: Addresses, targets: VinVout[]) => VinVout[];
export declare const enhanceVinVout: (addresses: string[]) => (vinVout: VinVout) => EnhancedVinVout;
export declare const sumVinVout: (sum: BigNumberValue, { value }: VinVout) => BigNumberValue;
export declare const transformTarget: (target: VinVout, incoming: VinVout[]) => {
    n: number;
    addresses: string[] | undefined;
    isAddress: boolean;
    amount: string | undefined;
    coinbase: string | undefined;
    isAccountTarget: boolean | undefined;
};
export declare const sortTxsFromLatest: (transactions: Transaction[]) => Transaction[];
export declare const formatTokenSymbol: (symbol: string) => string;
export declare const filterShadowedPendingTxsByNonce: (txs: Transaction[], lowerCasedDescriptor: string) => Transaction[];
//# sourceMappingURL=utils.d.ts.map