import { TokenTransfer, Transaction } from '@trezor/blockchain-link-types/lib';
import type { TokenDetailByMint, TokenInfo } from '@trezor/blockchain-link-types/lib';
import { SolanaTokenAccountInfo } from '@trezor/blockchain-link-types/lib/solana';
import { BigNumber } from '@trezor/utils/lib/bigNumber';
import type { AccountInfo, Address, ParsedAccountData, ParsedTransactionWithMeta, SolanaValidParsedTxWithMeta } from './solana-types';
export type ApiTokenAccount = {
    account: AccountInfo<ParsedAccountData>;
    pubkey: Address;
};
export declare const TOKEN_PROGRAM_PUBLIC_KEY = "TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA";
export declare const TOKEN_2022_PROGRAM_PUBLIC_KEY = "TokenzQdBNbLqP5VEhdkAS6EPFLC1PHnBqCXEpPxuEb";
export declare const ASSOCIATED_TOKEN_PROGRAM_PUBLIC_KEY = "ATokenGPvbdGVxr1b2hvZbsiqW5xWH25efTNsLJA8knL";
export declare const SYSTEM_PROGRAM_PUBLIC_KEY = "11111111111111111111111111111111";
export declare const WSOL_MINT = "So11111111111111111111111111111111111111112";
export declare const STAKE_PROGRAM_PUBLIC_KEY = "Stake11111111111111111111111111111111111111";
export declare const COMPUTE_BUDGET_PROGRAM_ID = "ComputeBudget111111111111111111111111111111";
export declare const SERUM_ASSET_OWNER_PROGRAM_ID = "4MNPdKu9wFMvEeZBMt3Eipfs5ovVWTJb31pEXDJAAxX5";
export declare const SERUM_ASSET_OWNER_PHANTOM_DEPLOYMENT_PROGRAM_ID = "DeJBGdMFa1uynnnKiwrVioatTuHmNLpyFKnmB5kaFdzQ";
declare const tokenProgramNames: readonly ["spl-token", "spl-token-2022"];
export type TokenProgramName = (typeof tokenProgramNames)[number];
export declare const tokenProgramsInfo: {
    readonly 'spl-token': {
        readonly publicKey: "TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA";
        readonly tokenStandard: "SPL";
    };
    readonly 'spl-token-2022': {
        readonly publicKey: "TokenzQdBNbLqP5VEhdkAS6EPFLC1PHnBqCXEpPxuEb";
        readonly tokenStandard: "SPL-2022";
    };
};
export declare const getTokenMetadata: () => Promise<TokenDetailByMint>;
export declare const getTokenNameAndSymbol: (mint: string, tokenDetailByMint: TokenDetailByMint) => {
    name: string;
    symbol: string;
};
export declare const tokenStandardToTokenProgramName: (standard: string) => TokenProgramName;
export declare const transformTokenInfo: (tokenAccounts: readonly ApiTokenAccount[], tokenDetailByMint: TokenDetailByMint) => TokenInfo[];
export declare const extractAccountBalanceDiff: (transaction: ParsedTransactionWithMeta, address: string, isTokenDiff?: boolean) => {
    preBalance: BigNumber;
    postBalance: BigNumber;
} | null;
type TransactionEffect = {
    address: Address;
    amount: BigNumber;
};
export declare function getNativeEffects(transaction: ParsedTransactionWithMeta): TransactionEffect[];
export declare const getTargets: (effects: TransactionEffect[], txType: Transaction["type"], accountAddress: string) => Transaction["targets"];
export declare const getTxType: (transaction: ParsedTransactionWithMeta, effects: TransactionEffect[], accountAddress: string, tokenTransfers: TokenTransfer[]) => Transaction["type"];
export declare const getDetails: (transaction: ParsedTransactionWithMeta, effects: TransactionEffect[], accountAddress: string, txType: Transaction["type"]) => Transaction["details"];
export declare const getAmount: (accountEffect: TransactionEffect | undefined, txType: Transaction["type"]) => string;
export declare const getTokens: (tx: ParsedTransactionWithMeta, accountAddress: string, tokenDetailByMint: TokenDetailByMint, tokenAccountsInfos: SolanaTokenAccountInfo[]) => TokenTransfer[];
export declare const transformTransaction: (tx: SolanaValidParsedTxWithMeta, accountAddress: string, tokenAccountsInfos: SolanaTokenAccountInfo[], tokenDetailByMint?: TokenDetailByMint) => Transaction;
export {};
//# sourceMappingURL=solana.d.ts.map