"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.transformTransaction = exports.transformServerInfo = void 0;
const transformServerInfo = (payload) => ({
    name: 'Ripple',
    shortcut: 'xrp',
    network: 'xrp',
    testnet: false,
    version: payload.result.info.build_version,
    decimals: 6,
    blockHeight: payload.result.info.validated_ledger?.seq ?? 0,
    blockHash: payload.result.info.validated_ledger?.hash ?? '',
});
exports.transformServerInfo = transformServerInfo;
const BLOCKTIME_OFFSET = 946684800;
const getUnixTimestamp = (xrplTimestamp) => {
    if (!xrplTimestamp || xrplTimestamp <= 0) {
        return 0;
    }
    return xrplTimestamp + BLOCKTIME_OFFSET;
};
const transformTransaction = (hash, tx_json, meta, descriptor) => {
    let txType = 'unknown';
    let addresses = [];
    let amount;
    let destinationTag;
    if (tx_json.TransactionType === 'Payment') {
        const deliverMax = tx_json.DeliverMax ?? undefined;
        const isTokenTransaction = typeof deliverMax !== 'string';
        amount = !isTokenTransaction ? deliverMax : undefined;
        if (meta != null &&
            typeof meta !== 'string' &&
            !meta.TransactionResult?.startsWith('tes')) {
            txType = 'failed';
        }
        else if (!descriptor || isTokenTransaction) {
            txType = 'unknown';
        }
        else {
            txType = tx_json.Account === descriptor ? 'sent' : 'recv';
        }
        addresses = [tx_json.Destination];
        destinationTag = tx_json.DestinationTag;
    }
    return {
        type: txType,
        txid: hash ?? '',
        amount: amount ?? '0',
        fee: tx_json.Fee ?? '0',
        blockTime: getUnixTimestamp(tx_json.date),
        blockHeight: tx_json.ledger_index,
        blockHash: hash ?? '',
        targets: txType === 'unknown'
            ? []
            : [
                {
                    addresses,
                    isAddress: true,
                    amount,
                    n: 0,
                },
            ],
        tokens: [],
        internalTransfers: [],
        feeRate: undefined,
        details: {
            vin: [],
            vout: [],
            size: 0,
            totalInput: '0',
            totalOutput: '0',
        },
        rippleSpecific: {
            destinationTag,
        },
    };
};
exports.transformTransaction = transformTransaction;
//# sourceMappingURL=ripple.js.map