/**
 * This code was AUTOGENERATED using the codama library.
 * Please DO NOT EDIT THIS FILE, instead use visitors
 * to add features, then rerun codama to update it.
 *
 * @see https://github.com/codama-idl/codama
 */
import { type Address, type Codec, type Decoder, type Encoder, type IAccountMeta, type IAccountSignerMeta, type IInstruction, type IInstructionWithAccounts, type IInstructionWithData, type Option, type OptionOrNullable, type ReadonlyAccount, type ReadonlySignerAccount, type TransactionSigner, type WritableAccount } from '@solana/kit';
import { TOKEN_PROGRAM_ADDRESS } from '../programs';
import { type AuthorityType, type AuthorityTypeArgs } from '../types';
export declare const SET_AUTHORITY_DISCRIMINATOR = 6;
export declare function getSetAuthorityDiscriminatorBytes(): import("@solana/kit").ReadonlyUint8Array;
export type SetAuthorityInstruction<TProgram extends string = typeof TOKEN_PROGRAM_ADDRESS, TAccountOwned extends string | IAccountMeta<string> = string, TAccountOwner extends string | IAccountMeta<string> = string, TRemainingAccounts extends readonly IAccountMeta<string>[] = []> = IInstruction<TProgram> & IInstructionWithData<Uint8Array> & IInstructionWithAccounts<[
    TAccountOwned extends string ? WritableAccount<TAccountOwned> : TAccountOwned,
    TAccountOwner extends string ? ReadonlyAccount<TAccountOwner> : TAccountOwner,
    ...TRemainingAccounts
]>;
export type SetAuthorityInstructionData = {
    discriminator: number;
    /** The type of authority to update. */
    authorityType: AuthorityType;
    /** The new authority */
    newAuthority: Option<Address>;
};
export type SetAuthorityInstructionDataArgs = {
    /** The type of authority to update. */
    authorityType: AuthorityTypeArgs;
    /** The new authority */
    newAuthority: OptionOrNullable<Address>;
};
export declare function getSetAuthorityInstructionDataEncoder(): Encoder<SetAuthorityInstructionDataArgs>;
export declare function getSetAuthorityInstructionDataDecoder(): Decoder<SetAuthorityInstructionData>;
export declare function getSetAuthorityInstructionDataCodec(): Codec<SetAuthorityInstructionDataArgs, SetAuthorityInstructionData>;
export type SetAuthorityInput<TAccountOwned extends string = string, TAccountOwner extends string = string> = {
    /** The mint or account to change the authority of. */
    owned: Address<TAccountOwned>;
    /** The current authority or the multisignature account of the mint or account to update. */
    owner: Address<TAccountOwner> | TransactionSigner<TAccountOwner>;
    authorityType: SetAuthorityInstructionDataArgs['authorityType'];
    newAuthority: SetAuthorityInstructionDataArgs['newAuthority'];
    multiSigners?: Array<TransactionSigner>;
};
export declare function getSetAuthorityInstruction<TAccountOwned extends string, TAccountOwner extends string, TProgramAddress extends Address = typeof TOKEN_PROGRAM_ADDRESS>(input: SetAuthorityInput<TAccountOwned, TAccountOwner>, config?: {
    programAddress?: TProgramAddress;
}): SetAuthorityInstruction<TProgramAddress, TAccountOwned, (typeof input)['owner'] extends TransactionSigner<TAccountOwner> ? ReadonlySignerAccount<TAccountOwner> & IAccountSignerMeta<TAccountOwner> : TAccountOwner>;
export type ParsedSetAuthorityInstruction<TProgram extends string = typeof TOKEN_PROGRAM_ADDRESS, TAccountMetas extends readonly IAccountMeta[] = readonly IAccountMeta[]> = {
    programAddress: Address<TProgram>;
    accounts: {
        /** The mint or account to change the authority of. */
        owned: TAccountMetas[0];
        /** The current authority or the multisignature account of the mint or account to update. */
        owner: TAccountMetas[1];
    };
    data: SetAuthorityInstructionData;
};
export declare function parseSetAuthorityInstruction<TProgram extends string, TAccountMetas extends readonly IAccountMeta[]>(instruction: IInstruction<TProgram> & IInstructionWithAccounts<TAccountMetas> & IInstructionWithData<Uint8Array>): ParsedSetAuthorityInstruction<TProgram, TAccountMetas>;
//# sourceMappingURL=setAuthority.d.ts.map