/**
 * This code was AUTOGENERATED using the codama library.
 * Please DO NOT EDIT THIS FILE, instead use visitors
 * to add features, then rerun codama to update it.
 *
 * @see https://github.com/codama-idl/codama
 */
import { type Address, type Codec, type Decoder, type Encoder, type IAccountMeta, type IInstruction, type IInstructionWithAccounts, type IInstructionWithData, type Option, type OptionOrNullable, type ReadonlyAccount, type WritableAccount } from '@solana/kit';
import { TOKEN_PROGRAM_ADDRESS } from '../programs';
export declare const INITIALIZE_MINT_DISCRIMINATOR = 0;
export declare function getInitializeMintDiscriminatorBytes(): import("@solana/kit").ReadonlyUint8Array;
export type InitializeMintInstruction<TProgram extends string = typeof TOKEN_PROGRAM_ADDRESS, TAccountMint extends string | IAccountMeta<string> = string, TAccountRent extends string | IAccountMeta<string> = 'SysvarRent111111111111111111111111111111111', TRemainingAccounts extends readonly IAccountMeta<string>[] = []> = IInstruction<TProgram> & IInstructionWithData<Uint8Array> & IInstructionWithAccounts<[
    TAccountMint extends string ? WritableAccount<TAccountMint> : TAccountMint,
    TAccountRent extends string ? ReadonlyAccount<TAccountRent> : TAccountRent,
    ...TRemainingAccounts
]>;
export type InitializeMintInstructionData = {
    discriminator: number;
    /** Number of decimals in token account amounts. */
    decimals: number;
    /** Minting authority. */
    mintAuthority: Address;
    /** Optional authority that can freeze token accounts. */
    freezeAuthority: Option<Address>;
};
export type InitializeMintInstructionDataArgs = {
    /** Number of decimals in token account amounts. */
    decimals: number;
    /** Minting authority. */
    mintAuthority: Address;
    /** Optional authority that can freeze token accounts. */
    freezeAuthority?: OptionOrNullable<Address>;
};
export declare function getInitializeMintInstructionDataEncoder(): Encoder<InitializeMintInstructionDataArgs>;
export declare function getInitializeMintInstructionDataDecoder(): Decoder<InitializeMintInstructionData>;
export declare function getInitializeMintInstructionDataCodec(): Codec<InitializeMintInstructionDataArgs, InitializeMintInstructionData>;
export type InitializeMintInput<TAccountMint extends string = string, TAccountRent extends string = string> = {
    /** Token mint account. */
    mint: Address<TAccountMint>;
    /** Rent sysvar. */
    rent?: Address<TAccountRent>;
    decimals: InitializeMintInstructionDataArgs['decimals'];
    mintAuthority: InitializeMintInstructionDataArgs['mintAuthority'];
    freezeAuthority?: InitializeMintInstructionDataArgs['freezeAuthority'];
};
export declare function getInitializeMintInstruction<TAccountMint extends string, TAccountRent extends string, TProgramAddress extends Address = typeof TOKEN_PROGRAM_ADDRESS>(input: InitializeMintInput<TAccountMint, TAccountRent>, config?: {
    programAddress?: TProgramAddress;
}): InitializeMintInstruction<TProgramAddress, TAccountMint, TAccountRent>;
export type ParsedInitializeMintInstruction<TProgram extends string = typeof TOKEN_PROGRAM_ADDRESS, TAccountMetas extends readonly IAccountMeta[] = readonly IAccountMeta[]> = {
    programAddress: Address<TProgram>;
    accounts: {
        /** Token mint account. */
        mint: TAccountMetas[0];
        /** Rent sysvar. */
        rent: TAccountMetas[1];
    };
    data: InitializeMintInstructionData;
};
export declare function parseInitializeMintInstruction<TProgram extends string, TAccountMetas extends readonly IAccountMeta[]>(instruction: IInstruction<TProgram> & IInstructionWithAccounts<TAccountMetas> & IInstructionWithData<Uint8Array>): ParsedInitializeMintInstruction<TProgram, TAccountMetas>;
//# sourceMappingURL=initializeMint.d.ts.map