/**
 * This code was AUTOGENERATED using the codama library.
 * Please DO NOT EDIT THIS FILE, instead use visitors
 * to add features, then rerun codama to update it.
 *
 * @see https://github.com/codama-idl/codama
 */
import { type Address, type Codec, type Decoder, type Encoder, type GetDiscriminatedUnionVariant, type GetDiscriminatedUnionVariantContent, type Option, type OptionOrNullable } from '@solana/kit';
import { type AccountState, type AccountStateArgs, type DecryptableBalance, type DecryptableBalanceArgs, type EncryptedBalance, type EncryptedBalanceArgs, type TransferFee, type TransferFeeArgs } from '.';
export type Extension = {
    __kind: 'Uninitialized';
} | {
    __kind: 'TransferFeeConfig';
    /** Optional authority to set the fee. */
    transferFeeConfigAuthority: Address;
    /** Withdraw from mint instructions must be signed by this key. */
    withdrawWithheldAuthority: Address;
    /** Withheld transfer fee tokens that have been moved to the mint for withdrawal. */
    withheldAmount: bigint;
    /** Older transfer fee, used if the current epoch < newerTransferFee.epoch. */
    olderTransferFee: TransferFee;
    /** Newer transfer fee, used if the current epoch >= newerTransferFee.epoch. */
    newerTransferFee: TransferFee;
} | {
    __kind: 'TransferFeeAmount';
    /** Withheld transfer fee tokens that can be claimed by the fee authority. */
    withheldAmount: bigint;
} | {
    __kind: 'MintCloseAuthority';
    closeAuthority: Address;
} | {
    __kind: 'ConfidentialTransferMint';
    /**
     * Authority to modify the `ConfidentialTransferMint` configuration and to
     * approve new accounts (if `auto_approve_new_accounts` is true).
     *
     * The legacy Token Multisig account is not supported as the authority.
     */
    authority: Option<Address>;
    /**
     * Indicate if newly configured accounts must be approved by the
     * `authority` before they may be used by the user.
     *
     * * If `true`, no approval is required and new accounts may be used immediately.
     * * If `false`, the authority must approve newly configured accounts (see
     *   `ConfidentialTransferInstruction::ConfigureAccount`).
     */
    autoApproveNewAccounts: boolean;
    /** Authority to decode any transfer amount in a confidential transfer. */
    auditorElgamalPubkey: Option<Address>;
} | {
    __kind: 'ConfidentialTransferAccount';
    /**
     * `true` if this account has been approved for use. All confidential
     * transfer operations for the account will fail until approval is granted.
     */
    approved: boolean;
    /** The public key associated with ElGamal encryption. */
    elgamalPubkey: Address;
    /** The low 16 bits of the pending balance (encrypted by `elgamal_pubkey`). */
    pendingBalanceLow: EncryptedBalance;
    /** The high 48 bits of the pending balance (encrypted by `elgamal_pubkey`). */
    pendingBalanceHigh: EncryptedBalance;
    /** The available balance (encrypted by `encrypiton_pubkey`). */
    availableBalance: EncryptedBalance;
    /** The decryptable available balance. */
    decryptableAvailableBalance: DecryptableBalance;
    /** If `false`, the extended account rejects any incoming confidential transfers. */
    allowConfidentialCredits: boolean;
    /** If `false`, the base account rejects any incoming transfers. */
    allowNonConfidentialCredits: boolean;
    /** The total number of `Deposit` and `Transfer` instructions that have credited `pending_balance`. */
    pendingBalanceCreditCounter: bigint;
    /**
     * The maximum number of `Deposit` and `Transfer` instructions that can
     * credit `pending_balance` before the `ApplyPendingBalance`
     * instruction is executed.
     */
    maximumPendingBalanceCreditCounter: bigint;
    /**
     * The `expected_pending_balance_credit_counter` value that was included in
     * the last `ApplyPendingBalance` instruction.
     */
    expectedPendingBalanceCreditCounter: bigint;
    /**
     * The actual `pending_balance_credit_counter` when the last
     * `ApplyPendingBalance` instruction was executed.
     */
    actualPendingBalanceCreditCounter: bigint;
} | {
    __kind: 'DefaultAccountState';
    state: AccountState;
} | {
    __kind: 'ImmutableOwner';
} | {
    __kind: 'MemoTransfer';
    /** Require transfers into this account to be accompanied by a memo. */
    requireIncomingTransferMemos: boolean;
} | {
    __kind: 'NonTransferable';
} | {
    __kind: 'InterestBearingConfig';
    rateAuthority: Address;
    initializationTimestamp: bigint;
    preUpdateAverageRate: number;
    lastUpdateTimestamp: bigint;
    currentRate: number;
} | {
    __kind: 'CpiGuard';
    /** Lock certain token operations from taking place within CPI for this account. */
    lockCpi: boolean;
} | {
    __kind: 'PermanentDelegate';
    delegate: Address;
} | {
    __kind: 'NonTransferableAccount';
} | {
    __kind: 'TransferHook';
    /** The transfer hook update authority. */
    authority: Address;
    /** The transfer hook program account. */
    programId: Address;
} | {
    __kind: 'TransferHookAccount';
    /**
     * Whether or not this account is currently transferring tokens
     * True during the transfer hook cpi, otherwise false.
     */
    transferring: boolean;
} | {
    __kind: 'ConfidentialTransferFee';
    /** Optional authority to set the withdraw withheld authority ElGamal key. */
    authority: Option<Address>;
    /**
     * Withheld fees from accounts must be encrypted with this ElGamal key.
     *
     * Note that whoever holds the ElGamal private key for this ElGamal public
     * key has the ability to decode any withheld fee amount that are
     * associated with accounts. When combined with the fee parameters, the
     * withheld fee amounts can reveal information about transfer amounts.
     */
    elgamalPubkey: Address;
    /** If `false`, the harvest of withheld tokens to mint is rejected. */
    harvestToMintEnabled: boolean;
    /**
     * Withheld confidential transfer fee tokens that have been moved to the
     * mint for withdrawal.
     */
    withheldAmount: EncryptedBalance;
} | {
    __kind: 'ConfidentialTransferFeeAmount';
    /** Amount withheld during confidential transfers, to be harvest to the mint. */
    withheldAmount: EncryptedBalance;
} | {
    __kind: 'MetadataPointer';
    /** Optional authority that can set the metadata address. */
    authority: Option<Address>;
    /** Optional Account Address that holds the metadata. */
    metadataAddress: Option<Address>;
} | {
    __kind: 'TokenMetadata';
    /** The authority that can sign to update the metadata. */
    updateAuthority: Option<Address>;
    /** The associated mint, used to counter spoofing to be sure that metadata belongs to a particular mint. */
    mint: Address;
    /** The longer name of the token. */
    name: string;
    /** The shortened symbol for the token. */
    symbol: string;
    /** The URI pointing to richer metadata. */
    uri: string;
    /** Any additional metadata about the token as key-value pairs. */
    additionalMetadata: Map<string, string>;
} | {
    __kind: 'GroupPointer';
    /** Optional authority that can set the group address. */
    authority: Option<Address>;
    /** Optional account address that holds the group. */
    groupAddress: Option<Address>;
} | {
    __kind: 'TokenGroup';
    /** The authority that can sign to update the group. */
    updateAuthority: Option<Address>;
    /** The associated mint, used to counter spoofing to be sure that group belongs to a particular mint. */
    mint: Address;
    /** The current number of group members. */
    size: bigint;
    /** The maximum number of group members. */
    maxSize: bigint;
} | {
    __kind: 'GroupMemberPointer';
    /** Optional authority that can set the member address. */
    authority: Option<Address>;
    /** Optional account address that holds the member. */
    memberAddress: Option<Address>;
} | {
    __kind: 'TokenGroupMember';
    /** The associated mint, used to counter spoofing to be sure that member belongs to a particular mint. */
    mint: Address;
    /** The pubkey of the `TokenGroup`. */
    group: Address;
    /** The member number. */
    memberNumber: bigint;
} | {
    __kind: 'ConfidentialMintBurn';
} | {
    __kind: 'ScaledUiAmountConfig';
    authority: Address;
    multiplier: number;
    newMultiplierEffectiveTimestamp: bigint;
    newMultiplier: number;
} | {
    __kind: 'PausableConfig';
    authority: Option<Address>;
    paused: boolean;
} | {
    __kind: 'PausableAccount';
};
export type ExtensionArgs = {
    __kind: 'Uninitialized';
} | {
    __kind: 'TransferFeeConfig';
    /** Optional authority to set the fee. */
    transferFeeConfigAuthority: Address;
    /** Withdraw from mint instructions must be signed by this key. */
    withdrawWithheldAuthority: Address;
    /** Withheld transfer fee tokens that have been moved to the mint for withdrawal. */
    withheldAmount: number | bigint;
    /** Older transfer fee, used if the current epoch < newerTransferFee.epoch. */
    olderTransferFee: TransferFeeArgs;
    /** Newer transfer fee, used if the current epoch >= newerTransferFee.epoch. */
    newerTransferFee: TransferFeeArgs;
} | {
    __kind: 'TransferFeeAmount';
    /** Withheld transfer fee tokens that can be claimed by the fee authority. */
    withheldAmount: number | bigint;
} | {
    __kind: 'MintCloseAuthority';
    closeAuthority: Address;
} | {
    __kind: 'ConfidentialTransferMint';
    /**
     * Authority to modify the `ConfidentialTransferMint` configuration and to
     * approve new accounts (if `auto_approve_new_accounts` is true).
     *
     * The legacy Token Multisig account is not supported as the authority.
     */
    authority: OptionOrNullable<Address>;
    /**
     * Indicate if newly configured accounts must be approved by the
     * `authority` before they may be used by the user.
     *
     * * If `true`, no approval is required and new accounts may be used immediately.
     * * If `false`, the authority must approve newly configured accounts (see
     *   `ConfidentialTransferInstruction::ConfigureAccount`).
     */
    autoApproveNewAccounts: boolean;
    /** Authority to decode any transfer amount in a confidential transfer. */
    auditorElgamalPubkey: OptionOrNullable<Address>;
} | {
    __kind: 'ConfidentialTransferAccount';
    /**
     * `true` if this account has been approved for use. All confidential
     * transfer operations for the account will fail until approval is granted.
     */
    approved: boolean;
    /** The public key associated with ElGamal encryption. */
    elgamalPubkey: Address;
    /** The low 16 bits of the pending balance (encrypted by `elgamal_pubkey`). */
    pendingBalanceLow: EncryptedBalanceArgs;
    /** The high 48 bits of the pending balance (encrypted by `elgamal_pubkey`). */
    pendingBalanceHigh: EncryptedBalanceArgs;
    /** The available balance (encrypted by `encrypiton_pubkey`). */
    availableBalance: EncryptedBalanceArgs;
    /** The decryptable available balance. */
    decryptableAvailableBalance: DecryptableBalanceArgs;
    /** If `false`, the extended account rejects any incoming confidential transfers. */
    allowConfidentialCredits: boolean;
    /** If `false`, the base account rejects any incoming transfers. */
    allowNonConfidentialCredits: boolean;
    /** The total number of `Deposit` and `Transfer` instructions that have credited `pending_balance`. */
    pendingBalanceCreditCounter: number | bigint;
    /**
     * The maximum number of `Deposit` and `Transfer` instructions that can
     * credit `pending_balance` before the `ApplyPendingBalance`
     * instruction is executed.
     */
    maximumPendingBalanceCreditCounter: number | bigint;
    /**
     * The `expected_pending_balance_credit_counter` value that was included in
     * the last `ApplyPendingBalance` instruction.
     */
    expectedPendingBalanceCreditCounter: number | bigint;
    /**
     * The actual `pending_balance_credit_counter` when the last
     * `ApplyPendingBalance` instruction was executed.
     */
    actualPendingBalanceCreditCounter: number | bigint;
} | {
    __kind: 'DefaultAccountState';
    state: AccountStateArgs;
} | {
    __kind: 'ImmutableOwner';
} | {
    __kind: 'MemoTransfer';
    /** Require transfers into this account to be accompanied by a memo. */
    requireIncomingTransferMemos: boolean;
} | {
    __kind: 'NonTransferable';
} | {
    __kind: 'InterestBearingConfig';
    rateAuthority: Address;
    initializationTimestamp: number | bigint;
    preUpdateAverageRate: number;
    lastUpdateTimestamp: number | bigint;
    currentRate: number;
} | {
    __kind: 'CpiGuard';
    /** Lock certain token operations from taking place within CPI for this account. */
    lockCpi: boolean;
} | {
    __kind: 'PermanentDelegate';
    delegate: Address;
} | {
    __kind: 'NonTransferableAccount';
} | {
    __kind: 'TransferHook';
    /** The transfer hook update authority. */
    authority: Address;
    /** The transfer hook program account. */
    programId: Address;
} | {
    __kind: 'TransferHookAccount';
    /**
     * Whether or not this account is currently transferring tokens
     * True during the transfer hook cpi, otherwise false.
     */
    transferring: boolean;
} | {
    __kind: 'ConfidentialTransferFee';
    /** Optional authority to set the withdraw withheld authority ElGamal key. */
    authority: OptionOrNullable<Address>;
    /**
     * Withheld fees from accounts must be encrypted with this ElGamal key.
     *
     * Note that whoever holds the ElGamal private key for this ElGamal public
     * key has the ability to decode any withheld fee amount that are
     * associated with accounts. When combined with the fee parameters, the
     * withheld fee amounts can reveal information about transfer amounts.
     */
    elgamalPubkey: Address;
    /** If `false`, the harvest of withheld tokens to mint is rejected. */
    harvestToMintEnabled: boolean;
    /**
     * Withheld confidential transfer fee tokens that have been moved to the
     * mint for withdrawal.
     */
    withheldAmount: EncryptedBalanceArgs;
} | {
    __kind: 'ConfidentialTransferFeeAmount';
    /** Amount withheld during confidential transfers, to be harvest to the mint. */
    withheldAmount: EncryptedBalanceArgs;
} | {
    __kind: 'MetadataPointer';
    /** Optional authority that can set the metadata address. */
    authority: OptionOrNullable<Address>;
    /** Optional Account Address that holds the metadata. */
    metadataAddress: OptionOrNullable<Address>;
} | {
    __kind: 'TokenMetadata';
    /** The authority that can sign to update the metadata. */
    updateAuthority: OptionOrNullable<Address>;
    /** The associated mint, used to counter spoofing to be sure that metadata belongs to a particular mint. */
    mint: Address;
    /** The longer name of the token. */
    name: string;
    /** The shortened symbol for the token. */
    symbol: string;
    /** The URI pointing to richer metadata. */
    uri: string;
    /** Any additional metadata about the token as key-value pairs. */
    additionalMetadata: Map<string, string>;
} | {
    __kind: 'GroupPointer';
    /** Optional authority that can set the group address. */
    authority: OptionOrNullable<Address>;
    /** Optional account address that holds the group. */
    groupAddress: OptionOrNullable<Address>;
} | {
    __kind: 'TokenGroup';
    /** The authority that can sign to update the group. */
    updateAuthority: OptionOrNullable<Address>;
    /** The associated mint, used to counter spoofing to be sure that group belongs to a particular mint. */
    mint: Address;
    /** The current number of group members. */
    size: number | bigint;
    /** The maximum number of group members. */
    maxSize: number | bigint;
} | {
    __kind: 'GroupMemberPointer';
    /** Optional authority that can set the member address. */
    authority: OptionOrNullable<Address>;
    /** Optional account address that holds the member. */
    memberAddress: OptionOrNullable<Address>;
} | {
    __kind: 'TokenGroupMember';
    /** The associated mint, used to counter spoofing to be sure that member belongs to a particular mint. */
    mint: Address;
    /** The pubkey of the `TokenGroup`. */
    group: Address;
    /** The member number. */
    memberNumber: number | bigint;
} | {
    __kind: 'ConfidentialMintBurn';
} | {
    __kind: 'ScaledUiAmountConfig';
    authority: Address;
    multiplier: number;
    newMultiplierEffectiveTimestamp: number | bigint;
    newMultiplier: number;
} | {
    __kind: 'PausableConfig';
    authority: OptionOrNullable<Address>;
    paused: boolean;
} | {
    __kind: 'PausableAccount';
};
export declare function getExtensionEncoder(): Encoder<ExtensionArgs>;
export declare function getExtensionDecoder(): Decoder<Extension>;
export declare function getExtensionCodec(): Codec<ExtensionArgs, Extension>;
export declare function extension(kind: 'Uninitialized'): GetDiscriminatedUnionVariant<ExtensionArgs, '__kind', 'Uninitialized'>;
export declare function extension(kind: 'TransferFeeConfig', data: GetDiscriminatedUnionVariantContent<ExtensionArgs, '__kind', 'TransferFeeConfig'>): GetDiscriminatedUnionVariant<ExtensionArgs, '__kind', 'TransferFeeConfig'>;
export declare function extension(kind: 'TransferFeeAmount', data: GetDiscriminatedUnionVariantContent<ExtensionArgs, '__kind', 'TransferFeeAmount'>): GetDiscriminatedUnionVariant<ExtensionArgs, '__kind', 'TransferFeeAmount'>;
export declare function extension(kind: 'MintCloseAuthority', data: GetDiscriminatedUnionVariantContent<ExtensionArgs, '__kind', 'MintCloseAuthority'>): GetDiscriminatedUnionVariant<ExtensionArgs, '__kind', 'MintCloseAuthority'>;
export declare function extension(kind: 'ConfidentialTransferMint', data: GetDiscriminatedUnionVariantContent<ExtensionArgs, '__kind', 'ConfidentialTransferMint'>): GetDiscriminatedUnionVariant<ExtensionArgs, '__kind', 'ConfidentialTransferMint'>;
export declare function extension(kind: 'ConfidentialTransferAccount', data: GetDiscriminatedUnionVariantContent<ExtensionArgs, '__kind', 'ConfidentialTransferAccount'>): GetDiscriminatedUnionVariant<ExtensionArgs, '__kind', 'ConfidentialTransferAccount'>;
export declare function extension(kind: 'DefaultAccountState', data: GetDiscriminatedUnionVariantContent<ExtensionArgs, '__kind', 'DefaultAccountState'>): GetDiscriminatedUnionVariant<ExtensionArgs, '__kind', 'DefaultAccountState'>;
export declare function extension(kind: 'ImmutableOwner', data: GetDiscriminatedUnionVariantContent<ExtensionArgs, '__kind', 'ImmutableOwner'>): GetDiscriminatedUnionVariant<ExtensionArgs, '__kind', 'ImmutableOwner'>;
export declare function extension(kind: 'MemoTransfer', data: GetDiscriminatedUnionVariantContent<ExtensionArgs, '__kind', 'MemoTransfer'>): GetDiscriminatedUnionVariant<ExtensionArgs, '__kind', 'MemoTransfer'>;
export declare function extension(kind: 'NonTransferable', data: GetDiscriminatedUnionVariantContent<ExtensionArgs, '__kind', 'NonTransferable'>): GetDiscriminatedUnionVariant<ExtensionArgs, '__kind', 'NonTransferable'>;
export declare function extension(kind: 'InterestBearingConfig', data: GetDiscriminatedUnionVariantContent<ExtensionArgs, '__kind', 'InterestBearingConfig'>): GetDiscriminatedUnionVariant<ExtensionArgs, '__kind', 'InterestBearingConfig'>;
export declare function extension(kind: 'CpiGuard', data: GetDiscriminatedUnionVariantContent<ExtensionArgs, '__kind', 'CpiGuard'>): GetDiscriminatedUnionVariant<ExtensionArgs, '__kind', 'CpiGuard'>;
export declare function extension(kind: 'PermanentDelegate', data: GetDiscriminatedUnionVariantContent<ExtensionArgs, '__kind', 'PermanentDelegate'>): GetDiscriminatedUnionVariant<ExtensionArgs, '__kind', 'PermanentDelegate'>;
export declare function extension(kind: 'NonTransferableAccount', data: GetDiscriminatedUnionVariantContent<ExtensionArgs, '__kind', 'NonTransferableAccount'>): GetDiscriminatedUnionVariant<ExtensionArgs, '__kind', 'NonTransferableAccount'>;
export declare function extension(kind: 'TransferHook', data: GetDiscriminatedUnionVariantContent<ExtensionArgs, '__kind', 'TransferHook'>): GetDiscriminatedUnionVariant<ExtensionArgs, '__kind', 'TransferHook'>;
export declare function extension(kind: 'TransferHookAccount', data: GetDiscriminatedUnionVariantContent<ExtensionArgs, '__kind', 'TransferHookAccount'>): GetDiscriminatedUnionVariant<ExtensionArgs, '__kind', 'TransferHookAccount'>;
export declare function extension(kind: 'ConfidentialTransferFee', data: GetDiscriminatedUnionVariantContent<ExtensionArgs, '__kind', 'ConfidentialTransferFee'>): GetDiscriminatedUnionVariant<ExtensionArgs, '__kind', 'ConfidentialTransferFee'>;
export declare function extension(kind: 'ConfidentialTransferFeeAmount', data: GetDiscriminatedUnionVariantContent<ExtensionArgs, '__kind', 'ConfidentialTransferFeeAmount'>): GetDiscriminatedUnionVariant<ExtensionArgs, '__kind', 'ConfidentialTransferFeeAmount'>;
export declare function extension(kind: 'MetadataPointer', data: GetDiscriminatedUnionVariantContent<ExtensionArgs, '__kind', 'MetadataPointer'>): GetDiscriminatedUnionVariant<ExtensionArgs, '__kind', 'MetadataPointer'>;
export declare function extension(kind: 'TokenMetadata', data: GetDiscriminatedUnionVariantContent<ExtensionArgs, '__kind', 'TokenMetadata'>): GetDiscriminatedUnionVariant<ExtensionArgs, '__kind', 'TokenMetadata'>;
export declare function extension(kind: 'GroupPointer', data: GetDiscriminatedUnionVariantContent<ExtensionArgs, '__kind', 'GroupPointer'>): GetDiscriminatedUnionVariant<ExtensionArgs, '__kind', 'GroupPointer'>;
export declare function extension(kind: 'TokenGroup', data: GetDiscriminatedUnionVariantContent<ExtensionArgs, '__kind', 'TokenGroup'>): GetDiscriminatedUnionVariant<ExtensionArgs, '__kind', 'TokenGroup'>;
export declare function extension(kind: 'GroupMemberPointer', data: GetDiscriminatedUnionVariantContent<ExtensionArgs, '__kind', 'GroupMemberPointer'>): GetDiscriminatedUnionVariant<ExtensionArgs, '__kind', 'GroupMemberPointer'>;
export declare function extension(kind: 'TokenGroupMember', data: GetDiscriminatedUnionVariantContent<ExtensionArgs, '__kind', 'TokenGroupMember'>): GetDiscriminatedUnionVariant<ExtensionArgs, '__kind', 'TokenGroupMember'>;
export declare function extension(kind: 'ConfidentialMintBurn'): GetDiscriminatedUnionVariant<ExtensionArgs, '__kind', 'ConfidentialMintBurn'>;
export declare function extension(kind: 'ScaledUiAmountConfig', data: GetDiscriminatedUnionVariantContent<ExtensionArgs, '__kind', 'ScaledUiAmountConfig'>): GetDiscriminatedUnionVariant<ExtensionArgs, '__kind', 'ScaledUiAmountConfig'>;
export declare function extension(kind: 'PausableConfig', data: GetDiscriminatedUnionVariantContent<ExtensionArgs, '__kind', 'PausableConfig'>): GetDiscriminatedUnionVariant<ExtensionArgs, '__kind', 'PausableConfig'>;
export declare function extension(kind: 'PausableAccount'): GetDiscriminatedUnionVariant<ExtensionArgs, '__kind', 'PausableAccount'>;
export declare function isExtension<K extends Extension['__kind']>(kind: K, value: Extension): value is Extension & {
    __kind: K;
};
//# sourceMappingURL=extension.d.ts.map