/**
 * This code was AUTOGENERATED using the codama library.
 * Please DO NOT EDIT THIS FILE, instead use visitors
 * to add features, then rerun codama to update it.
 *
 * @see https://github.com/codama-idl/codama
 */
import { type Address, type Codec, type Decoder, type Encoder, type IAccountMeta, type IAccountSignerMeta, type IInstruction, type IInstructionWithAccounts, type IInstructionWithData, type ReadonlyAccount, type ReadonlySignerAccount, type TransactionSigner, type WritableAccount } from '@solana/kit';
import { TOKEN_2022_PROGRAM_ADDRESS } from '../programs';
export declare const TRANSFER_CHECKED_WITH_FEE_DISCRIMINATOR = 26;
export declare function getTransferCheckedWithFeeDiscriminatorBytes(): import("@solana/kit").ReadonlyUint8Array;
export declare const TRANSFER_CHECKED_WITH_FEE_TRANSFER_FEE_DISCRIMINATOR = 1;
export declare function getTransferCheckedWithFeeTransferFeeDiscriminatorBytes(): import("@solana/kit").ReadonlyUint8Array;
export type TransferCheckedWithFeeInstruction<TProgram extends string = typeof TOKEN_2022_PROGRAM_ADDRESS, TAccountSource extends string | IAccountMeta<string> = string, TAccountMint extends string | IAccountMeta<string> = string, TAccountDestination extends string | IAccountMeta<string> = string, TAccountAuthority extends string | IAccountMeta<string> = string, TRemainingAccounts extends readonly IAccountMeta<string>[] = []> = IInstruction<TProgram> & IInstructionWithData<Uint8Array> & IInstructionWithAccounts<[
    TAccountSource extends string ? WritableAccount<TAccountSource> : TAccountSource,
    TAccountMint extends string ? ReadonlyAccount<TAccountMint> : TAccountMint,
    TAccountDestination extends string ? WritableAccount<TAccountDestination> : TAccountDestination,
    TAccountAuthority extends string ? ReadonlyAccount<TAccountAuthority> : TAccountAuthority,
    ...TRemainingAccounts
]>;
export type TransferCheckedWithFeeInstructionData = {
    discriminator: number;
    transferFeeDiscriminator: number;
    /** The amount of tokens to transfer. */
    amount: bigint;
    /** Expected number of base 10 digits to the right of the decimal place. */
    decimals: number;
    /**
     * Expected fee assessed on this transfer, calculated off-chain based
     * on the transfer_fee_basis_points and maximum_fee of the mint. May
     * be 0 for a mint without a configured transfer fee.
     */
    fee: bigint;
};
export type TransferCheckedWithFeeInstructionDataArgs = {
    /** The amount of tokens to transfer. */
    amount: number | bigint;
    /** Expected number of base 10 digits to the right of the decimal place. */
    decimals: number;
    /**
     * Expected fee assessed on this transfer, calculated off-chain based
     * on the transfer_fee_basis_points and maximum_fee of the mint. May
     * be 0 for a mint without a configured transfer fee.
     */
    fee: number | bigint;
};
export declare function getTransferCheckedWithFeeInstructionDataEncoder(): Encoder<TransferCheckedWithFeeInstructionDataArgs>;
export declare function getTransferCheckedWithFeeInstructionDataDecoder(): Decoder<TransferCheckedWithFeeInstructionData>;
export declare function getTransferCheckedWithFeeInstructionDataCodec(): Codec<TransferCheckedWithFeeInstructionDataArgs, TransferCheckedWithFeeInstructionData>;
export type TransferCheckedWithFeeInput<TAccountSource extends string = string, TAccountMint extends string = string, TAccountDestination extends string = string, TAccountAuthority extends string = string> = {
    /** The source account. May include the `TransferFeeAmount` extension. */
    source: Address<TAccountSource>;
    /** The token mint. May include the `TransferFeeConfig` extension. */
    mint: Address<TAccountMint>;
    /** The destination account. May include the `TransferFeeAmount` extension. */
    destination: Address<TAccountDestination>;
    /** The source account's owner/delegate or its multisignature account. */
    authority: Address<TAccountAuthority> | TransactionSigner<TAccountAuthority>;
    amount: TransferCheckedWithFeeInstructionDataArgs['amount'];
    decimals: TransferCheckedWithFeeInstructionDataArgs['decimals'];
    fee: TransferCheckedWithFeeInstructionDataArgs['fee'];
    multiSigners?: Array<TransactionSigner>;
};
export declare function getTransferCheckedWithFeeInstruction<TAccountSource extends string, TAccountMint extends string, TAccountDestination extends string, TAccountAuthority extends string, TProgramAddress extends Address = typeof TOKEN_2022_PROGRAM_ADDRESS>(input: TransferCheckedWithFeeInput<TAccountSource, TAccountMint, TAccountDestination, TAccountAuthority>, config?: {
    programAddress?: TProgramAddress;
}): TransferCheckedWithFeeInstruction<TProgramAddress, TAccountSource, TAccountMint, TAccountDestination, (typeof input)['authority'] extends TransactionSigner<TAccountAuthority> ? ReadonlySignerAccount<TAccountAuthority> & IAccountSignerMeta<TAccountAuthority> : TAccountAuthority>;
export type ParsedTransferCheckedWithFeeInstruction<TProgram extends string = typeof TOKEN_2022_PROGRAM_ADDRESS, TAccountMetas extends readonly IAccountMeta[] = readonly IAccountMeta[]> = {
    programAddress: Address<TProgram>;
    accounts: {
        /** The source account. May include the `TransferFeeAmount` extension. */
        source: TAccountMetas[0];
        /** The token mint. May include the `TransferFeeConfig` extension. */
        mint: TAccountMetas[1];
        /** The destination account. May include the `TransferFeeAmount` extension. */
        destination: TAccountMetas[2];
        /** The source account's owner/delegate or its multisignature account. */
        authority: TAccountMetas[3];
    };
    data: TransferCheckedWithFeeInstructionData;
};
export declare function parseTransferCheckedWithFeeInstruction<TProgram extends string, TAccountMetas extends readonly IAccountMeta[]>(instruction: IInstruction<TProgram> & IInstructionWithAccounts<TAccountMetas> & IInstructionWithData<Uint8Array>): ParsedTransferCheckedWithFeeInstruction<TProgram, TAccountMetas>;
//# sourceMappingURL=transferCheckedWithFee.d.ts.map