/**
 * This code was AUTOGENERATED using the codama library.
 * Please DO NOT EDIT THIS FILE, instead use visitors
 * to add features, then rerun codama to update it.
 *
 * @see https://github.com/codama-idl/codama
 */
import { type Address, type Codec, type Decoder, type Encoder, type IAccountMeta, type IAccountSignerMeta, type IInstruction, type IInstructionWithAccounts, type IInstructionWithData, type ReadonlyAccount, type ReadonlySignerAccount, type TransactionSigner, type WritableAccount } from '@solana/kit';
import { TOKEN_2022_PROGRAM_ADDRESS } from '../programs';
export declare const TRANSFER_DISCRIMINATOR = 3;
export declare function getTransferDiscriminatorBytes(): import("@solana/kit").ReadonlyUint8Array;
export type TransferInstruction<TProgram extends string = typeof TOKEN_2022_PROGRAM_ADDRESS, TAccountSource extends string | IAccountMeta<string> = string, TAccountDestination extends string | IAccountMeta<string> = string, TAccountAuthority extends string | IAccountMeta<string> = string, TRemainingAccounts extends readonly IAccountMeta<string>[] = []> = IInstruction<TProgram> & IInstructionWithData<Uint8Array> & IInstructionWithAccounts<[
    TAccountSource extends string ? WritableAccount<TAccountSource> : TAccountSource,
    TAccountDestination extends string ? WritableAccount<TAccountDestination> : TAccountDestination,
    TAccountAuthority extends string ? ReadonlyAccount<TAccountAuthority> : TAccountAuthority,
    ...TRemainingAccounts
]>;
export type TransferInstructionData = {
    discriminator: number;
    /** The amount of tokens to transfer. */
    amount: bigint;
};
export type TransferInstructionDataArgs = {
    /** The amount of tokens to transfer. */
    amount: number | bigint;
};
export declare function getTransferInstructionDataEncoder(): Encoder<TransferInstructionDataArgs>;
export declare function getTransferInstructionDataDecoder(): Decoder<TransferInstructionData>;
export declare function getTransferInstructionDataCodec(): Codec<TransferInstructionDataArgs, TransferInstructionData>;
export type TransferInput<TAccountSource extends string = string, TAccountDestination extends string = string, TAccountAuthority extends string = string> = {
    /** The source account. */
    source: Address<TAccountSource>;
    /** The destination account. */
    destination: Address<TAccountDestination>;
    /** The source account's owner/delegate or its multisignature account. */
    authority: Address<TAccountAuthority> | TransactionSigner<TAccountAuthority>;
    amount: TransferInstructionDataArgs['amount'];
    multiSigners?: Array<TransactionSigner>;
};
export declare function getTransferInstruction<TAccountSource extends string, TAccountDestination extends string, TAccountAuthority extends string, TProgramAddress extends Address = typeof TOKEN_2022_PROGRAM_ADDRESS>(input: TransferInput<TAccountSource, TAccountDestination, TAccountAuthority>, config?: {
    programAddress?: TProgramAddress;
}): TransferInstruction<TProgramAddress, TAccountSource, TAccountDestination, (typeof input)['authority'] extends TransactionSigner<TAccountAuthority> ? ReadonlySignerAccount<TAccountAuthority> & IAccountSignerMeta<TAccountAuthority> : TAccountAuthority>;
export type ParsedTransferInstruction<TProgram extends string = typeof TOKEN_2022_PROGRAM_ADDRESS, TAccountMetas extends readonly IAccountMeta[] = readonly IAccountMeta[]> = {
    programAddress: Address<TProgram>;
    accounts: {
        /** The source account. */
        source: TAccountMetas[0];
        /** The destination account. */
        destination: TAccountMetas[1];
        /** The source account's owner/delegate or its multisignature account. */
        authority: TAccountMetas[2];
    };
    data: TransferInstructionData;
};
export declare function parseTransferInstruction<TProgram extends string, TAccountMetas extends readonly IAccountMeta[]>(instruction: IInstruction<TProgram> & IInstructionWithAccounts<TAccountMetas> & IInstructionWithData<Uint8Array>): ParsedTransferInstruction<TProgram, TAccountMetas>;
//# sourceMappingURL=transfer.d.ts.map