/**
 * This code was AUTOGENERATED using the codama library.
 * Please DO NOT EDIT THIS FILE, instead use visitors
 * to add features, then rerun codama to update it.
 *
 * @see https://github.com/codama-idl/codama
 */
import { type Address, type Codec, type Decoder, type Encoder, type IAccountMeta, type IAccountSignerMeta, type IInstruction, type IInstructionWithAccounts, type IInstructionWithData, type ReadonlyAccount, type ReadonlySignerAccount, type TransactionSigner, type WritableAccount } from '@solana/kit';
import { TOKEN_2022_PROGRAM_ADDRESS } from '../programs';
export declare const MINT_TO_CHECKED_DISCRIMINATOR = 14;
export declare function getMintToCheckedDiscriminatorBytes(): import("@solana/kit").ReadonlyUint8Array;
export type MintToCheckedInstruction<TProgram extends string = typeof TOKEN_2022_PROGRAM_ADDRESS, TAccountMint extends string | IAccountMeta<string> = string, TAccountToken extends string | IAccountMeta<string> = string, TAccountMintAuthority extends string | IAccountMeta<string> = string, TRemainingAccounts extends readonly IAccountMeta<string>[] = []> = IInstruction<TProgram> & IInstructionWithData<Uint8Array> & IInstructionWithAccounts<[
    TAccountMint extends string ? WritableAccount<TAccountMint> : TAccountMint,
    TAccountToken extends string ? WritableAccount<TAccountToken> : TAccountToken,
    TAccountMintAuthority extends string ? ReadonlyAccount<TAccountMintAuthority> : TAccountMintAuthority,
    ...TRemainingAccounts
]>;
export type MintToCheckedInstructionData = {
    discriminator: number;
    /** The amount of new tokens to mint. */
    amount: bigint;
    /** Expected number of base 10 digits to the right of the decimal place. */
    decimals: number;
};
export type MintToCheckedInstructionDataArgs = {
    /** The amount of new tokens to mint. */
    amount: number | bigint;
    /** Expected number of base 10 digits to the right of the decimal place. */
    decimals: number;
};
export declare function getMintToCheckedInstructionDataEncoder(): Encoder<MintToCheckedInstructionDataArgs>;
export declare function getMintToCheckedInstructionDataDecoder(): Decoder<MintToCheckedInstructionData>;
export declare function getMintToCheckedInstructionDataCodec(): Codec<MintToCheckedInstructionDataArgs, MintToCheckedInstructionData>;
export type MintToCheckedInput<TAccountMint extends string = string, TAccountToken extends string = string, TAccountMintAuthority extends string = string> = {
    /** The mint. */
    mint: Address<TAccountMint>;
    /** The account to mint tokens to. */
    token: Address<TAccountToken>;
    /** The mint's minting authority or its multisignature account. */
    mintAuthority: Address<TAccountMintAuthority> | TransactionSigner<TAccountMintAuthority>;
    amount: MintToCheckedInstructionDataArgs['amount'];
    decimals: MintToCheckedInstructionDataArgs['decimals'];
    multiSigners?: Array<TransactionSigner>;
};
export declare function getMintToCheckedInstruction<TAccountMint extends string, TAccountToken extends string, TAccountMintAuthority extends string, TProgramAddress extends Address = typeof TOKEN_2022_PROGRAM_ADDRESS>(input: MintToCheckedInput<TAccountMint, TAccountToken, TAccountMintAuthority>, config?: {
    programAddress?: TProgramAddress;
}): MintToCheckedInstruction<TProgramAddress, TAccountMint, TAccountToken, (typeof input)['mintAuthority'] extends TransactionSigner<TAccountMintAuthority> ? ReadonlySignerAccount<TAccountMintAuthority> & IAccountSignerMeta<TAccountMintAuthority> : TAccountMintAuthority>;
export type ParsedMintToCheckedInstruction<TProgram extends string = typeof TOKEN_2022_PROGRAM_ADDRESS, TAccountMetas extends readonly IAccountMeta[] = readonly IAccountMeta[]> = {
    programAddress: Address<TProgram>;
    accounts: {
        /** The mint. */
        mint: TAccountMetas[0];
        /** The account to mint tokens to. */
        token: TAccountMetas[1];
        /** The mint's minting authority or its multisignature account. */
        mintAuthority: TAccountMetas[2];
    };
    data: MintToCheckedInstructionData;
};
export declare function parseMintToCheckedInstruction<TProgram extends string, TAccountMetas extends readonly IAccountMeta[]>(instruction: IInstruction<TProgram> & IInstructionWithAccounts<TAccountMetas> & IInstructionWithData<Uint8Array>): ParsedMintToCheckedInstruction<TProgram, TAccountMetas>;
//# sourceMappingURL=mintToChecked.d.ts.map