/**
 * This code was AUTOGENERATED using the codama library.
 * Please DO NOT EDIT THIS FILE, instead use visitors
 * to add features, then rerun codama to update it.
 *
 * @see https://github.com/codama-idl/codama
 */
import { type Address, type Codec, type Decoder, type Encoder, type IAccountMeta, type IAccountSignerMeta, type IInstruction, type IInstructionWithAccounts, type IInstructionWithData, type ReadonlyAccount, type ReadonlySignerAccount, type TransactionSigner, type WritableAccount } from '@solana/kit';
import { TOKEN_2022_PROGRAM_ADDRESS } from '../programs';
import { type DecryptableBalance, type DecryptableBalanceArgs } from '../types';
export declare const CONFIGURE_CONFIDENTIAL_TRANSFER_ACCOUNT_DISCRIMINATOR = 27;
export declare function getConfigureConfidentialTransferAccountDiscriminatorBytes(): import("@solana/kit").ReadonlyUint8Array;
export declare const CONFIGURE_CONFIDENTIAL_TRANSFER_ACCOUNT_CONFIDENTIAL_TRANSFER_DISCRIMINATOR = 2;
export declare function getConfigureConfidentialTransferAccountConfidentialTransferDiscriminatorBytes(): import("@solana/kit").ReadonlyUint8Array;
export type ConfigureConfidentialTransferAccountInstruction<TProgram extends string = typeof TOKEN_2022_PROGRAM_ADDRESS, TAccountToken extends string | IAccountMeta<string> = string, TAccountMint extends string | IAccountMeta<string> = string, TAccountInstructionsSysvarOrContextState extends string | IAccountMeta<string> = 'Sysvar1nstructions1111111111111111111111111', TAccountRecord extends string | IAccountMeta<string> = string, TAccountAuthority extends string | IAccountMeta<string> = string, TRemainingAccounts extends readonly IAccountMeta<string>[] = []> = IInstruction<TProgram> & IInstructionWithData<Uint8Array> & IInstructionWithAccounts<[
    TAccountToken extends string ? WritableAccount<TAccountToken> : TAccountToken,
    TAccountMint extends string ? ReadonlyAccount<TAccountMint> : TAccountMint,
    TAccountInstructionsSysvarOrContextState extends string ? ReadonlyAccount<TAccountInstructionsSysvarOrContextState> : TAccountInstructionsSysvarOrContextState,
    TAccountRecord extends string ? ReadonlyAccount<TAccountRecord> : TAccountRecord,
    TAccountAuthority extends string ? ReadonlyAccount<TAccountAuthority> : TAccountAuthority,
    ...TRemainingAccounts
]>;
export type ConfigureConfidentialTransferAccountInstructionData = {
    discriminator: number;
    confidentialTransferDiscriminator: number;
    /** The decryptable balance (always 0) once the configure account succeeds. */
    decryptableZeroBalance: DecryptableBalance;
    /**
     * The maximum number of despots and transfers that an account can receiver
     * before the `ApplyPendingBalance` is executed
     */
    maximumPendingBalanceCreditCounter: bigint;
    /**
     * Relative location of the `ProofInstruction::ZeroCiphertextProof`
     * instruction to the `ConfigureAccount` instruction in the
     * transaction. If the offset is `0`, then use a context state account
     * for the proof.
     */
    proofInstructionOffset: number;
};
export type ConfigureConfidentialTransferAccountInstructionDataArgs = {
    /** The decryptable balance (always 0) once the configure account succeeds. */
    decryptableZeroBalance: DecryptableBalanceArgs;
    /**
     * The maximum number of despots and transfers that an account can receiver
     * before the `ApplyPendingBalance` is executed
     */
    maximumPendingBalanceCreditCounter: number | bigint;
    /**
     * Relative location of the `ProofInstruction::ZeroCiphertextProof`
     * instruction to the `ConfigureAccount` instruction in the
     * transaction. If the offset is `0`, then use a context state account
     * for the proof.
     */
    proofInstructionOffset: number;
};
export declare function getConfigureConfidentialTransferAccountInstructionDataEncoder(): Encoder<ConfigureConfidentialTransferAccountInstructionDataArgs>;
export declare function getConfigureConfidentialTransferAccountInstructionDataDecoder(): Decoder<ConfigureConfidentialTransferAccountInstructionData>;
export declare function getConfigureConfidentialTransferAccountInstructionDataCodec(): Codec<ConfigureConfidentialTransferAccountInstructionDataArgs, ConfigureConfidentialTransferAccountInstructionData>;
export type ConfigureConfidentialTransferAccountInput<TAccountToken extends string = string, TAccountMint extends string = string, TAccountInstructionsSysvarOrContextState extends string = string, TAccountRecord extends string = string, TAccountAuthority extends string = string> = {
    /** The SPL Token account. */
    token: Address<TAccountToken>;
    /** The corresponding SPL Token mint. */
    mint: Address<TAccountMint>;
    /**
     * Instructions sysvar if `VerifyPubkeyValidity` is included in
     * the same transaction or context state account if
     * `VerifyPubkeyValidity` is pre-verified into a context state
     * account.
     */
    instructionsSysvarOrContextState?: Address<TAccountInstructionsSysvarOrContextState>;
    /** (Optional) Record account if the accompanying proof is to be read from a record account. */
    record?: Address<TAccountRecord>;
    /** The source account's owner/delegate or its multisignature account. */
    authority: Address<TAccountAuthority> | TransactionSigner<TAccountAuthority>;
    decryptableZeroBalance: ConfigureConfidentialTransferAccountInstructionDataArgs['decryptableZeroBalance'];
    maximumPendingBalanceCreditCounter: ConfigureConfidentialTransferAccountInstructionDataArgs['maximumPendingBalanceCreditCounter'];
    proofInstructionOffset: ConfigureConfidentialTransferAccountInstructionDataArgs['proofInstructionOffset'];
    multiSigners?: Array<TransactionSigner>;
};
export declare function getConfigureConfidentialTransferAccountInstruction<TAccountToken extends string, TAccountMint extends string, TAccountInstructionsSysvarOrContextState extends string, TAccountRecord extends string, TAccountAuthority extends string, TProgramAddress extends Address = typeof TOKEN_2022_PROGRAM_ADDRESS>(input: ConfigureConfidentialTransferAccountInput<TAccountToken, TAccountMint, TAccountInstructionsSysvarOrContextState, TAccountRecord, TAccountAuthority>, config?: {
    programAddress?: TProgramAddress;
}): ConfigureConfidentialTransferAccountInstruction<TProgramAddress, TAccountToken, TAccountMint, TAccountInstructionsSysvarOrContextState, TAccountRecord, (typeof input)['authority'] extends TransactionSigner<TAccountAuthority> ? ReadonlySignerAccount<TAccountAuthority> & IAccountSignerMeta<TAccountAuthority> : TAccountAuthority>;
export type ParsedConfigureConfidentialTransferAccountInstruction<TProgram extends string = typeof TOKEN_2022_PROGRAM_ADDRESS, TAccountMetas extends readonly IAccountMeta[] = readonly IAccountMeta[]> = {
    programAddress: Address<TProgram>;
    accounts: {
        /** The SPL Token account. */
        token: TAccountMetas[0];
        /** The corresponding SPL Token mint. */
        mint: TAccountMetas[1];
        /**
         * Instructions sysvar if `VerifyPubkeyValidity` is included in
         * the same transaction or context state account if
         * `VerifyPubkeyValidity` is pre-verified into a context state
         * account.
         */
        instructionsSysvarOrContextState: TAccountMetas[2];
        /** (Optional) Record account if the accompanying proof is to be read from a record account. */
        record?: TAccountMetas[3] | undefined;
        /** The source account's owner/delegate or its multisignature account. */
        authority: TAccountMetas[4];
    };
    data: ConfigureConfidentialTransferAccountInstructionData;
};
export declare function parseConfigureConfidentialTransferAccountInstruction<TProgram extends string, TAccountMetas extends readonly IAccountMeta[]>(instruction: IInstruction<TProgram> & IInstructionWithAccounts<TAccountMetas> & IInstructionWithData<Uint8Array>): ParsedConfigureConfidentialTransferAccountInstruction<TProgram, TAccountMetas>;
//# sourceMappingURL=configureConfidentialTransferAccount.d.ts.map