/**
 * This code was AUTOGENERATED using the codama library.
 * Please DO NOT EDIT THIS FILE, instead use visitors
 * to add features, then rerun codama to update it.
 *
 * @see https://github.com/codama-idl/codama
 */
import { type Address, type Codec, type Decoder, type Encoder, type IAccountMeta, type IAccountSignerMeta, type IInstruction, type IInstructionWithAccounts, type IInstructionWithData, type ReadonlyAccount, type ReadonlySignerAccount, type TransactionSigner, type WritableAccount } from '@solana/kit';
import { TOKEN_2022_PROGRAM_ADDRESS } from '../programs';
import { type DecryptableBalance, type DecryptableBalanceArgs } from '../types';
export declare const CONFIDENTIAL_TRANSFER_DISCRIMINATOR = 27;
export declare function getConfidentialTransferDiscriminatorBytes(): import("@solana/kit").ReadonlyUint8Array;
export declare const CONFIDENTIAL_TRANSFER_CONFIDENTIAL_TRANSFER_DISCRIMINATOR = 7;
export declare function getConfidentialTransferConfidentialTransferDiscriminatorBytes(): import("@solana/kit").ReadonlyUint8Array;
export type ConfidentialTransferInstruction<TProgram extends string = typeof TOKEN_2022_PROGRAM_ADDRESS, TAccountSourceToken extends string | IAccountMeta<string> = string, TAccountMint extends string | IAccountMeta<string> = string, TAccountDestinationToken extends string | IAccountMeta<string> = string, TAccountInstructionsSysvar extends string | IAccountMeta<string> = string, TAccountEqualityRecord extends string | IAccountMeta<string> = string, TAccountCiphertextValidityRecord extends string | IAccountMeta<string> = string, TAccountRangeRecord extends string | IAccountMeta<string> = string, TAccountAuthority extends string | IAccountMeta<string> = string, TRemainingAccounts extends readonly IAccountMeta<string>[] = []> = IInstruction<TProgram> & IInstructionWithData<Uint8Array> & IInstructionWithAccounts<[
    TAccountSourceToken extends string ? WritableAccount<TAccountSourceToken> : TAccountSourceToken,
    TAccountMint extends string ? ReadonlyAccount<TAccountMint> : TAccountMint,
    TAccountDestinationToken extends string ? WritableAccount<TAccountDestinationToken> : TAccountDestinationToken,
    TAccountInstructionsSysvar extends string ? ReadonlyAccount<TAccountInstructionsSysvar> : TAccountInstructionsSysvar,
    TAccountEqualityRecord extends string ? ReadonlyAccount<TAccountEqualityRecord> : TAccountEqualityRecord,
    TAccountCiphertextValidityRecord extends string ? ReadonlyAccount<TAccountCiphertextValidityRecord> : TAccountCiphertextValidityRecord,
    TAccountRangeRecord extends string ? ReadonlyAccount<TAccountRangeRecord> : TAccountRangeRecord,
    TAccountAuthority extends string ? ReadonlyAccount<TAccountAuthority> : TAccountAuthority,
    ...TRemainingAccounts
]>;
export type ConfidentialTransferInstructionData = {
    discriminator: number;
    confidentialTransferDiscriminator: number;
    /** The new source decryptable balance if the transfer succeeds. */
    newSourceDecryptableAvailableBalance: DecryptableBalance;
    /**
     * Relative location of the
     * `ProofInstruction::VerifyCiphertextCommitmentEquality` instruction
     * to the `Transfer` instruction in the transaction. If the offset is
     * `0`, then use a context state account for the proof.
     */
    equalityProofInstructionOffset: number;
    /**
     * Relative location of the
     * `ProofInstruction::VerifyBatchedGroupedCiphertext3HandlesValidity`
     * instruction to the `Transfer` instruction in the transaction. If the
     * offset is `0`, then use a context state account for the proof.
     */
    ciphertextValidityProofInstructionOffset: number;
    /**
     * Relative location of the `ProofInstruction::BatchedRangeProofU128Data`
     * instruction to the `Transfer` instruction in the transaction. If the
     * offset is `0`, then use a context state account for the proof.
     */
    rangeProofInstructionOffset: number;
};
export type ConfidentialTransferInstructionDataArgs = {
    /** The new source decryptable balance if the transfer succeeds. */
    newSourceDecryptableAvailableBalance: DecryptableBalanceArgs;
    /**
     * Relative location of the
     * `ProofInstruction::VerifyCiphertextCommitmentEquality` instruction
     * to the `Transfer` instruction in the transaction. If the offset is
     * `0`, then use a context state account for the proof.
     */
    equalityProofInstructionOffset: number;
    /**
     * Relative location of the
     * `ProofInstruction::VerifyBatchedGroupedCiphertext3HandlesValidity`
     * instruction to the `Transfer` instruction in the transaction. If the
     * offset is `0`, then use a context state account for the proof.
     */
    ciphertextValidityProofInstructionOffset: number;
    /**
     * Relative location of the `ProofInstruction::BatchedRangeProofU128Data`
     * instruction to the `Transfer` instruction in the transaction. If the
     * offset is `0`, then use a context state account for the proof.
     */
    rangeProofInstructionOffset: number;
};
export declare function getConfidentialTransferInstructionDataEncoder(): Encoder<ConfidentialTransferInstructionDataArgs>;
export declare function getConfidentialTransferInstructionDataDecoder(): Decoder<ConfidentialTransferInstructionData>;
export declare function getConfidentialTransferInstructionDataCodec(): Codec<ConfidentialTransferInstructionDataArgs, ConfidentialTransferInstructionData>;
export type ConfidentialTransferInput<TAccountSourceToken extends string = string, TAccountMint extends string = string, TAccountDestinationToken extends string = string, TAccountInstructionsSysvar extends string = string, TAccountEqualityRecord extends string = string, TAccountCiphertextValidityRecord extends string = string, TAccountRangeRecord extends string = string, TAccountAuthority extends string = string> = {
    /** The source SPL Token account. */
    sourceToken: Address<TAccountSourceToken>;
    /** The corresponding SPL Token mint. */
    mint: Address<TAccountMint>;
    /** The destination SPL Token account. */
    destinationToken: Address<TAccountDestinationToken>;
    /**
     * (Optional) Instructions sysvar if at least one of the
     * `zk_elgamal_proof` instructions are included in the same
     * transaction.
     */
    instructionsSysvar?: Address<TAccountInstructionsSysvar>;
    /** (Optional) Equality proof record account or context state account. */
    equalityRecord?: Address<TAccountEqualityRecord>;
    /** (Optional) Ciphertext validity proof record account or context state account. */
    ciphertextValidityRecord?: Address<TAccountCiphertextValidityRecord>;
    /** (Optional) Range proof record account or context state account. */
    rangeRecord?: Address<TAccountRangeRecord>;
    /** The source account's owner/delegate or its multisignature account. */
    authority: Address<TAccountAuthority> | TransactionSigner<TAccountAuthority>;
    newSourceDecryptableAvailableBalance: ConfidentialTransferInstructionDataArgs['newSourceDecryptableAvailableBalance'];
    equalityProofInstructionOffset: ConfidentialTransferInstructionDataArgs['equalityProofInstructionOffset'];
    ciphertextValidityProofInstructionOffset: ConfidentialTransferInstructionDataArgs['ciphertextValidityProofInstructionOffset'];
    rangeProofInstructionOffset: ConfidentialTransferInstructionDataArgs['rangeProofInstructionOffset'];
    multiSigners?: Array<TransactionSigner>;
};
export declare function getConfidentialTransferInstruction<TAccountSourceToken extends string, TAccountMint extends string, TAccountDestinationToken extends string, TAccountInstructionsSysvar extends string, TAccountEqualityRecord extends string, TAccountCiphertextValidityRecord extends string, TAccountRangeRecord extends string, TAccountAuthority extends string, TProgramAddress extends Address = typeof TOKEN_2022_PROGRAM_ADDRESS>(input: ConfidentialTransferInput<TAccountSourceToken, TAccountMint, TAccountDestinationToken, TAccountInstructionsSysvar, TAccountEqualityRecord, TAccountCiphertextValidityRecord, TAccountRangeRecord, TAccountAuthority>, config?: {
    programAddress?: TProgramAddress;
}): ConfidentialTransferInstruction<TProgramAddress, TAccountSourceToken, TAccountMint, TAccountDestinationToken, TAccountInstructionsSysvar, TAccountEqualityRecord, TAccountCiphertextValidityRecord, TAccountRangeRecord, (typeof input)['authority'] extends TransactionSigner<TAccountAuthority> ? ReadonlySignerAccount<TAccountAuthority> & IAccountSignerMeta<TAccountAuthority> : TAccountAuthority>;
export type ParsedConfidentialTransferInstruction<TProgram extends string = typeof TOKEN_2022_PROGRAM_ADDRESS, TAccountMetas extends readonly IAccountMeta[] = readonly IAccountMeta[]> = {
    programAddress: Address<TProgram>;
    accounts: {
        /** The source SPL Token account. */
        sourceToken: TAccountMetas[0];
        /** The corresponding SPL Token mint. */
        mint: TAccountMetas[1];
        /** The destination SPL Token account. */
        destinationToken: TAccountMetas[2];
        /**
         * (Optional) Instructions sysvar if at least one of the
         * `zk_elgamal_proof` instructions are included in the same
         * transaction.
         */
        instructionsSysvar?: TAccountMetas[3] | undefined;
        /** (Optional) Equality proof record account or context state account. */
        equalityRecord?: TAccountMetas[4] | undefined;
        /** (Optional) Ciphertext validity proof record account or context state account. */
        ciphertextValidityRecord?: TAccountMetas[5] | undefined;
        /** (Optional) Range proof record account or context state account. */
        rangeRecord?: TAccountMetas[6] | undefined;
        /** The source account's owner/delegate or its multisignature account. */
        authority: TAccountMetas[7];
    };
    data: ConfidentialTransferInstructionData;
};
export declare function parseConfidentialTransferInstruction<TProgram extends string, TAccountMetas extends readonly IAccountMeta[]>(instruction: IInstruction<TProgram> & IInstructionWithAccounts<TAccountMetas> & IInstructionWithData<Uint8Array>): ParsedConfidentialTransferInstruction<TProgram, TAccountMetas>;
//# sourceMappingURL=confidentialTransfer.d.ts.map