/**
 * This code was AUTOGENERATED using the codama library.
 * Please DO NOT EDIT THIS FILE, instead use visitors
 * to add features, then rerun codama to update it.
 *
 * @see https://github.com/codama-idl/codama
 */
import { type Address, type Codec, type Decoder, type Encoder, type IAccountMeta, type IAccountSignerMeta, type IInstruction, type IInstructionWithAccounts, type IInstructionWithData, type ReadonlyAccount, type ReadonlySignerAccount, type TransactionSigner, type WritableAccount } from '@solana/kit';
import { TOKEN_2022_PROGRAM_ADDRESS } from '../programs';
export declare const BURN_CHECKED_DISCRIMINATOR = 15;
export declare function getBurnCheckedDiscriminatorBytes(): import("@solana/kit").ReadonlyUint8Array;
export type BurnCheckedInstruction<TProgram extends string = typeof TOKEN_2022_PROGRAM_ADDRESS, TAccountAccount extends string | IAccountMeta<string> = string, TAccountMint extends string | IAccountMeta<string> = string, TAccountAuthority extends string | IAccountMeta<string> = string, TRemainingAccounts extends readonly IAccountMeta<string>[] = []> = IInstruction<TProgram> & IInstructionWithData<Uint8Array> & IInstructionWithAccounts<[
    TAccountAccount extends string ? WritableAccount<TAccountAccount> : TAccountAccount,
    TAccountMint extends string ? WritableAccount<TAccountMint> : TAccountMint,
    TAccountAuthority extends string ? ReadonlyAccount<TAccountAuthority> : TAccountAuthority,
    ...TRemainingAccounts
]>;
export type BurnCheckedInstructionData = {
    discriminator: number;
    /** The amount of tokens to burn. */
    amount: bigint;
    /** Expected number of base 10 digits to the right of the decimal place. */
    decimals: number;
};
export type BurnCheckedInstructionDataArgs = {
    /** The amount of tokens to burn. */
    amount: number | bigint;
    /** Expected number of base 10 digits to the right of the decimal place. */
    decimals: number;
};
export declare function getBurnCheckedInstructionDataEncoder(): Encoder<BurnCheckedInstructionDataArgs>;
export declare function getBurnCheckedInstructionDataDecoder(): Decoder<BurnCheckedInstructionData>;
export declare function getBurnCheckedInstructionDataCodec(): Codec<BurnCheckedInstructionDataArgs, BurnCheckedInstructionData>;
export type BurnCheckedInput<TAccountAccount extends string = string, TAccountMint extends string = string, TAccountAuthority extends string = string> = {
    /** The account to burn from. */
    account: Address<TAccountAccount>;
    /** The token mint. */
    mint: Address<TAccountMint>;
    /** The account's owner/delegate or its multisignature account. */
    authority: Address<TAccountAuthority> | TransactionSigner<TAccountAuthority>;
    amount: BurnCheckedInstructionDataArgs['amount'];
    decimals: BurnCheckedInstructionDataArgs['decimals'];
    multiSigners?: Array<TransactionSigner>;
};
export declare function getBurnCheckedInstruction<TAccountAccount extends string, TAccountMint extends string, TAccountAuthority extends string, TProgramAddress extends Address = typeof TOKEN_2022_PROGRAM_ADDRESS>(input: BurnCheckedInput<TAccountAccount, TAccountMint, TAccountAuthority>, config?: {
    programAddress?: TProgramAddress;
}): BurnCheckedInstruction<TProgramAddress, TAccountAccount, TAccountMint, (typeof input)['authority'] extends TransactionSigner<TAccountAuthority> ? ReadonlySignerAccount<TAccountAuthority> & IAccountSignerMeta<TAccountAuthority> : TAccountAuthority>;
export type ParsedBurnCheckedInstruction<TProgram extends string = typeof TOKEN_2022_PROGRAM_ADDRESS, TAccountMetas extends readonly IAccountMeta[] = readonly IAccountMeta[]> = {
    programAddress: Address<TProgram>;
    accounts: {
        /** The account to burn from. */
        account: TAccountMetas[0];
        /** The token mint. */
        mint: TAccountMetas[1];
        /** The account's owner/delegate or its multisignature account. */
        authority: TAccountMetas[2];
    };
    data: BurnCheckedInstructionData;
};
export declare function parseBurnCheckedInstruction<TProgram extends string, TAccountMetas extends readonly IAccountMeta[]>(instruction: IInstruction<TProgram> & IInstructionWithAccounts<TAccountMetas> & IInstructionWithData<Uint8Array>): ParsedBurnCheckedInstruction<TProgram, TAccountMetas>;
//# sourceMappingURL=burnChecked.d.ts.map