/**
 * This code was AUTOGENERATED using the codama library.
 * Please DO NOT EDIT THIS FILE, instead use visitors
 * to add features, then rerun codama to update it.
 *
 * @see https://github.com/codama-idl/codama
 */
import { type Address, type Codec, type Decoder, type Encoder, type IAccountMeta, type IAccountSignerMeta, type IInstruction, type IInstructionWithAccounts, type IInstructionWithData, type ReadonlyAccount, type ReadonlySignerAccount, type TransactionSigner, type WritableAccount } from '@solana/kit';
import { TOKEN_2022_PROGRAM_ADDRESS } from '../programs';
export declare const APPROVE_CHECKED_DISCRIMINATOR = 13;
export declare function getApproveCheckedDiscriminatorBytes(): import("@solana/kit").ReadonlyUint8Array;
export type ApproveCheckedInstruction<TProgram extends string = typeof TOKEN_2022_PROGRAM_ADDRESS, TAccountSource extends string | IAccountMeta<string> = string, TAccountMint extends string | IAccountMeta<string> = string, TAccountDelegate extends string | IAccountMeta<string> = string, TAccountOwner extends string | IAccountMeta<string> = string, TRemainingAccounts extends readonly IAccountMeta<string>[] = []> = IInstruction<TProgram> & IInstructionWithData<Uint8Array> & IInstructionWithAccounts<[
    TAccountSource extends string ? WritableAccount<TAccountSource> : TAccountSource,
    TAccountMint extends string ? ReadonlyAccount<TAccountMint> : TAccountMint,
    TAccountDelegate extends string ? ReadonlyAccount<TAccountDelegate> : TAccountDelegate,
    TAccountOwner extends string ? ReadonlyAccount<TAccountOwner> : TAccountOwner,
    ...TRemainingAccounts
]>;
export type ApproveCheckedInstructionData = {
    discriminator: number;
    /** The amount of tokens the delegate is approved for. */
    amount: bigint;
    /** Expected number of base 10 digits to the right of the decimal place. */
    decimals: number;
};
export type ApproveCheckedInstructionDataArgs = {
    /** The amount of tokens the delegate is approved for. */
    amount: number | bigint;
    /** Expected number of base 10 digits to the right of the decimal place. */
    decimals: number;
};
export declare function getApproveCheckedInstructionDataEncoder(): Encoder<ApproveCheckedInstructionDataArgs>;
export declare function getApproveCheckedInstructionDataDecoder(): Decoder<ApproveCheckedInstructionData>;
export declare function getApproveCheckedInstructionDataCodec(): Codec<ApproveCheckedInstructionDataArgs, ApproveCheckedInstructionData>;
export type ApproveCheckedInput<TAccountSource extends string = string, TAccountMint extends string = string, TAccountDelegate extends string = string, TAccountOwner extends string = string> = {
    /** The source account. */
    source: Address<TAccountSource>;
    /** The token mint. */
    mint: Address<TAccountMint>;
    /** The delegate. */
    delegate: Address<TAccountDelegate>;
    /** The source account owner or its multisignature account. */
    owner: Address<TAccountOwner> | TransactionSigner<TAccountOwner>;
    amount: ApproveCheckedInstructionDataArgs['amount'];
    decimals: ApproveCheckedInstructionDataArgs['decimals'];
    multiSigners?: Array<TransactionSigner>;
};
export declare function getApproveCheckedInstruction<TAccountSource extends string, TAccountMint extends string, TAccountDelegate extends string, TAccountOwner extends string, TProgramAddress extends Address = typeof TOKEN_2022_PROGRAM_ADDRESS>(input: ApproveCheckedInput<TAccountSource, TAccountMint, TAccountDelegate, TAccountOwner>, config?: {
    programAddress?: TProgramAddress;
}): ApproveCheckedInstruction<TProgramAddress, TAccountSource, TAccountMint, TAccountDelegate, (typeof input)['owner'] extends TransactionSigner<TAccountOwner> ? ReadonlySignerAccount<TAccountOwner> & IAccountSignerMeta<TAccountOwner> : TAccountOwner>;
export type ParsedApproveCheckedInstruction<TProgram extends string = typeof TOKEN_2022_PROGRAM_ADDRESS, TAccountMetas extends readonly IAccountMeta[] = readonly IAccountMeta[]> = {
    programAddress: Address<TProgram>;
    accounts: {
        /** The source account. */
        source: TAccountMetas[0];
        /** The token mint. */
        mint: TAccountMetas[1];
        /** The delegate. */
        delegate: TAccountMetas[2];
        /** The source account owner or its multisignature account. */
        owner: TAccountMetas[3];
    };
    data: ApproveCheckedInstructionData;
};
export declare function parseApproveCheckedInstruction<TProgram extends string, TAccountMetas extends readonly IAccountMeta[]>(instruction: IInstruction<TProgram> & IInstructionWithAccounts<TAccountMetas> & IInstructionWithData<Uint8Array>): ParsedApproveCheckedInstruction<TProgram, TAccountMetas>;
//# sourceMappingURL=approveChecked.d.ts.map