/**
 * This code was AUTOGENERATED using the codama library.
 * Please DO NOT EDIT THIS FILE, instead use visitors
 * to add features, then rerun codama to update it.
 *
 * @see https://github.com/codama-idl/codama
 */
import { type Address, type Codec, type Decoder, type Encoder, type IAccountMeta, type IAccountSignerMeta, type IInstruction, type IInstructionWithAccounts, type IInstructionWithData, type ReadonlyAccount, type ReadonlySignerAccount, type TransactionSigner, type WritableAccount } from '@solana/kit';
import { TOKEN_2022_PROGRAM_ADDRESS } from '../programs';
import { type DecryptableBalance, type DecryptableBalanceArgs } from '../types';
export declare const APPLY_CONFIDENTIAL_PENDING_BALANCE_DISCRIMINATOR = 27;
export declare function getApplyConfidentialPendingBalanceDiscriminatorBytes(): import("@solana/kit").ReadonlyUint8Array;
export declare const APPLY_CONFIDENTIAL_PENDING_BALANCE_CONFIDENTIAL_TRANSFER_DISCRIMINATOR = 8;
export declare function getApplyConfidentialPendingBalanceConfidentialTransferDiscriminatorBytes(): import("@solana/kit").ReadonlyUint8Array;
export type ApplyConfidentialPendingBalanceInstruction<TProgram extends string = typeof TOKEN_2022_PROGRAM_ADDRESS, TAccountToken extends string | IAccountMeta<string> = string, TAccountAuthority extends string | IAccountMeta<string> = string, TRemainingAccounts extends readonly IAccountMeta<string>[] = []> = IInstruction<TProgram> & IInstructionWithData<Uint8Array> & IInstructionWithAccounts<[
    TAccountToken extends string ? WritableAccount<TAccountToken> : TAccountToken,
    TAccountAuthority extends string ? ReadonlyAccount<TAccountAuthority> : TAccountAuthority,
    ...TRemainingAccounts
]>;
export type ApplyConfidentialPendingBalanceInstructionData = {
    discriminator: number;
    confidentialTransferDiscriminator: number;
    /**
     * The expected number of pending balance credits since the last successful
     * `ApplyPendingBalance` instruction
     */
    expectedPendingBalanceCreditCounter: bigint;
    /**
     * The new decryptable balance if the pending balance is applied
     * successfully
     */
    newDecryptableAvailableBalance: DecryptableBalance;
};
export type ApplyConfidentialPendingBalanceInstructionDataArgs = {
    /**
     * The expected number of pending balance credits since the last successful
     * `ApplyPendingBalance` instruction
     */
    expectedPendingBalanceCreditCounter: number | bigint;
    /**
     * The new decryptable balance if the pending balance is applied
     * successfully
     */
    newDecryptableAvailableBalance: DecryptableBalanceArgs;
};
export declare function getApplyConfidentialPendingBalanceInstructionDataEncoder(): Encoder<ApplyConfidentialPendingBalanceInstructionDataArgs>;
export declare function getApplyConfidentialPendingBalanceInstructionDataDecoder(): Decoder<ApplyConfidentialPendingBalanceInstructionData>;
export declare function getApplyConfidentialPendingBalanceInstructionDataCodec(): Codec<ApplyConfidentialPendingBalanceInstructionDataArgs, ApplyConfidentialPendingBalanceInstructionData>;
export type ApplyConfidentialPendingBalanceInput<TAccountToken extends string = string, TAccountAuthority extends string = string> = {
    /** The SPL Token account. */
    token: Address<TAccountToken>;
    /** The source account's owner/delegate or its multisignature account. */
    authority: Address<TAccountAuthority> | TransactionSigner<TAccountAuthority>;
    expectedPendingBalanceCreditCounter: ApplyConfidentialPendingBalanceInstructionDataArgs['expectedPendingBalanceCreditCounter'];
    newDecryptableAvailableBalance: ApplyConfidentialPendingBalanceInstructionDataArgs['newDecryptableAvailableBalance'];
    multiSigners?: Array<TransactionSigner>;
};
export declare function getApplyConfidentialPendingBalanceInstruction<TAccountToken extends string, TAccountAuthority extends string, TProgramAddress extends Address = typeof TOKEN_2022_PROGRAM_ADDRESS>(input: ApplyConfidentialPendingBalanceInput<TAccountToken, TAccountAuthority>, config?: {
    programAddress?: TProgramAddress;
}): ApplyConfidentialPendingBalanceInstruction<TProgramAddress, TAccountToken, (typeof input)['authority'] extends TransactionSigner<TAccountAuthority> ? ReadonlySignerAccount<TAccountAuthority> & IAccountSignerMeta<TAccountAuthority> : TAccountAuthority>;
export type ParsedApplyConfidentialPendingBalanceInstruction<TProgram extends string = typeof TOKEN_2022_PROGRAM_ADDRESS, TAccountMetas extends readonly IAccountMeta[] = readonly IAccountMeta[]> = {
    programAddress: Address<TProgram>;
    accounts: {
        /** The SPL Token account. */
        token: TAccountMetas[0];
        /** The source account's owner/delegate or its multisignature account. */
        authority: TAccountMetas[1];
    };
    data: ApplyConfidentialPendingBalanceInstructionData;
};
export declare function parseApplyConfidentialPendingBalanceInstruction<TProgram extends string, TAccountMetas extends readonly IAccountMeta[]>(instruction: IInstruction<TProgram> & IInstructionWithAccounts<TAccountMetas> & IInstructionWithData<Uint8Array>): ParsedApplyConfidentialPendingBalanceInstruction<TProgram, TAccountMetas>;
//# sourceMappingURL=applyConfidentialPendingBalance.d.ts.map