/**
 * This code was AUTOGENERATED using the codama library.
 * Please DO NOT EDIT THIS FILE, instead use visitors
 * to add features, then rerun codama to update it.
 *
 * @see https://github.com/codama-idl/codama
 */
import { type Address, type Codec, type Decoder, type Encoder, type IAccountMeta, type IAccountSignerMeta, type IInstruction, type IInstructionWithAccounts, type IInstructionWithData, type Option, type OptionOrNullable, type ReadonlySignerAccount, type TransactionSigner, type WritableAccount } from '@solana/kit';
import { STAKE_PROGRAM_ADDRESS } from '../programs';
export declare const SET_LOCKUP_DISCRIMINATOR = 6;
export declare function getSetLockupDiscriminatorBytes(): import("@solana/kit").ReadonlyUint8Array;
export type SetLockupInstruction<TProgram extends string = typeof STAKE_PROGRAM_ADDRESS, TAccountStake extends string | IAccountMeta<string> = string, TAccountAuthority extends string | IAccountMeta<string> = string, TRemainingAccounts extends readonly IAccountMeta<string>[] = []> = IInstruction<TProgram> & IInstructionWithData<Uint8Array> & IInstructionWithAccounts<[
    TAccountStake extends string ? WritableAccount<TAccountStake> : TAccountStake,
    TAccountAuthority extends string ? ReadonlySignerAccount<TAccountAuthority> & IAccountSignerMeta<TAccountAuthority> : TAccountAuthority,
    ...TRemainingAccounts
]>;
export type SetLockupInstructionData = {
    discriminator: number;
    unixTimestamp: Option<bigint>;
    epoch: Option<bigint>;
    custodian: Option<Address>;
};
export type SetLockupInstructionDataArgs = {
    unixTimestamp: OptionOrNullable<number | bigint>;
    epoch: OptionOrNullable<number | bigint>;
    custodian: OptionOrNullable<Address>;
};
export declare function getSetLockupInstructionDataEncoder(): Encoder<SetLockupInstructionDataArgs>;
export declare function getSetLockupInstructionDataDecoder(): Decoder<SetLockupInstructionData>;
export declare function getSetLockupInstructionDataCodec(): Codec<SetLockupInstructionDataArgs, SetLockupInstructionData>;
export type SetLockupInput<TAccountStake extends string = string, TAccountAuthority extends string = string> = {
    /** Initialized stake account */
    stake: Address<TAccountStake>;
    /** Lockup authority or withdraw authority */
    authority: TransactionSigner<TAccountAuthority>;
    unixTimestamp: SetLockupInstructionDataArgs['unixTimestamp'];
    epoch: SetLockupInstructionDataArgs['epoch'];
    custodian: SetLockupInstructionDataArgs['custodian'];
};
export declare function getSetLockupInstruction<TAccountStake extends string, TAccountAuthority extends string, TProgramAddress extends Address = typeof STAKE_PROGRAM_ADDRESS>(input: SetLockupInput<TAccountStake, TAccountAuthority>, config?: {
    programAddress?: TProgramAddress;
}): SetLockupInstruction<TProgramAddress, TAccountStake, TAccountAuthority>;
export type ParsedSetLockupInstruction<TProgram extends string = typeof STAKE_PROGRAM_ADDRESS, TAccountMetas extends readonly IAccountMeta[] = readonly IAccountMeta[]> = {
    programAddress: Address<TProgram>;
    accounts: {
        /** Initialized stake account */
        stake: TAccountMetas[0];
        /** Lockup authority or withdraw authority */
        authority: TAccountMetas[1];
    };
    data: SetLockupInstructionData;
};
export declare function parseSetLockupInstruction<TProgram extends string, TAccountMetas extends readonly IAccountMeta[]>(instruction: IInstruction<TProgram> & IInstructionWithAccounts<TAccountMetas> & IInstructionWithData<Uint8Array>): ParsedSetLockupInstruction<TProgram, TAccountMetas>;
//# sourceMappingURL=setLockup.d.ts.map