/**
 * This code was AUTOGENERATED using the codama library.
 * Please DO NOT EDIT THIS FILE, instead use visitors
 * to add features, then rerun codama to update it.
 *
 * @see https://github.com/codama-idl/codama
 */
import { type Address, type Codec, type Decoder, type Encoder, type IAccountMeta, type IAccountSignerMeta, type IInstruction, type IInstructionWithAccounts, type IInstructionWithData, type ReadonlyAccount, type ReadonlySignerAccount, type TransactionSigner, type WritableAccount } from '@solana/kit';
import { STAKE_PROGRAM_ADDRESS } from '../programs';
export declare const DELEGATE_STAKE_DISCRIMINATOR = 2;
export declare function getDelegateStakeDiscriminatorBytes(): import("@solana/kit").ReadonlyUint8Array;
export type DelegateStakeInstruction<TProgram extends string = typeof STAKE_PROGRAM_ADDRESS, TAccountStake extends string | IAccountMeta<string> = string, TAccountVote extends string | IAccountMeta<string> = string, TAccountClockSysvar extends string | IAccountMeta<string> = 'SysvarC1ock11111111111111111111111111111111', TAccountStakeHistory extends string | IAccountMeta<string> = string, TAccountUnused extends string | IAccountMeta<string> = string, TAccountStakeAuthority extends string | IAccountMeta<string> = string, TRemainingAccounts extends readonly IAccountMeta<string>[] = []> = IInstruction<TProgram> & IInstructionWithData<Uint8Array> & IInstructionWithAccounts<[
    TAccountStake extends string ? WritableAccount<TAccountStake> : TAccountStake,
    TAccountVote extends string ? ReadonlyAccount<TAccountVote> : TAccountVote,
    TAccountClockSysvar extends string ? ReadonlyAccount<TAccountClockSysvar> : TAccountClockSysvar,
    TAccountStakeHistory extends string ? ReadonlyAccount<TAccountStakeHistory> : TAccountStakeHistory,
    TAccountUnused extends string ? ReadonlyAccount<TAccountUnused> : TAccountUnused,
    TAccountStakeAuthority extends string ? ReadonlySignerAccount<TAccountStakeAuthority> & IAccountSignerMeta<TAccountStakeAuthority> : TAccountStakeAuthority,
    ...TRemainingAccounts
]>;
export type DelegateStakeInstructionData = {
    discriminator: number;
};
export type DelegateStakeInstructionDataArgs = {};
export declare function getDelegateStakeInstructionDataEncoder(): Encoder<DelegateStakeInstructionDataArgs>;
export declare function getDelegateStakeInstructionDataDecoder(): Decoder<DelegateStakeInstructionData>;
export declare function getDelegateStakeInstructionDataCodec(): Codec<DelegateStakeInstructionDataArgs, DelegateStakeInstructionData>;
export type DelegateStakeInput<TAccountStake extends string = string, TAccountVote extends string = string, TAccountClockSysvar extends string = string, TAccountStakeHistory extends string = string, TAccountUnused extends string = string, TAccountStakeAuthority extends string = string> = {
    /** Initialized stake account to be delegated */
    stake: Address<TAccountStake>;
    /** Vote account to which this stake will be delegated */
    vote: Address<TAccountVote>;
    /** Clock sysvar */
    clockSysvar?: Address<TAccountClockSysvar>;
    /** Stake history sysvar */
    stakeHistory: Address<TAccountStakeHistory>;
    /** Unused account, formerly the stake config */
    unused: Address<TAccountUnused>;
    /** Stake authority */
    stakeAuthority: TransactionSigner<TAccountStakeAuthority>;
};
export declare function getDelegateStakeInstruction<TAccountStake extends string, TAccountVote extends string, TAccountClockSysvar extends string, TAccountStakeHistory extends string, TAccountUnused extends string, TAccountStakeAuthority extends string, TProgramAddress extends Address = typeof STAKE_PROGRAM_ADDRESS>(input: DelegateStakeInput<TAccountStake, TAccountVote, TAccountClockSysvar, TAccountStakeHistory, TAccountUnused, TAccountStakeAuthority>, config?: {
    programAddress?: TProgramAddress;
}): DelegateStakeInstruction<TProgramAddress, TAccountStake, TAccountVote, TAccountClockSysvar, TAccountStakeHistory, TAccountUnused, TAccountStakeAuthority>;
export type ParsedDelegateStakeInstruction<TProgram extends string = typeof STAKE_PROGRAM_ADDRESS, TAccountMetas extends readonly IAccountMeta[] = readonly IAccountMeta[]> = {
    programAddress: Address<TProgram>;
    accounts: {
        /** Initialized stake account to be delegated */
        stake: TAccountMetas[0];
        /** Vote account to which this stake will be delegated */
        vote: TAccountMetas[1];
        /** Clock sysvar */
        clockSysvar: TAccountMetas[2];
        /** Stake history sysvar */
        stakeHistory: TAccountMetas[3];
        /** Unused account, formerly the stake config */
        unused: TAccountMetas[4];
        /** Stake authority */
        stakeAuthority: TAccountMetas[5];
    };
    data: DelegateStakeInstructionData;
};
export declare function parseDelegateStakeInstruction<TProgram extends string, TAccountMetas extends readonly IAccountMeta[]>(instruction: IInstruction<TProgram> & IInstructionWithAccounts<TAccountMetas> & IInstructionWithData<Uint8Array>): ParsedDelegateStakeInstruction<TProgram, TAccountMetas>;
//# sourceMappingURL=delegateStake.d.ts.map