/**
 * This code was AUTOGENERATED using the codama library.
 * Please DO NOT EDIT THIS FILE, instead use visitors
 * to add features, then rerun codama to update it.
 *
 * @see https://github.com/codama-idl/codama
 */
import { type Address, type Codec, type Decoder, type Encoder, type IAccountMeta, type IAccountSignerMeta, type IInstruction, type IInstructionWithAccounts, type IInstructionWithData, type ReadonlyAccount, type ReadonlySignerAccount, type TransactionSigner, type WritableAccount } from '@solana/kit';
import { STAKE_PROGRAM_ADDRESS } from '../programs';
import { type StakeAuthorize, type StakeAuthorizeArgs } from '../types';
export declare const AUTHORIZE_CHECKED_WITH_SEED_DISCRIMINATOR = 11;
export declare function getAuthorizeCheckedWithSeedDiscriminatorBytes(): import("@solana/kit").ReadonlyUint8Array;
export type AuthorizeCheckedWithSeedInstruction<TProgram extends string = typeof STAKE_PROGRAM_ADDRESS, TAccountStake extends string | IAccountMeta<string> = string, TAccountBase extends string | IAccountMeta<string> = string, TAccountClockSysvar extends string | IAccountMeta<string> = 'SysvarC1ock11111111111111111111111111111111', TAccountNewAuthority extends string | IAccountMeta<string> = string, TAccountLockupAuthority extends string | IAccountMeta<string> | undefined = undefined, TRemainingAccounts extends readonly IAccountMeta<string>[] = []> = IInstruction<TProgram> & IInstructionWithData<Uint8Array> & IInstructionWithAccounts<[
    TAccountStake extends string ? WritableAccount<TAccountStake> : TAccountStake,
    TAccountBase extends string ? ReadonlySignerAccount<TAccountBase> & IAccountSignerMeta<TAccountBase> : TAccountBase,
    TAccountClockSysvar extends string ? ReadonlyAccount<TAccountClockSysvar> : TAccountClockSysvar,
    TAccountNewAuthority extends string ? ReadonlySignerAccount<TAccountNewAuthority> & IAccountSignerMeta<TAccountNewAuthority> : TAccountNewAuthority,
    ...(TAccountLockupAuthority extends undefined ? [] : [
        TAccountLockupAuthority extends string ? ReadonlySignerAccount<TAccountLockupAuthority> & IAccountSignerMeta<TAccountLockupAuthority> : TAccountLockupAuthority
    ]),
    ...TRemainingAccounts
]>;
export type AuthorizeCheckedWithSeedInstructionData = {
    discriminator: number;
    stakeAuthorize: StakeAuthorize;
    authoritySeed: string;
    authorityOwner: Address;
};
export type AuthorizeCheckedWithSeedInstructionDataArgs = {
    stakeAuthorize: StakeAuthorizeArgs;
    authoritySeed: string;
    authorityOwner: Address;
};
export declare function getAuthorizeCheckedWithSeedInstructionDataEncoder(): Encoder<AuthorizeCheckedWithSeedInstructionDataArgs>;
export declare function getAuthorizeCheckedWithSeedInstructionDataDecoder(): Decoder<AuthorizeCheckedWithSeedInstructionData>;
export declare function getAuthorizeCheckedWithSeedInstructionDataCodec(): Codec<AuthorizeCheckedWithSeedInstructionDataArgs, AuthorizeCheckedWithSeedInstructionData>;
export type AuthorizeCheckedWithSeedInput<TAccountStake extends string = string, TAccountBase extends string = string, TAccountClockSysvar extends string = string, TAccountNewAuthority extends string = string, TAccountLockupAuthority extends string = string> = {
    /** Stake account to be updated */
    stake: Address<TAccountStake>;
    /** Base key of stake or withdraw authority */
    base: TransactionSigner<TAccountBase>;
    /** Clock sysvar */
    clockSysvar?: Address<TAccountClockSysvar>;
    /** The new stake or withdraw authority */
    newAuthority: TransactionSigner<TAccountNewAuthority>;
    /** Lockup authority */
    lockupAuthority?: TransactionSigner<TAccountLockupAuthority>;
    stakeAuthorize: AuthorizeCheckedWithSeedInstructionDataArgs['stakeAuthorize'];
    authoritySeed: AuthorizeCheckedWithSeedInstructionDataArgs['authoritySeed'];
    authorityOwner: AuthorizeCheckedWithSeedInstructionDataArgs['authorityOwner'];
};
export declare function getAuthorizeCheckedWithSeedInstruction<TAccountStake extends string, TAccountBase extends string, TAccountClockSysvar extends string, TAccountNewAuthority extends string, TAccountLockupAuthority extends string, TProgramAddress extends Address = typeof STAKE_PROGRAM_ADDRESS>(input: AuthorizeCheckedWithSeedInput<TAccountStake, TAccountBase, TAccountClockSysvar, TAccountNewAuthority, TAccountLockupAuthority>, config?: {
    programAddress?: TProgramAddress;
}): AuthorizeCheckedWithSeedInstruction<TProgramAddress, TAccountStake, TAccountBase, TAccountClockSysvar, TAccountNewAuthority, TAccountLockupAuthority>;
export type ParsedAuthorizeCheckedWithSeedInstruction<TProgram extends string = typeof STAKE_PROGRAM_ADDRESS, TAccountMetas extends readonly IAccountMeta[] = readonly IAccountMeta[]> = {
    programAddress: Address<TProgram>;
    accounts: {
        /** Stake account to be updated */
        stake: TAccountMetas[0];
        /** Base key of stake or withdraw authority */
        base: TAccountMetas[1];
        /** Clock sysvar */
        clockSysvar: TAccountMetas[2];
        /** The new stake or withdraw authority */
        newAuthority: TAccountMetas[3];
        /** Lockup authority */
        lockupAuthority?: TAccountMetas[4] | undefined;
    };
    data: AuthorizeCheckedWithSeedInstructionData;
};
export declare function parseAuthorizeCheckedWithSeedInstruction<TProgram extends string, TAccountMetas extends readonly IAccountMeta[]>(instruction: IInstruction<TProgram> & IInstructionWithAccounts<TAccountMetas> & IInstructionWithData<Uint8Array>): ParsedAuthorizeCheckedWithSeedInstruction<TProgram, TAccountMetas>;
//# sourceMappingURL=authorizeCheckedWithSeed.d.ts.map