/**
 * This code was AUTOGENERATED using the codama library.
 * Please DO NOT EDIT THIS FILE, instead use visitors
 * to add features, then rerun codama to update it.
 *
 * @see https://github.com/codama-idl/codama
 */
import { type Address, type Codec, type Decoder, type Encoder, type IAccountMeta, type IAccountSignerMeta, type IInstruction, type IInstructionWithAccounts, type IInstructionWithData, type ReadonlyAccount, type ReadonlySignerAccount, type TransactionSigner, type WritableAccount } from '@solana/kit';
import { STAKE_PROGRAM_ADDRESS } from '../programs';
import { type StakeAuthorize, type StakeAuthorizeArgs } from '../types';
export declare const AUTHORIZE_CHECKED_DISCRIMINATOR = 10;
export declare function getAuthorizeCheckedDiscriminatorBytes(): import("@solana/kit").ReadonlyUint8Array;
export type AuthorizeCheckedInstruction<TProgram extends string = typeof STAKE_PROGRAM_ADDRESS, TAccountStake extends string | IAccountMeta<string> = string, TAccountClockSysvar extends string | IAccountMeta<string> = 'SysvarC1ock11111111111111111111111111111111', TAccountAuthority extends string | IAccountMeta<string> = string, TAccountNewAuthority extends string | IAccountMeta<string> = string, TAccountLockupAuthority extends string | IAccountMeta<string> | undefined = undefined, TRemainingAccounts extends readonly IAccountMeta<string>[] = []> = IInstruction<TProgram> & IInstructionWithData<Uint8Array> & IInstructionWithAccounts<[
    TAccountStake extends string ? WritableAccount<TAccountStake> : TAccountStake,
    TAccountClockSysvar extends string ? ReadonlyAccount<TAccountClockSysvar> : TAccountClockSysvar,
    TAccountAuthority extends string ? ReadonlySignerAccount<TAccountAuthority> & IAccountSignerMeta<TAccountAuthority> : TAccountAuthority,
    TAccountNewAuthority extends string ? ReadonlySignerAccount<TAccountNewAuthority> & IAccountSignerMeta<TAccountNewAuthority> : TAccountNewAuthority,
    ...(TAccountLockupAuthority extends undefined ? [] : [
        TAccountLockupAuthority extends string ? ReadonlySignerAccount<TAccountLockupAuthority> & IAccountSignerMeta<TAccountLockupAuthority> : TAccountLockupAuthority
    ]),
    ...TRemainingAccounts
]>;
export type AuthorizeCheckedInstructionData = {
    discriminator: number;
    stakeAuthorize: StakeAuthorize;
};
export type AuthorizeCheckedInstructionDataArgs = {
    stakeAuthorize: StakeAuthorizeArgs;
};
export declare function getAuthorizeCheckedInstructionDataEncoder(): Encoder<AuthorizeCheckedInstructionDataArgs>;
export declare function getAuthorizeCheckedInstructionDataDecoder(): Decoder<AuthorizeCheckedInstructionData>;
export declare function getAuthorizeCheckedInstructionDataCodec(): Codec<AuthorizeCheckedInstructionDataArgs, AuthorizeCheckedInstructionData>;
export type AuthorizeCheckedInput<TAccountStake extends string = string, TAccountClockSysvar extends string = string, TAccountAuthority extends string = string, TAccountNewAuthority extends string = string, TAccountLockupAuthority extends string = string> = {
    /** Stake account to be updated */
    stake: Address<TAccountStake>;
    /** Clock sysvar */
    clockSysvar?: Address<TAccountClockSysvar>;
    /** The stake or withdraw authority */
    authority: TransactionSigner<TAccountAuthority>;
    /** The new stake or withdraw authority */
    newAuthority: TransactionSigner<TAccountNewAuthority>;
    /** Lockup authority */
    lockupAuthority?: TransactionSigner<TAccountLockupAuthority>;
    stakeAuthorize: AuthorizeCheckedInstructionDataArgs['stakeAuthorize'];
};
export declare function getAuthorizeCheckedInstruction<TAccountStake extends string, TAccountClockSysvar extends string, TAccountAuthority extends string, TAccountNewAuthority extends string, TAccountLockupAuthority extends string, TProgramAddress extends Address = typeof STAKE_PROGRAM_ADDRESS>(input: AuthorizeCheckedInput<TAccountStake, TAccountClockSysvar, TAccountAuthority, TAccountNewAuthority, TAccountLockupAuthority>, config?: {
    programAddress?: TProgramAddress;
}): AuthorizeCheckedInstruction<TProgramAddress, TAccountStake, TAccountClockSysvar, TAccountAuthority, TAccountNewAuthority, TAccountLockupAuthority>;
export type ParsedAuthorizeCheckedInstruction<TProgram extends string = typeof STAKE_PROGRAM_ADDRESS, TAccountMetas extends readonly IAccountMeta[] = readonly IAccountMeta[]> = {
    programAddress: Address<TProgram>;
    accounts: {
        /** Stake account to be updated */
        stake: TAccountMetas[0];
        /** Clock sysvar */
        clockSysvar: TAccountMetas[1];
        /** The stake or withdraw authority */
        authority: TAccountMetas[2];
        /** The new stake or withdraw authority */
        newAuthority: TAccountMetas[3];
        /** Lockup authority */
        lockupAuthority?: TAccountMetas[4] | undefined;
    };
    data: AuthorizeCheckedInstructionData;
};
export declare function parseAuthorizeCheckedInstruction<TProgram extends string, TAccountMetas extends readonly IAccountMeta[]>(instruction: IInstruction<TProgram> & IInstructionWithAccounts<TAccountMetas> & IInstructionWithData<Uint8Array>): ParsedAuthorizeCheckedInstruction<TProgram, TAccountMetas>;
//# sourceMappingURL=authorizeChecked.d.ts.map