"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.Ref = Ref;
const type_1 = require("../create/type");
const index_1 = require("../symbols/index");
// ------------------------------------------------------------------
// ValueGuard
// ------------------------------------------------------------------
const value_1 = require("../guard/value");
/** `[Json]` Creates a Ref type. */
function Ref(unresolved, options) {
    if ((0, value_1.IsString)(unresolved))
        return (0, type_1.CreateType)({ [index_1.Kind]: 'Ref', $ref: unresolved }, options);
    if ((0, value_1.IsUndefined)(unresolved.$id))
        throw new Error('Reference target type must specify an $id');
    return (0, type_1.CreateType)({ [index_1.Kind]: 'Ref', $ref: unresolved.$id }, options);
}
