import { Network } from 'bitcoinjs-lib';
import type { ECPairAPI } from 'ecpair';
import type { BIP32API, BIP32Interface } from 'bip32';
import type { KeyInfo } from './types';
import { LedgerState } from './ledger';
/**
 * Parses a key expression (xpub, xprv, pubkey or wif) into KeyInfo
 */
export declare function parseKeyExpression({ keyExpression, isSegwit, ECPair, BIP32, network }: {
    keyExpression: string;
    network?: Network;
    /**
     * Indicates if this is a SegWit key expression. When set, further checks
     * ensure the public key (if present in the expression) is compressed
     * (33 bytes).
     */
    isSegwit?: boolean;
    ECPair: ECPairAPI;
    BIP32: BIP32API;
}): KeyInfo;
export declare function keyExpressionLedger({ ledgerClient, ledgerState, originPath, keyPath, change, index }: {
    ledgerClient: unknown;
    ledgerState: LedgerState;
    originPath: string;
    change?: number | undefined;
    index?: number | undefined | '*';
    keyPath?: string | undefined;
}): Promise<string>;
export declare function keyExpressionBIP32({ masterNode, originPath, keyPath, change, index, isPublic }: {
    masterNode: BIP32Interface;
    originPath: string;
    change?: number | undefined;
    index?: number | undefined | '*';
    keyPath?: string | undefined;
    isPublic?: boolean;
}): string;
