"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.awaitsBleOn = void 0;
const errors_1 = require("@ledgerhq/errors");
const logs_1 = require("@ledgerhq/logs");
const timer_1 = __importDefault(require("./timer"));
const awaitsBleOn = (bleManager, ms = 3000) => new Promise((resolve, reject) => {
    let done = false;
    let lastState = "Unknown";
    const stateSub = bleManager.onStateChange(state => {
        lastState = state;
        (0, logs_1.log)("ble-verbose", `ble state -> ${state}`);
        if (state === "PoweredOn") {
            if (done)
                return;
            removeTimeout();
            done = true;
            stateSub.remove();
            resolve();
        }
    }, true);
    const removeTimeout = timer_1.default.timeout(() => {
        if (done)
            return;
        stateSub.remove();
        reject(new errors_1.BluetoothRequired("", {
            state: lastState,
        }));
    }, ms);
});
exports.awaitsBleOn = awaitsBleOn;
//# sourceMappingURL=awaitsBleOn.js.map