"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.zCashProofsSaplingSize = exports.zCashOutCiphertextSize = exports.zCashEncCiphertextSize = exports.ZCASH_ACTIVATION_HEIGHTS = exports.OP_RETURN = exports.OP_CHECKSIG = exports.OP_EQUALVERIFY = exports.OP_EQUAL = exports.HASH_SIZE = exports.OP_HASH160 = exports.OP_DUP = exports.SIGHASH_ALL = exports.DEFAULT_SEQUENCE = exports.DEFAULT_LOCKTIME = exports.DEFAULT_VERSION = exports.MAX_SCRIPT_BLOCK = void 0;
// the maximum number of bytes allowed in a single chunk when processing bitcoin script data.
// if the Bitcoin script is too large, we will process it in several chunks.
exports.MAX_SCRIPT_BLOCK = 50;
exports.DEFAULT_VERSION = 1;
exports.DEFAULT_LOCKTIME = 0;
// input sequence for non-rbf transactions
exports.DEFAULT_SEQUENCE = 0xffffffff;
// SIGHASH flags(Sign all inputs and outputs)
// refer to https://wiki.bitcoinsv.io/index.php/SIGHASH_flags for more details
exports.SIGHASH_ALL = 1;
// refer to https://en.bitcoin.it/wiki/Script for Opcodes(OP_DUP, OP_HASH160...) that are used in bitcoin script
exports.OP_DUP = 0x76;
exports.OP_HASH160 = 0xa9;
exports.HASH_SIZE = 0x14;
exports.OP_EQUAL = 0x87;
exports.OP_EQUALVERIFY = 0x88;
exports.OP_CHECKSIG = 0xac;
exports.OP_RETURN = 0x6a;
exports.ZCASH_ACTIVATION_HEIGHTS = {
    // https://zcash.readthedocs.io/en/latest/rtd_pages/nu_dev_guide.html
    // https://zips.z.cash/zip-0253
    NU6: 2726400,
    // https://zips.z.cash/zip-0252
    NU5: 1687104,
    // https://zips.z.cash/zip-0251
    CANOPY: 1046400,
    // https://zips.z.cash/zip-0250
    HEARTWOOD: 903000,
    // https://z.cash/upgrade/blossom/
    // https://zips.z.cash/zip-0206
    BLOSSOM: 653600,
    // https://zips.z.cash/zip-0205
    SAPLING: 419200,
};
exports.zCashEncCiphertextSize = 580; //https://zips.z.cash/zip-0225
exports.zCashOutCiphertextSize = 80; //https://zips.z.cash/zip-0225
exports.zCashProofsSaplingSize = 192; //https://zips.z.cash/zip-0225
//# sourceMappingURL=constants.js.map