# Documentation

- [Introduction](introduction.md)
- [FAQ](faq.md)
- [Shortcuts](shortcuts.md)
    - [Regular Shortcuts](shortcuts.md#regular)
    - [Import from cURL](shortcuts.md#curl-import)
    - [Multi-Shortcut](shortcuts.md#multi-shortcut)
    - [Browser Shortcut](shortcuts.md#browser-shortcut)
    - [Scripting Shortcut](shortcuts.md#scripting-shortcut)
- [Categories](categories.md)
- [Directories](directories.md)
- [Execution Flow](execution-flow.md)
- [Variables](variables.md)
    - [Local Variables](variables.md#local-variables)
    - [Static Variable (Constant)](variables.md#constant)
    - [Multiple Choice Selection](variables.md#multiple-choice)
    - [Text, Number, Password Input](variables.md#text-number-password)
    - [Date, Time Input](variables.md#date-time)
    - [Number Slider](variables.md#number-slider)
    - [Color Input](variables.md#color)
    - [Toggle](variables.md#toggle)
    - [Incrementing Counter](variables.md#increment)
    - [UUID](variables.md#uuid)
    - [Timestamp](variables.md#timestamp)
    - [Clipboard Content](variables.md#clipboard-content)
    - [Sharing into Variables](variables.md#sharing)
- [Scripting](scripting.md)
    - [Handle Response](scripting.md#handle-response)
    - [Variables](scripting.md#variables)
    - [Shortcut Info](scripting.md#shortcut-info)
    - [Files](scripting.md#files)
    - [User Interaction](scripting.md#user-interaction)
    - [Modify Shortcuts](scripting.md#modify-shortcuts)
    - [Control Flow](scripting.md#control-flow)
    - [Text Processing](scripting.md#text-processing)
    - [Miscellaneous](scripting.md#misc)
    - [Examples](scripting-examples.md)
- [Import / Export](import-export.md)
    - [Remote Editing](import-export.md#remote-edit)
    - [Hosting Templates for Easy Importing](import-export.md#import-deep-linking)
- [Advanced Features](advanced.md)
    - [Share text into a shortcut](advanced.md#share-text)
    - [Share files into a shortcut](advanced.md#share-files)
    - [Trigger shortcut via deep-link](advanced.md#deep-link)
    - [Trigger shortcut via secondary launcher app](advanced.md#secondary-launcher)
    - [Trigger shortcut via Quick Settings Tile](advanced.md#quick-settings-tile)
    - [Trigger shortcut via app launcher](advanced.md#app-launcher)
    - [Integrating with Tasker](advanced.md#integrate-with-tasker)
    - [Integrating with MacroDroid](advanced.md#integrate-with-macrodroid)
    - [Certificate Pinning](advanced.md#certificate-pinning)
    - [Using Self-Signed Certificates](advanced.md#self-signed-certificates)
    - [Displaying responses as a table](advanced.md#tables)
- [Permissions](permissions.md)
- [Privacy Policy](privacy-policy.md)

