package ch.rmy.android.http_shortcuts.utils

import android.net.Uri
import ch.rmy.android.http_shortcuts.variables.Variables.RAW_PLACEHOLDER_REGEX
import okhttp3.HttpUrl.Companion.toHttpUrlOrNull

object Validation {

    fun isAcceptableHttpUrl(url: String) =
        url.matches("^(http(s?)://.+)|((h(t(t(p(s)?)?)?)?)?$RAW_PLACEHOLDER_REGEX.*)".toRegex(RegexOption.IGNORE_CASE))

    fun isAcceptableUrl(url: String) =
        url.isNotEmpty() && url != "http://" && url != "https://"

    fun isValidUrl(uri: Uri) =
        uri.scheme?.isNotEmpty() == true &&
            uri.host?.contains("[{}<>\"']".toRegex()) != true

    fun isValidHttpUrl(uri: Uri) =
        isValidUrl(uri) &&
            !uri.host.isNullOrEmpty() &&
            (
                uri.scheme?.let { scheme ->
                    scheme.equals("http", ignoreCase = true) ||
                        scheme.equals("https", ignoreCase = true)
                } == true
                ) &&
            uri.toString().toHttpUrlOrNull() != null

    fun isValidInHeaderName(c: Char): Boolean =
        c in '!'..'~'

    fun isValidInHeaderValue(c: Char): Boolean =
        (c > '\u001f' || c == '\t') && c < '\u007f'
}
