package ch.rmy.android.http_shortcuts.scripting.actions.types

import ch.rmy.android.http_shortcuts.scripting.ActionAlias
import ch.rmy.android.http_shortcuts.scripting.actions.ActionRunnable
import ch.rmy.android.scripting.JsFunctionArgs
import javax.inject.Inject

class PromptActionType
@Inject
constructor(
    private val promptAction: PromptAction,
) : ActionType {
    override val type = TYPE

    override fun getActionRunnable(args: JsFunctionArgs) =
        ActionRunnable(
            action = promptAction,
            params = PromptAction.Params(
                message = args.getString(0) ?: "",
                prefill = args.getString(1) ?: "",
                multiline = args.getObject(2)?.get("multiline") as? Boolean ?: false,
            ),
        )

    override fun getAlias() = ActionAlias(
        functionName = FUNCTION_NAME,
        parameters = 3,
    )

    companion object {
        private const val TYPE = "prompt"
        private const val FUNCTION_NAME = "prompt"
    }
}
