package ch.rmy.android.http_shortcuts.activities.variables.editor.types

import ch.rmy.android.http_shortcuts.data.domains.variables.TemporaryGlobalVariableRepository
import ch.rmy.android.http_shortcuts.data.models.GlobalVariable
import ch.rmy.android.http_shortcuts.variables.types.TimeType
import java.text.SimpleDateFormat
import java.util.Locale

class TimeTypeViewModel : BaseTypeViewModel() {

    override fun createViewState(variable: GlobalVariable) = TimeTypeViewState(
        timeFormat = TimeType.getTimeFormat(variable),
        rememberValue = variable.rememberValue,
    )

    override suspend fun save(temporaryGlobalVariableRepository: TemporaryGlobalVariableRepository, viewState: VariableTypeViewState) {
        viewState as TimeTypeViewState
        temporaryGlobalVariableRepository.setData(
            mapOf(TimeType.KEY_FORMAT to viewState.timeFormat),
        )
        temporaryGlobalVariableRepository.setRememberValue(viewState.rememberValue)
    }

    override fun validate(viewState: VariableTypeViewState): VariableTypeViewState? {
        viewState as TimeTypeViewState
        if (viewState.timeFormat.isEmpty()) {
            return viewState.copy(
                invalidFormat = true,
            )
        }
        try {
            SimpleDateFormat(viewState.timeFormat, Locale.US)
        } catch (e: IllegalArgumentException) {
            return viewState.copy(
                invalidFormat = true,
            )
        }
        return null
    }
}
