# Categories

Categories can be used to group different shortcuts together into separate tabs inside the app. Each category has a name and can contain zero or more shortcuts. You can switch between categories while on the app's main screen by swiping horizontally or by selecting the tab at the top of the screen below the title bar.

### Managing Categories

You can access the categories editor via the "Categories" option in the dropdown menu in the app's main screen. You can also long-press on the background of a category to open a context menu, from which you can directly jump to the editor by clicking the "Edit" option.

### Layout Types

A category's layout type defines how shortcuts within it are displayed. There are 4 options: list, which will display the shortcuts vertically below each other in a list, and 3 different types of grid, where shortcuts are displayed in a grid, similar to Android's home screen.

You can change a category's background to either use the default color (i.e., white or black, depending on whether dark mode is enabled) or set it to a specific color.

You also have the option to apply a scaling factor, to increase or decrease the display size of shortcuts within the category.

### Category Sections

The shortcuts within a category can be grouped into sections. You can configure sections by going to the "Categories" screen, long-pressing on a category and selecting "Manage Sections", or by long-pressing on a category's background on the main screen and selecting "Manage Sections" there. To move a shortcut into a section, long-press it on the main screen and select "Move" in the menu that pops up. This will take you to the "Move Shortcuts" screen, where you can freely rearrange all shortcuts and move them between categories and sections.

### Hidden Categories

A category can be set to be hidden. A hidden category will not show up as a tab in the app. This can be useful if you have shortcuts that you only want to access directly from the home screen (make sure to place them first before hiding the category) or that you only want to trigger from other shortcuts, using [Scripting](scripting.md#trigger-shortcut)
 or via a [Multi-Shortcut](shortcuts.md#multi-shortcut).
 
 > Is is also possible to hide individual shortcuts. This can be achieved by long-pressing on the shortcut on the main screen and selecting "Hide".
 
