package ch.rmy.android.http_shortcuts.icons

import android.content.Context
import android.graphics.Color
import ch.rmy.android.http_shortcuts.R

object Icons {

    fun getRandomInitialIcon(context: Context) =
        ShortcutIcon.BuiltInIcon.fromDrawableResource(context, INITIAL_ICONS.random())

    fun getColoredIcons(): List<Int> =
        (COLORED_ICONS + COLORED_TINTABLE_ICONS).toList()

    fun getTintableIcons(): List<Int> =
        TINTABLE_ICONS.toList()
            .plus(
                COLORED_TINTABLE_ICONS.toList()
                    .minus(UNWANTED_COLORED_TINTABLE_ICONS.toSet()),
            )

    private val INITIAL_ICONS = intArrayOf(
        R.drawable.flat_color_play,
        R.drawable.flat_color_star,
        R.drawable.flat_color_computer,
        R.drawable.flat_color_bolt,
        R.drawable.flat_color_plugin,
        R.drawable.flat_color_cursor,
        R.drawable.flat_color_brightness,
        R.drawable.flat_color_lightbulb,
        R.drawable.flat_color_brightness_2,
        R.drawable.flat_color_lightbulb_2,
        R.drawable.flat_color_brightness_3,
        R.drawable.flat_color_lightbulb_3,
        R.drawable.flat_color_brightness_4,
        R.drawable.flat_color_lightbulb_4,
        R.drawable.flat_color_brightness_5,
        R.drawable.flat_color_lightbulb_5,
        R.drawable.flat_color_brightness_6,
        R.drawable.flat_color_lightbulb_6,
        R.drawable.flat_color_brightness_7,
        R.drawable.flat_color_lightbulb_7,
    )

    private val COLORED_ICONS = intArrayOf(
        R.drawable.flat_color_brightness,
        R.drawable.flat_color_lightbulb,
        R.drawable.flat_color_brightness_2,
        R.drawable.flat_color_lightbulb_2,
        R.drawable.flat_color_brightness_3,
        R.drawable.flat_color_lightbulb_3,
        R.drawable.flat_color_brightness_4,
        R.drawable.flat_color_lightbulb_4,
        R.drawable.flat_color_brightness_5,
        R.drawable.flat_color_lightbulb_5,
        R.drawable.flat_color_brightness_6,
        R.drawable.flat_color_lightbulb_6,
        R.drawable.flat_color_brightness_7,
        R.drawable.flat_color_lightbulb_7,
        R.drawable.flat_color_arrow_down,
        R.drawable.flat_color_arrow_up,
        R.drawable.flat_color_pie_chart,
        R.drawable.flat_color_barchart,
        R.drawable.flat_color_trends,
        R.drawable.flat_color_batteryfull,
        R.drawable.flat_color_batterylow,
        R.drawable.flat_color_bomb,
        R.drawable.flat_color_booklet,
        R.drawable.flat_color_bookshelf,
        R.drawable.flat_color_briefcase,
        R.drawable.flat_color_browser,
        R.drawable.flat_color_calculator,
        R.drawable.flat_color_calendar,
        R.drawable.flat_color_cart,
        R.drawable.flat_color_caution,
        R.drawable.flat_color_chat,
        R.drawable.flat_color_check,
        R.drawable.flat_color_x,
        R.drawable.flat_color_clipboard,
        R.drawable.flat_color_clock,
        R.drawable.flat_color_compose,
        R.drawable.flat_color_contacts,
        R.drawable.flat_color_contrast,
        R.drawable.flat_color_countdown,
        R.drawable.flat_color_creditcard,
        R.drawable.flat_color_crop,
        R.drawable.flat_color_crossroads,
        R.drawable.flat_color_cursor,
        R.drawable.flat_color_denied,
        R.drawable.flat_color_dev,
        R.drawable.flat_color_die,
        R.drawable.flat_color_document,
        R.drawable.flat_color_dolly,
        R.drawable.flat_color_door,
        R.drawable.flat_color_download,
        R.drawable.flat_color_upload,
        R.drawable.flat_color_easel,
        R.drawable.flat_color_email,
        R.drawable.flat_color_eye,
        R.drawable.flat_color_fashion,
        R.drawable.flat_color_flag,
        R.drawable.flat_color_focus,
        R.drawable.flat_color_folder,
        R.drawable.flat_color_gear,
        R.drawable.flat_color_genius,
        R.drawable.flat_color_global,
        R.drawable.flat_color_globe,
        R.drawable.flat_color_hazard,
        R.drawable.flat_color_heart,
        R.drawable.flat_color_hourglass,
        R.drawable.flat_color_loading,
        R.drawable.flat_color_compass,
        R.drawable.flat_color_circlecompass,
        R.drawable.flat_color_location,
        R.drawable.flat_color_gps,
        R.drawable.flat_color_pin,
        R.drawable.flat_color_pin2,
        R.drawable.flat_color_magicwand,
        R.drawable.flat_color_mail,
        R.drawable.flat_color_map,
        R.drawable.flat_color_megaphone,
        R.drawable.flat_color_megaphone2,
        R.drawable.flat_color_memorycard,
        R.drawable.flat_color_mic,
        R.drawable.flat_color_microphone,
        R.drawable.flat_color_play,
        R.drawable.flat_color_music,
        R.drawable.flat_color_news,
        R.drawable.flat_color_money,
        R.drawable.flat_color_phone,
        R.drawable.flat_color_present,
        R.drawable.flat_color_profle,
        R.drawable.flat_color_quote,
        R.drawable.flat_color_racingflags,
        R.drawable.flat_color_radiotower,
        R.drawable.flat_color_rgb,
        R.drawable.flat_color_ribbon,
        R.drawable.flat_color_volume,
        R.drawable.flat_color_art,
        R.drawable.flat_color_brush_pencil,
        R.drawable.flat_color_cmyk,
        R.drawable.flat_color_colorwheel,
        R.drawable.flat_color_eyedropper,
        R.drawable.flat_color_paintbrush,
        R.drawable.flat_color_paintbrush2,
        R.drawable.flat_color_paintcan,
        R.drawable.flat_color_pencil,
        R.drawable.flat_color_paintroller,
        R.drawable.flat_color_scissors,
        R.drawable.flat_color_rulertriangle,
        R.drawable.flat_color_settings,
        R.drawable.flat_color_toolbox,
        R.drawable.flat_color_tools,
        R.drawable.flat_color_swatches,
        R.drawable.flat_color_magnifyingglass,
        R.drawable.flat_color_zoomin,
        R.drawable.flat_color_zoomout,
        R.drawable.flat_color_key,
        R.drawable.flat_color_unlocked,
        R.drawable.flat_color_locked,
        R.drawable.flat_color_security,
        R.drawable.flat_color_selftimer,
        R.drawable.flat_color_shoeprints,
        R.drawable.flat_color_shop,
        R.drawable.flat_color_speaker,
        R.drawable.flat_color_sub,
        R.drawable.flat_color_speedometer,
        R.drawable.flat_color_spraypaint,
        R.drawable.flat_color_stack,
        R.drawable.flat_color_star,
        R.drawable.flat_color_gas,
        R.drawable.flat_color_spaceshuttle,
        R.drawable.flat_color_sailboat,
        R.drawable.flat_color_running,
        R.drawable.flat_color_schooolbus,
        R.drawable.flat_color_rocket,
        R.drawable.flat_color_skateboard,
        R.drawable.flat_color_unicycle,
        R.drawable.flat_color_scooter,
        R.drawable.flat_color_submarine,
        R.drawable.flat_color_cruise,
        R.drawable.flat_color_takeoff,
        R.drawable.flat_color_plane,
        R.drawable.flat_color_truck,
        R.drawable.flat_color_taxi,
        R.drawable.flat_color_tractor,
        R.drawable.flat_color_train,
        R.drawable.flat_color_parachute,
        R.drawable.flat_color_ufo,
        R.drawable.flat_color_bike,
        R.drawable.flat_color_biker,
        R.drawable.flat_color_car,
        R.drawable.flat_color_helicopter,
        R.drawable.flat_color_hotair,
        R.drawable.flat_color_motorcycle,
        R.drawable.flat_color_bikewheel,
        R.drawable.flat_color_blimp,
        R.drawable.flat_color_anchor,
        R.drawable.flat_color_carwheel,
        R.drawable.flat_color_steeringwheel,
        R.drawable.flat_color_shipwheel,
        R.drawable.flat_color_support,
        R.drawable.flat_color_traffic,
        R.drawable.flat_color_roadblock,
        R.drawable.flat_color_cone,
        R.drawable.flat_color_travelerbag,
        R.drawable.flat_color_windy,
        R.drawable.flat_color_merge,
        R.drawable.flat_color_stop,
        R.drawable.flat_color_interstate,
        R.drawable.flat_color_power,
        R.drawable.flat_color_plugin,
        R.drawable.flat_color_radio,
        R.drawable.flat_color_tv,
        R.drawable.flat_color_gamecontroller,
        R.drawable.flat_color_keyboard,
        R.drawable.flat_color_smartphone,
        R.drawable.flat_color_tablet,
        R.drawable.flat_color_computer,
        R.drawable.flat_color_aperture,
        R.drawable.flat_color_flash,
        R.drawable.flat_color_filmroll,
        R.drawable.flat_color_lens,
        R.drawable.flat_color_frames,
        R.drawable.flat_color_polaroid,
        R.drawable.flat_color_polaroidcamera,
        R.drawable.flat_color_polaroids,
        R.drawable.flat_color_image,
        R.drawable.flat_color_slr,
        R.drawable.flat_color_video,
        R.drawable.flat_color_videocameraclassic,
        R.drawable.flat_color_videocameracompact,
        R.drawable.flat_color_camera,
        R.drawable.flat_color_clapboard,
        R.drawable.flat_color_filmreel,
        R.drawable.flat_color_tripod,
        R.drawable.flat_color_trophy,
        R.drawable.flat_color_target,
        R.drawable.flat_color_typography,
        R.drawable.flat_color_water,
        R.drawable.flat_color_cloud,
        R.drawable.flat_color_weather,
        R.drawable.flat_color_bolt,
        R.drawable.flat_color_umbrella,
        R.drawable.flat_color_windsock,
        R.drawable.flat_color_rainbow,
        R.drawable.flat_color_flower,
        R.drawable.flat_color_flame,
        R.drawable.flat_grey_brightness,
        R.drawable.flat_grey_lightbulb,
        R.drawable.flat_grey_arrow_down,
        R.drawable.flat_grey_arrow_up,
        R.drawable.flat_grey_piechart,
        R.drawable.flat_grey_barchart,
        R.drawable.flat_grey_trends,
        R.drawable.flat_grey_batteryfull,
        R.drawable.flat_grey_batterylow,
        R.drawable.flat_grey_bomb,
        R.drawable.flat_grey_booklet,
        R.drawable.flat_grey_bookshelf,
        R.drawable.flat_grey_briefcase,
        R.drawable.flat_grey_browser,
        R.drawable.flat_grey_calculator,
        R.drawable.flat_grey_calendar,
        R.drawable.flat_grey_cart,
        R.drawable.flat_grey_caution,
        R.drawable.flat_grey_chat,
        R.drawable.flat_grey_check,
        R.drawable.flat_grey_x,
        R.drawable.flat_grey_clipboard,
        R.drawable.flat_grey_clock,
        R.drawable.flat_grey_compose,
        R.drawable.flat_grey_contacts,
        R.drawable.flat_grey_contrast,
        R.drawable.flat_grey_countdown,
        R.drawable.flat_grey_creditcard,
        R.drawable.flat_grey_crop,
        R.drawable.flat_grey_crossroads,
        R.drawable.flat_grey_cursor,
        R.drawable.flat_grey_denied,
        R.drawable.flat_grey_dev,
        R.drawable.flat_grey_document,
        R.drawable.flat_grey_dolly,
        R.drawable.flat_grey_door,
        R.drawable.flat_grey_download,
        R.drawable.flat_grey_upload,
        R.drawable.flat_grey_easel,
        R.drawable.flat_grey_email,
        R.drawable.flat_grey_eye,
        R.drawable.flat_grey_fashion,
        R.drawable.flat_grey_flag,
        R.drawable.flat_grey_focus,
        R.drawable.flat_grey_folder,
        R.drawable.flat_grey_gear,
        R.drawable.flat_grey_genius,
        R.drawable.flat_grey_global,
        R.drawable.flat_grey_globe,
        R.drawable.flat_grey_hazard,
        R.drawable.flat_grey_heart,
        R.drawable.flat_grey_hourglass,
        R.drawable.flat_grey_loading,
        R.drawable.flat_grey_compass,
        R.drawable.flat_grey_circlecompass,
        R.drawable.flat_grey_location,
        R.drawable.flat_grey_gps,
        R.drawable.flat_grey_pin,
        R.drawable.flat_grey_pin2,
        R.drawable.flat_grey_magicwand,
        R.drawable.flat_grey_mail,
        R.drawable.flat_grey_map,
        R.drawable.flat_grey_megaphone,
        R.drawable.flat_grey_megaphone2,
        R.drawable.flat_grey_memorycard,
        R.drawable.flat_grey_mic,
        R.drawable.flat_grey_microphone,
        R.drawable.flat_grey_play,
        R.drawable.flat_grey_music,
        R.drawable.flat_grey_news,
        R.drawable.flat_grey_money,
        R.drawable.flat_grey_phone,
        R.drawable.flat_grey_present,
        R.drawable.flat_grey_profle,
        R.drawable.flat_grey_quote,
        R.drawable.flat_grey_racingflags,
        R.drawable.flat_grey_radiotower,
        R.drawable.flat_grey_rgb,
        R.drawable.flat_grey_ribbon,
        R.drawable.flat_grey_volume,
        R.drawable.flat_grey_art,
        R.drawable.flat_grey_brush_pencil,
        R.drawable.flat_grey_cmyk,
        R.drawable.flat_grey_colorwheel,
        R.drawable.flat_grey_eyedropper,
        R.drawable.flat_grey_paintbrush,
        R.drawable.flat_grey_paintbrush2,
        R.drawable.flat_grey_paintcan,
        R.drawable.flat_grey_pencil,
        R.drawable.flat_grey_paintroller,
        R.drawable.flat_grey_scissors,
        R.drawable.flat_grey_rulertriangle,
        R.drawable.flat_grey_settings,
        R.drawable.flat_grey_toolbox,
        R.drawable.flat_grey_tools,
        R.drawable.flat_grey_swatches,
        R.drawable.flat_grey_magnifyingglass,
        R.drawable.flat_grey_zoomin,
        R.drawable.flat_grey_zoomout,
        R.drawable.flat_grey_key,
        R.drawable.flat_grey_unlocked,
        R.drawable.flat_grey_locked,
        R.drawable.flat_grey_security,
        R.drawable.flat_grey_selftimer,
        R.drawable.flat_grey_shoeprints,
        R.drawable.flat_grey_shop,
        R.drawable.flat_grey_speaker,
        R.drawable.flat_grey_sub,
        R.drawable.flat_grey_speedometer,
        R.drawable.flat_grey_spraypaint,
        R.drawable.flat_grey_stack,
        R.drawable.flat_grey_star,
        R.drawable.flat_grey_gas,
        R.drawable.flat_grey_spaceshuttle,
        R.drawable.flat_grey_sailboat,
        R.drawable.flat_grey_running,
        R.drawable.flat_grey_schooolbus,
        R.drawable.flat_grey_rocket,
        R.drawable.flat_grey_skateboard,
        R.drawable.flat_grey_unicycle,
        R.drawable.flat_grey_scooter,
        R.drawable.flat_grey_submarine,
        R.drawable.flat_grey_cruise,
        R.drawable.flat_grey_takeoff,
        R.drawable.flat_grey_plane,
        R.drawable.flat_grey_truck,
        R.drawable.flat_grey_taxi,
        R.drawable.flat_grey_tractor,
        R.drawable.flat_grey_train,
        R.drawable.flat_grey_parachute,
        R.drawable.flat_grey_ufo,
        R.drawable.flat_grey_bike,
        R.drawable.flat_grey_biker,
        R.drawable.flat_grey_car,
        R.drawable.flat_grey_helicopter,
        R.drawable.flat_grey_hotair,
        R.drawable.flat_grey_motorcycle,
        R.drawable.flat_grey_bikewheel,
        R.drawable.flat_grey_blimp,
        R.drawable.flat_grey_anchor,
        R.drawable.flat_grey_carwheel,
        R.drawable.flat_grey_steeringwheel,
        R.drawable.flat_grey_shipwheel,
        R.drawable.flat_grey_support,
        R.drawable.flat_grey_traffic,
        R.drawable.flat_grey_roadblock,
        R.drawable.flat_grey_cone,
        R.drawable.flat_grey_travelerbag,
        R.drawable.flat_grey_windy,
        R.drawable.flat_grey_merge,
        R.drawable.flat_grey_stop,
        R.drawable.flat_grey_interstate,
        R.drawable.flat_grey_power,
        R.drawable.flat_grey_plugin,
        R.drawable.flat_grey_radio,
        R.drawable.flat_grey_tv,
        R.drawable.flat_grey_gamecontroller,
        R.drawable.flat_grey_keyboard,
        R.drawable.flat_grey_smartphone,
        R.drawable.flat_grey_tablet,
        R.drawable.flat_grey_computer,
        R.drawable.flat_grey_aperture,
        R.drawable.flat_grey_flash,
        R.drawable.flat_grey_filmroll,
        R.drawable.flat_grey_lens,
        R.drawable.flat_grey_frames,
        R.drawable.flat_grey_polaroid,
        R.drawable.flat_grey_polaroidcamera,
        R.drawable.flat_grey_image,
        R.drawable.flat_grey_video,
        R.drawable.flat_grey_videocameraclassic,
        R.drawable.flat_grey_videocameracompact,
        R.drawable.flat_grey_camera,
        R.drawable.flat_grey_clapboard,
        R.drawable.flat_grey_filmreel,
        R.drawable.flat_grey_tripod,
        R.drawable.flat_grey_trophy,
        R.drawable.flat_grey_target,
        R.drawable.flat_grey_typography,
        R.drawable.flat_grey_water,
        R.drawable.flat_grey_cloud,
        R.drawable.flat_grey_weather,
        R.drawable.flat_grey_bolt,
        R.drawable.flat_grey_umbrella,
        R.drawable.flat_grey_windsock,
        R.drawable.flat_grey_rainbow,
        R.drawable.flat_grey_flower,
        R.drawable.flat_grey_flame,
        R.drawable.freepik_check,
        R.drawable.freepik_close,
        R.drawable.freepik_accept,
        R.drawable.freepik_add,
        R.drawable.freepik_minus,
        R.drawable.freepik_cancel,
        R.drawable.freepik_heart,
        R.drawable.freepik_rate,
        R.drawable.freepik_cube,
        R.drawable.freepik_electronics,
        R.drawable.freepik_fan,
        R.drawable.freepik_home_security,
        R.drawable.freepik_plug,
        R.drawable.freepik_lamp,
        R.drawable.freepik_lamp2,
        R.drawable.freepik_lamp3,
        R.drawable.freepik_lamp4,
        R.drawable.freepik_modem,
        R.drawable.freepik_music,
        R.drawable.freepik_star,
        R.drawable.freepik_rain,
        R.drawable.freepik_power,
        R.drawable.freepik_leaf,
        R.drawable.freepik_print,
        R.drawable.freepik_toaster,
        R.drawable.freepik_projector,
        R.drawable.freepik_blender,
        R.drawable.freepik_rocket,
        R.drawable.freepik_battery,
        R.drawable.freepik_battery2,
        R.drawable.freepik_battery3,
        R.drawable.freepik_upload,
        R.drawable.freepik_download,
        R.drawable.freepik_electric_car,
        R.drawable.freepik_shout,
        R.drawable.freepik_photo,
        R.drawable.freepik_origami,
        R.drawable.freepik_indicator,
        R.drawable.freepik_gear,
        R.drawable.freepik_cpu,
        R.drawable.freepik_coffee_machine,
        R.drawable.freepik_wizard,
        R.drawable.freepik_tv,
        R.drawable.freepik_tv2,
        R.drawable.freepik_user,
        R.drawable.freepik_cursor,
        R.drawable.freepik_hourglass,
        R.drawable.freepik_play_button,
        R.drawable.freepik_target,
    )

    private val COLORED_TINTABLE_ICONS = intArrayOf(
        R.drawable.bitsies_success,
        R.drawable.bitsies_cancel,
        R.drawable.bitsies_add,
        R.drawable.bitsies_remove,
        R.drawable.bitsies_info,
        R.drawable.bitsies_warning,
        R.drawable.bitsies_batterydead,
        R.drawable.bitsies_batteryfull,
        R.drawable.bitsies_batteryhalf,
        R.drawable.bitsies_batterylow,
        R.drawable.bitsies_couch,
        R.drawable.bitsies_home,
        R.drawable.bitsies_city,
        R.drawable.bitsies_car,
        R.drawable.bitsies_cargo,
        R.drawable.bitsies_bus,
        R.drawable.bitsies_boat,
        R.drawable.bitsies_plane,
        R.drawable.bitsies_auction,
        R.drawable.bitsies_bank,
        R.drawable.bitsies_money,
        R.drawable.bitsies_wallet,
        R.drawable.bitsies_trafficcone,
        R.drawable.bitsies_basketball,
        R.drawable.bitsies_football,
        R.drawable.bitsies_earth,
        R.drawable.bitsies_book,
        R.drawable.bitsies_calendar,
        R.drawable.bitsies_clock,
        R.drawable.bitsies_diskette,
        R.drawable.bitsies_bookmark,
        R.drawable.bitsies_brush,
        R.drawable.bitsies_pen,
        R.drawable.bitsies_bin,
        R.drawable.bitsies_copy,
        R.drawable.bitsies_cut,
        R.drawable.bitsies_clipboard,
        R.drawable.bitsies_document,
        R.drawable.bitsies_documentedit,
        R.drawable.bitsies_application,
        R.drawable.bitsies_archive,
        R.drawable.bitsies_folder,
        R.drawable.bitsies_attach,
        R.drawable.bitsies_crown,
        R.drawable.bitsies_star,
        R.drawable.bitsies_dollar,
        R.drawable.bitsies_mastercard,
        R.drawable.bitsies_visa,
        R.drawable.bitsies_download,
        R.drawable.bitsies_upload,
        R.drawable.bitsies_enter,
        R.drawable.bitsies_exit,
        R.drawable.bitsies_experiment,
        R.drawable.bitsies_flagblue,
        R.drawable.bitsies_flaggreen,
        R.drawable.bitsies_flagred,
        R.drawable.bitsies_flagyellow,
        R.drawable.bitsies_gun,
        R.drawable.bitsies_sword,
        R.drawable.bitsies_cup,
        R.drawable.bitsies_food,
        R.drawable.bitsies_fish,
        R.drawable.bitsies_hamburger,
        R.drawable.bitsies_pizza,
        R.drawable.bitsies_drink,
        R.drawable.bitsies_headphones,
        R.drawable.bitsies_heart,
        R.drawable.bitsies_image,
        R.drawable.bitsies_glasses,
        R.drawable.bitsies_visible,
        R.drawable.bitsies_invisible,
        R.drawable.bitsies_jewel,
        R.drawable.bitsies_computer,
        R.drawable.bitsies_mobile,
        R.drawable.bitsies_print,
        R.drawable.bitsies_mouse,
        R.drawable.bitsies_joypad,
        R.drawable.bitsies_joystick,
        R.drawable.bitsies_keyboard,
        R.drawable.bitsies_lightbulb,
        R.drawable.bitsies_video,
        R.drawable.bitsies_camera,
        R.drawable.bitsies_cassette,
        R.drawable.bitsies_location,
        R.drawable.bitsies_key,
        R.drawable.bitsies_locked,
        R.drawable.bitsies_unlocked,
        R.drawable.bitsies_magnifier,
        R.drawable.bitsies_mail,
        R.drawable.bitsies_male,
        R.drawable.bitsies_female,
        R.drawable.bitsies_medalbronze,
        R.drawable.bitsies_medalgold,
        R.drawable.bitsies_medalsilver,
        R.drawable.bitsies_prize,
        R.drawable.bitsies_message,
        R.drawable.bitsies_piano,
        R.drawable.bitsies_microphone,
        R.drawable.bitsies_alarm,
        R.drawable.bitsies_announcement,
        R.drawable.bitsies_music,
        R.drawable.bitsies_volume,
        R.drawable.bitsies_mute,
        R.drawable.bitsies_pin,
        R.drawable.bitsies_pricetag,
        R.drawable.bitsies_quote,
        R.drawable.bitsies_sandglass,
        R.drawable.bitsies_savings,
        R.drawable.bitsies_scroll,
        R.drawable.bitsies_news,
        R.drawable.bitsies_share,
        R.drawable.bitsies_shirt,
        R.drawable.bitsies_shoppingbasket,
        R.drawable.bitsies_shoppingcart,
        R.drawable.bitsies_syringe,
        R.drawable.bitsies_suitcase,
        R.drawable.bitsies_sun,
        R.drawable.bitsies_cloud,
        R.drawable.bitsies_lightning,
        R.drawable.bitsies_snow,
        R.drawable.bitsies_umbrella,
        R.drawable.bitsies_tree,
        R.drawable.bitsies_flower,
        R.drawable.bitsies_fire,
        R.drawable.bitsies_thumbsup,
        R.drawable.bitsies_thumbsdown,
        R.drawable.bitsies_user,
        R.drawable.bitsies_useradd,
        R.drawable.bitsies_useredit,
        R.drawable.bitsies_userremove,
        R.drawable.bitsies_users,
        R.drawable.bitsies_water,
        R.drawable.bitsies_wifi,
        R.drawable.bitsies_shutdown,
        R.drawable.bitsies_sliders,
        R.drawable.bitsies_stats,
        R.drawable.bitsies_controls,
        R.drawable.bitsies_dashboard,
        R.drawable.bitsies_character,
        R.drawable.bitsies_chartbar,
        R.drawable.bitsies_chartpie,
        R.drawable.bitsies_settings,
        R.drawable.bitsies_wrench,
    )

    private val UNWANTED_COLORED_TINTABLE_ICONS = intArrayOf(
        R.drawable.bitsies_mastercard,
        R.drawable.bitsies_visa,
        R.drawable.bitsies_medalbronze,
        R.drawable.bitsies_medalsilver,
        R.drawable.bitsies_flaggreen,
        R.drawable.bitsies_flagred,
        R.drawable.bitsies_flagyellow,
    )

    private val TINTABLE_ICONS = intArrayOf(
        R.drawable.black_circle,
        R.drawable.black_rectangle,
        R.drawable.black_shape_square,
        R.drawable.black_shape_square2,
        R.drawable.black_shape_star,
        R.drawable.black_shape_triangle,
        R.drawable.black_tube,
        R.drawable.black_heart,
        R.drawable.black_help,
        R.drawable.black_media_back,
        R.drawable.black_media_end,
        R.drawable.black_media_fast_forward,
        R.drawable.black_media_pause,
        R.drawable.black_media_play,
        R.drawable.black_check,
        R.drawable.black_close,
        R.drawable.black_delete,
        R.drawable.black_synchronize,
        R.drawable.black_command_refresh,
        R.drawable.black_waiting_popup,
        R.drawable.black_warning_message,
        R.drawable.black_search,
        R.drawable.black_settings,
        R.drawable.black_swap_down,
        R.drawable.black_swap_left,
        R.drawable.black_swap_right,
        R.drawable.black_swap_up,
        R.drawable.black_left_arrow,
        R.drawable.black_next,
        R.drawable.black_reload,
        R.drawable.black_road_backward,
        R.drawable.black_road_forward,
        R.drawable.black_cursor,
        R.drawable.black_battery_charging,
        R.drawable.black_box,
        R.drawable.black_alarm_clock,
        R.drawable.black_clock,
        R.drawable.black_calendar_date,
        R.drawable.black_camera,
        R.drawable.black_cctv_camera,
        R.drawable.black_car,
        R.drawable.black_transport_school_bus,
        R.drawable.black_cycling,
        R.drawable.black_spaceship,
        R.drawable.black_cloud,
        R.drawable.black_color,
        R.drawable.black_clean,
        R.drawable.black_data_edit,
        R.drawable.black_data_information,
        R.drawable.black_device_bell,
        R.drawable.black_device_calculator,
        R.drawable.black_dice,
        R.drawable.black_display_brightness,
        R.drawable.black_display_contrast,
        R.drawable.black_document,
        R.drawable.black_business_man,
        R.drawable.black_user_female,
        R.drawable.black_user_male,
        R.drawable.black_robot,
        R.drawable.black_view,
        R.drawable.black_butterfly,
        R.drawable.black_cat,
        R.drawable.black_dog,
        R.drawable.black_fish,
        R.drawable.black_squirrel,
        R.drawable.black_turtle,
        R.drawable.black_penguin,
        R.drawable.black_footprint,
        R.drawable.black_foot_print,
        R.drawable.black_flower,
        R.drawable.black_pine_tree,
        R.drawable.black_palm_tree,
        R.drawable.black_fire,
        R.drawable.black_folder_sharing,
        R.drawable.black_fuel_station,
        R.drawable.black_gift,
        R.drawable.black_globe,
        R.drawable.black_graph,
        R.drawable.black_hand,
        R.drawable.black_hour_glass,
        R.drawable.black_house,
        R.drawable.black_houses,
        R.drawable.black_office,
        R.drawable.black_university,
        R.drawable.black_tent,
        R.drawable.black_sofa,
        R.drawable.black_identity_card,
        R.drawable.black_instrument_barometer,
        R.drawable.black_instrument_round_bottom_flask,
        R.drawable.black_instrument_telescope,
        R.drawable.black_iris,
        R.drawable.black_solar,
        R.drawable.black_moon,
        R.drawable.black_energy_saving_bulb_1,
        R.drawable.black_energy_saving_bulb_2,
        R.drawable.black_light,
        R.drawable.black_light_bulb,
        R.drawable.black_torch,
        R.drawable.black_linear_gauge,
        R.drawable.black_driller,
        R.drawable.black_key_access,
        R.drawable.black_lock,
        R.drawable.black_latitude,
        R.drawable.black_magnet,
        R.drawable.black_map_location,
        R.drawable.black_messages,
        R.drawable.black_plus,
        R.drawable.black_minus,
        R.drawable.black_movie,
        R.drawable.black_new,
        R.drawable.black_outlet_plug,
        R.drawable.black_phone,
        R.drawable.black_photograph,
        R.drawable.black_picture,
        R.drawable.black_picture_frame,
        R.drawable.black_planet,
        R.drawable.black_plug,
        R.drawable.black_power_1,
        R.drawable.black_power_2,
        R.drawable.black_printer,
        R.drawable.black_printer_2,
        R.drawable.black_puzzles,
        R.drawable.black_shape12,
        R.drawable.black_shape_spade,
        R.drawable.black_shape6,
        R.drawable.black_shape_cube,
        R.drawable.black_shape_peace,
        R.drawable.black_smile,
        R.drawable.black_laugh,
        R.drawable.black_sad,
        R.drawable.black_sleepy,
        R.drawable.black_smoking_zone,
        R.drawable.black_tag,
        R.drawable.black_target,
        R.drawable.black_toolbox,
        R.drawable.black_tools,
        R.drawable.black_headphone,
        R.drawable.black_gramaphone,
        R.drawable.black_guitar,
        R.drawable.black_recorded_media,
        R.drawable.black_beamed_notes,
        R.drawable.black_quarter_note,
        R.drawable.black_microphone,
        R.drawable.black_tape_recorder,
        R.drawable.black_loud_speaker,
        R.drawable.black_voicemail,
        R.drawable.black_speaker_volume,
        R.drawable.black_speech,
        R.drawable.black_volume_mute,
        R.drawable.black_volume_high,
        R.drawable.black_volume_low,
        R.drawable.black_announcement,
        R.drawable.black_refrigerator,
        R.drawable.black_washing_machine,
        R.drawable.black_internet,
        R.drawable.black_bluetooth,
        R.drawable.black_beep_signal,
        R.drawable.black_command_mac,
        R.drawable.black_network_sharing,
        R.drawable.black_lan,
        R.drawable.black_microsoft_windows,
        R.drawable.black_windows_pc,
        R.drawable.black_linux,
        R.drawable.black_mac_pc,
        R.drawable.black_laptop,
        R.drawable.black_ipad,
        R.drawable.black_mobile_phone,
        R.drawable.black_telephone,
        R.drawable.black_webcam,
        R.drawable.black_usb,
        R.drawable.black_mail,
        R.drawable.black_satellite,
        R.drawable.black_cd,
        R.drawable.black_dvd,
        R.drawable.black_keyboard,
        R.drawable.black_mouse,
        R.drawable.black_joystick,
        R.drawable.black_film,
        R.drawable.black_feather,
        R.drawable.black_water_tap,
        R.drawable.black_weather,
        R.drawable.black_umbrella,
        R.drawable.black_thunder,
        R.drawable.black_sports,
        R.drawable.black_bat_man,
        R.drawable.black_armor,
        R.drawable.black_sword,
        R.drawable.black_attachment,
        R.drawable.black_balloon,
        R.drawable.black_yin_yang,
        R.drawable.black_cooker,
        R.drawable.black_cutlery_fork_knife,
        R.drawable.black_snack_doughnut,
        R.drawable.black_beverage_coffee,
        R.drawable.black_cake,
        R.drawable.black_cheese,
        R.drawable.black_chef_cap,
        R.drawable.black_bell,
        R.drawable.black_book_open,
        R.drawable.black_danger,
        R.drawable.black_finger_print,
        R.drawable.black_floppy,
        R.drawable.black_hat,
        R.drawable.black_knight,
        R.drawable.black_link,
        R.drawable.black_logout,
        R.drawable.black_password,
        R.drawable.black_shape_lightning,
        R.drawable.black_button,
        R.drawable.black_table_fan,
        R.drawable.black_table_lamp,
        R.drawable.black_remote_control,
        R.drawable.black_television,
        R.drawable.black_toy,
    )

    const val DEFAULT_TINT_PREFIX = "black_"

    enum class TintColor(val prefix: String, val color: Int) {
        BLACK("black_", Color.BLACK),
        GREY("grey_", Color.GRAY),
        WHITE("white_", Color.WHITE),
    }

    val PREFIXES = setOf("black_", "grey_", "white_", "freepik_", "bitsies_", "flat_grey_", "flat_color_")
}
