/*
 * Copyright (c) 2024 Proton AG
 *
 * This file is part of ProtonVPN.
 *
 * ProtonVPN is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * ProtonVPN is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ProtonVPN.  If not, see <https://www.gnu.org/licenses/>.
 */

package com.protonvpn.android.auth.usecase

import com.protonvpn.android.auth.data.VpnUser
import com.protonvpn.android.auth.data.VpnUserDao
import dagger.Reusable
import javax.inject.Inject

interface SetVpnUser {
    suspend operator fun invoke(vpnUser: VpnUser?)
}

@Reusable
class SetVpnUserImpl @Inject constructor(
    private val vpnUserDao: VpnUserDao,
    private val currentUser: CurrentUser
) : SetVpnUser {
    override suspend operator fun invoke(vpnUser: VpnUser?) {
        if (vpnUser != null) {
            vpnUserDao.insertOrUpdate(vpnUser)
        } else {
            currentUser.vpnUser()?.let { vpnUserDao.delete(it) }
        }
        currentUser.invalidateCache()
    }
}
