/*
 * Copyright (C) 2025. Nyabsi <nyabsi@sovellus.cc>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cc.sovellus.vrcaa.api.vrchat.http.models


import com.google.gson.annotations.SerializedName

data class Avatar(
    @SerializedName("assetUrl")
    var assetUrl: String = "",
    @SerializedName("authorId")
    var authorId: String = "",
    @SerializedName("authorName")
    var authorName: String = "",
    @SerializedName("created_at")
    var createdAt: String = "",
    @SerializedName("description")
    var description: String = "",
    @SerializedName("featured")
    var featured: Boolean = false,
    @SerializedName("id")
    var id: String = "",
    @SerializedName("imageUrl")
    var imageUrl: String = "",
    @SerializedName("name")
    var name: String = "",
    @SerializedName("pendingUpload")
    var pendingUpload: Boolean = false,
    @SerializedName("releaseStatus")
    var releaseStatus: String = "",
    @SerializedName("styles")
    var styles: Styles = Styles(),
    @SerializedName("tags")
    var tags: List<String> = listOf(),
    @SerializedName("thumbnailImageUrl")
    var thumbnailImageUrl: String = "",
    @SerializedName("unityPackageUrl")
    var unityPackageUrl: String = "",
    @SerializedName("updated_at")
    var updatedAt: String = "",
    @SerializedName("version")
    var version: Long = 0,
    @SerializedName("unityPackages")
    var unityPackages: List<UnityPackage> = listOf(),
)