part of 'romanization.dart';

// ------ HEPBURN ROMANIZATION -----

// cspell: disable

const _hepburnKanaToRomajiMap = {
  'あ': {'': 'a'},
  'い': {'': 'i'},
  'う': {'': 'u'},
  'え': {'': 'e'},
  'お': {'': 'o'},
  'か': {'': 'ka'},
  'き': {
    '': 'ki',
    'ゃ': {'': 'kya'},
    'ゅ': {'': 'kyu'},
    'ょ': {'': 'kyo'},
    'ぃ': {'': 'kyi'},
    'ぇ': {'': 'kye'},
  },
  'く': {
    '': 'ku',
    'ゃ': {'': 'kya'},
    'ゅ': {'': 'kyu'},
    'ょ': {'': 'kyo'},
    'ぃ': {'': 'kyi'},
    'ぇ': {'': 'kye'},
  },
  'け': {'': 'ke'},
  'こ': {'': 'ko'},
  'さ': {'': 'sa'},
  'し': {
    '': 'shi',
    'ゃ': {'': 'sha'},
    'ゅ': {'': 'shu'},
    'ょ': {'': 'sho'},
    'ぃ': {'': 'shyi'},
    'ぇ': {'': 'she'},
  },
  'す': {'': 'su'},
  'せ': {'': 'se'},
  'そ': {'': 'so'},
  'た': {'': 'ta'},
  'ち': {
    '': 'chi',
    'ゃ': {'': 'cha'},
    'ゅ': {'': 'chu'},
    'ょ': {'': 'cho'},
    'ぃ': {'': 'chyi'},
    'ぇ': {'': 'che'},
  },
  'つ': {'': 'tsu'},
  'て': {'': 'te'},
  'と': {'': 'to'},
  'な': {'': 'na'},
  'に': {
    '': 'ni',
    'ゃ': {'': 'nya'},
    'ゅ': {'': 'nyu'},
    'ょ': {'': 'nyo'},
    'ぃ': {'': 'nyi'},
    'ぇ': {'': 'nye'},
  },
  'ぬ': {'': 'nu'},
  'ね': {'': 'ne'},
  'の': {'': 'no'},
  'は': {'': 'ha'},
  'ひ': {
    '': 'hi',
    'ゃ': {'': 'hya'},
    'ゅ': {'': 'hyu'},
    'ょ': {'': 'hyo'},
    'ぃ': {'': 'hyi'},
    'ぇ': {'': 'hye'},
  },
  'ふ': {
    '': 'fu',
    'ゃ': {'': 'fya'},
    'ゅ': {'': 'fyu'},
    'ょ': {'': 'fyo'},
    'ぃ': {'': 'fyi'},
    'ぇ': {'': 'fye'},
  },
  'へ': {'': 'he'},
  'ほ': {'': 'ho'},
  'ま': {'': 'ma'},
  'み': {
    '': 'mi',
    'ゃ': {'': 'mya'},
    'ゅ': {'': 'myu'},
    'ょ': {'': 'myo'},
    'ぃ': {'': 'myi'},
    'ぇ': {'': 'mye'},
  },
  'む': {'': 'mu'},
  'め': {'': 'me'},
  'も': {'': 'mo'},
  'ら': {'': 'ra'},
  'り': {
    '': 'ri',
    'ゃ': {'': 'rya'},
    'ゅ': {'': 'ryu'},
    'ょ': {'': 'ryo'},
    'ぃ': {'': 'ryi'},
    'ぇ': {'': 'rye'},
  },
  'る': {'': 'ru'},
  'れ': {'': 're'},
  'ろ': {'': 'ro'},
  'や': {'': 'ya'},
  'ゆ': {'': 'yu'},
  'よ': {'': 'yo'},
  'わ': {'': 'wa'},
  'ゐ': {'': 'wi'},
  'ゑ': {'': 'we'},
  'を': {'': 'wo'},
  'ん': {
    '': 'n',
    'あ': {'': "n'a"},
    'い': {'': "n'i"},
    'う': {'': "n'u"},
    'え': {'': "n'e"},
    'お': {'': "n'o"},
    'や': {'': "n'ya"},
    'ゆ': {'': "n'yu"},
    'よ': {'': "n'yo"},
  },
  'が': {'': 'ga'},
  'ぎ': {
    '': 'gi',
    'ゃ': {'': 'gya'},
    'ゅ': {'': 'gyu'},
    'ょ': {'': 'gyo'},
    'ぃ': {'': 'gyi'},
    'ぇ': {'': 'gye'},
  },
  'ぐ': {'': 'gu'},
  'げ': {'': 'ge'},
  'ご': {'': 'go'},
  'ざ': {'': 'za'},
  'じ': {
    '': 'ji',
    'ゃ': {'': 'ja'},
    'ゅ': {'': 'ju'},
    'ょ': {'': 'jo'},
    'ぃ': {'': 'jyi'},
    'ぇ': {'': 'je'},
  },
  'ず': {'': 'zu'},
  'ぜ': {'': 'ze'},
  'ぞ': {'': 'zo'},
  'だ': {'': 'da'},
  'ぢ': {
    '': 'ji',
    'ゃ': {'': 'ja'},
    'ゅ': {'': 'ju'},
    'ょ': {'': 'jo'},
    'ぃ': {'': 'jyi'},
    'ぇ': {'': 'je'},
  },
  'づ': {'': 'zu'},
  'で': {'': 'de'},
  'ど': {'': 'do'},
  'ば': {'': 'ba'},
  'び': {
    '': 'bi',
    'ゃ': {'': 'bya'},
    'ゅ': {'': 'byu'},
    'ょ': {'': 'byo'},
    'ぃ': {'': 'byi'},
    'ぇ': {'': 'bye'},
  },
  'ぶ': {'': 'bu'},
  'べ': {'': 'be'},
  'ぼ': {'': 'bo'},
  'ぱ': {'': 'pa'},
  'ぴ': {
    '': 'pi',
    'ゃ': {'': 'pya'},
    'ゅ': {'': 'pyu'},
    'ょ': {'': 'pyo'},
    'ぃ': {'': 'pyi'},
    'ぇ': {'': 'pye'},
  },
  'ぷ': {'': 'pu'},
  'ぺ': {'': 'pe'},
  'ぽ': {'': 'po'},
  'ゔぁ': {'': 'va'},
  'ゔぃ': {'': 'vi'},
  'ゔ': {
    '': 'vu',
    'ゃ': {'': 'vya'},
    'ゅ': {'': 'vyu'},
    'ょ': {'': 'vyo'},
    'ぃ': {'': 'vyi'},
    'ぇ': {'': 'vye'},
  },
  'ゔぇ': {'': 've'},
  'ゔぉ': {'': 'vo'},
  'ゎ': {'': 'wa'},
  '。': {'': '.'},
  '、': {'': ','},
  '：': {'': ':'},
  '・': {'': '/'},
  '！': {'': '!'},
  '？': {'': '?'},
  '〜': {'': '~'},
  'ー': {'': '-'},
  '「': {'': '‘'},
  '」': {'': '’'},
  '『': {'': '“'},
  '』': {'': '”'},
  '［': {'': '['},
  '］': {'': ']'},
  '（': {'': '('},
  '）': {'': ')'},
  '｛': {'': '{'},
  '｝': {'': '}'},
  '　': {'': ' '},
  'ゃ': {'': 'ya'},
  'ゅ': {'': 'yu'},
  'ょ': {'': 'yo'},
  'ぁ': {'': 'a'},
  'ぃ': {'': 'i'},
  'ぅ': {'': 'u'},
  'ぇ': {'': 'e'},
  'ぉ': {'': 'o'},
  'っ': {
    'あ': {'': 'a'},
    'い': {'': 'i'},
    'う': {'': 'u'},
    'え': {'': 'e'},
    'お': {'': 'o'},
    'か': {'': 'kka'},
    'き': {
      '': 'kki',
      'ゃ': {'': 'kkya'},
      'ゅ': {'': 'kkyu'},
      'ょ': {'': 'kkyo'},
      'ぃ': {'': 'kkyi'},
      'ぇ': {'': 'kkye'},
    },
    'く': {
      '': 'kku',
      'ゃ': {'': 'kkya'},
      'ゅ': {'': 'kkyu'},
      'ょ': {'': 'kkyo'},
      'ぃ': {'': 'kkyi'},
      'ぇ': {'': 'kkye'},
    },
    'け': {'': 'kke'},
    'こ': {'': 'kko'},
    'さ': {'': 'ssa'},
    'し': {
      '': 'sshi',
      'ゃ': {'': 'ssha'},
      'ゅ': {'': 'sshu'},
      'ょ': {'': 'ssho'},
      'ぃ': {'': 'sshyi'},
      'ぇ': {'': 'sshe'},
    },
    'す': {'': 'ssu'},
    'せ': {'': 'sse'},
    'そ': {'': 'sso'},
    'た': {'': 'tta'},
    'ち': {
      '': 'tchi',
      'ゃ': {'': 'tcha'},
      'ゅ': {'': 'tchu'},
      'ょ': {'': 'tcho'},
      'ぃ': {'': 'tchyi'},
      'ぇ': {'': 'tche'},
    },
    'つ': {'': 'ttsu'},
    'て': {'': 'tte'},
    'と': {'': 'tto'},
    'な': {'': 'na'},
    'に': {
      '': 'ni',
      'ゃ': {'': 'nya'},
      'ゅ': {'': 'nyu'},
      'ょ': {'': 'nyo'},
      'ぃ': {'': 'nyi'},
      'ぇ': {'': 'nye'},
    },
    'ぬ': {'': 'nu'},
    'ね': {'': 'ne'},
    'の': {'': 'no'},
    'は': {'': 'hha'},
    'ひ': {
      '': 'hhi',
      'ゃ': {'': 'hhya'},
      'ゅ': {'': 'hhyu'},
      'ょ': {'': 'hhyo'},
      'ぃ': {'': 'hhyi'},
      'ぇ': {'': 'hhye'},
    },
    'ふ': {
      '': 'ffu',
      'ゃ': {'': 'ffya'},
      'ゅ': {'': 'ffyu'},
      'ょ': {'': 'ffyo'},
      'ぃ': {'': 'ffyi'},
      'ぇ': {'': 'ffye'},
    },
    'へ': {'': 'hhe'},
    'ほ': {'': 'hho'},
    'ま': {'': 'mma'},
    'み': {
      '': 'mmi',
      'ゃ': {'': 'mmya'},
      'ゅ': {'': 'mmyu'},
      'ょ': {'': 'mmyo'},
      'ぃ': {'': 'mmyi'},
      'ぇ': {'': 'mmye'},
    },
    'む': {'': 'mmu'},
    'め': {'': 'mme'},
    'も': {'': 'mmo'},
    'ら': {'': 'rra'},
    'り': {
      '': 'rri',
      'ゃ': {'': 'rrya'},
      'ゅ': {'': 'rryu'},
      'ょ': {'': 'rryo'},
      'ぃ': {'': 'rryi'},
      'ぇ': {'': 'rrye'},
    },
    'る': {'': 'rru'},
    'れ': {'': 'rre'},
    'ろ': {'': 'rro'},
    'や': {'': 'ya'},
    'ゆ': {'': 'yu'},
    'よ': {'': 'yo'},
    'わ': {'': 'wwa'},
    'ゐ': {'': 'wwi'},
    'ゑ': {'': 'wwe'},
    'を': {'': 'wwo'},
    'ん': {'': 'n'},
    'が': {'': 'gga'},
    'ぎ': {
      '': 'ggi',
      'ゃ': {'': 'ggya'},
      'ゅ': {'': 'ggyu'},
      'ょ': {'': 'ggyo'},
      'ぃ': {'': 'ggyi'},
      'ぇ': {'': 'ggye'},
    },
    'ぐ': {'': 'ggu'},
    'げ': {'': 'gge'},
    'ご': {'': 'ggo'},
    'ざ': {'': 'zza'},
    'じ': {
      '': 'jji',
      'ゃ': {'': 'jja'},
      'ゅ': {'': 'jju'},
      'ょ': {'': 'jjo'},
      'ぃ': {'': 'jjyi'},
      'ぇ': {'': 'jje'},
    },
    'ず': {'': 'zzu'},
    'ぜ': {'': 'zze'},
    'ぞ': {'': 'zzo'},
    'だ': {'': 'dda'},
    'ぢ': {
      '': 'jji',
      'ゃ': {'': 'jja'},
      'ゅ': {'': 'jju'},
      'ょ': {'': 'jjo'},
      'ぃ': {'': 'jjyi'},
      'ぇ': {'': 'jje'},
    },
    'づ': {'': 'zzu'},
    'で': {'': 'dde'},
    'ど': {'': 'ddo'},
    'ば': {'': 'bba'},
    'び': {
      '': 'bbi',
      'ゃ': {'': 'bbya'},
      'ゅ': {'': 'bbyu'},
      'ょ': {'': 'bbyo'},
      'ぃ': {'': 'bbyi'},
      'ぇ': {'': 'bbye'},
    },
    'ぶ': {'': 'bbu'},
    'べ': {'': 'bbe'},
    'ぼ': {'': 'bbo'},
    'ぱ': {'': 'ppa'},
    'ぴ': {
      '': 'ppi',
      'ゃ': {'': 'ppya'},
      'ゅ': {'': 'ppyu'},
      'ょ': {'': 'ppyo'},
      'ぃ': {'': 'ppyi'},
      'ぇ': {'': 'ppye'},
    },
    'ぷ': {'': 'ppu'},
    'ぺ': {'': 'ppe'},
    'ぽ': {'': 'ppo'},
    'ゔぁ': {'': 'vva'},
    'ゔぃ': {'': 'vvi'},
    'ゔ': {
      '': 'vvu',
      'ゃ': {'': 'vvya'},
      'ゅ': {'': 'vvyu'},
      'ょ': {'': 'vvyo'},
      'ぃ': {'': 'vvyi'},
      'ぇ': {'': 'vvye'},
    },
    'ゔぇ': {'': 'vve'},
    'ゔぉ': {'': 'vvo'},
    '。': {'': '.'},
    '、': {'': ','},
    '：': {'': ':'},
    '・': {'': '/'},
    '！': {'': '!'},
    '？': {'': '?'},
    '〜': {'': '~'},
    'ー': {'': '-'},
    '「': {'': '‘'},
    '」': {'': '’'},
    '『': {'': '“'},
    '』': {'': '”'},
    '［': {'': '['},
    '］': {'': ']'},
    '（': {'': '('},
    '）': {'': ')'},
    '｛': {'': '{'},
    '｝': {'': '}'},
    '　': {'': ' '},
    'ゃ': {'': 'ya'},
    'ゅ': {'': 'yu'},
    'ょ': {'': 'yo'},
    'ぁ': {'': 'a'},
    'ぃ': {'': 'i'},
    'ぅ': {'': 'u'},
    'ぇ': {'': 'e'},
    'ぉ': {'': 'o'},
    '': '',
  },
};
const _hepburnRomajiToKanaMap = {
  'a': {'': 'あ'},
  'i': {'': 'い'},
  'u': {'': 'う'},
  'e': {'': 'え'},
  'o': {'': 'お'},
  'k': {
    'a': {'': 'か'},
    'i': {'': 'き'},
    'u': {'': 'く'},
    'e': {'': 'け'},
    'o': {'': 'こ'},
    'y': {
      'a': {'': 'きゃ'},
      'i': {'': 'きぃ'},
      'u': {'': 'きゅ'},
      'e': {'': 'きぇ'},
      'o': {'': 'きょ'},
    },
    'w': {
      'a': {'': 'くぁ'},
    },
    'k': {
      'a': {'': 'っか'},
      'i': {'': 'っき'},
      'u': {'': 'っく'},
      'e': {'': 'っけ'},
      'o': {'': 'っこ'},
      'y': {
        'a': {'': 'っきゃ'},
        'i': {'': 'っきぃ'},
        'u': {'': 'っきゅ'},
        'e': {'': 'っきぇ'},
        'o': {'': 'っきょ'},
      },
      'w': {
        'a': {'': 'っくぁ'},
      },
    },
  },
  's': {
    'a': {'': 'さ'},
    'i': {'': 'し'},
    'u': {'': 'す'},
    'e': {'': 'せ'},
    'o': {'': 'そ'},
    'y': {
      'a': {'': 'しゃ'},
      'i': {'': 'しぃ'},
      'u': {'': 'しゅ'},
      'e': {'': 'しぇ'},
      'o': {'': 'しょ'},
    },
    'w': {
      'a': {'': 'すぁ'},
      'i': {'': 'すぃ'},
      'u': {'': 'すぅ'},
      'e': {'': 'すぇ'},
      'o': {'': 'すぉ'},
    },
    'h': {
      'a': {'': 'しゃ'},
      'i': {'': 'し'},
      'u': {'': 'しゅ'},
      'e': {'': 'しぇ'},
      'o': {'': 'しょ'},
      'y': {
        'a': {'': 'しゃ'},
        'i': {'': 'しぃ'},
        'u': {'': 'しゅ'},
        'e': {'': 'しぇ'},
        'o': {'': 'しょ'},
      },
    },
    's': {
      'a': {'': 'っさ'},
      'i': {'': 'っし'},
      'u': {'': 'っす'},
      'e': {'': 'っせ'},
      'o': {'': 'っそ'},
      'y': {
        'a': {'': 'っしゃ'},
        'i': {'': 'っしぃ'},
        'u': {'': 'っしゅ'},
        'e': {'': 'っしぇ'},
        'o': {'': 'っしょ'},
      },
      'w': {
        'a': {'': 'っすぁ'},
        'i': {'': 'っすぃ'},
        'u': {'': 'っすぅ'},
        'e': {'': 'っすぇ'},
        'o': {'': 'っすぉ'},
      },
      'h': {
        'a': {'': 'っしゃ'},
        'i': {'': 'っし'},
        'u': {'': 'っしゅ'},
        'e': {'': 'っしぇ'},
        'o': {'': 'っしょ'},
        'y': {
          'a': {'': 'っしゃ'},
          'i': {'': 'っしぃ'},
          'u': {'': 'っしゅ'},
          'e': {'': 'っしぇ'},
          'o': {'': 'っしょ'},
        },
      },
    },
  },
  't': {
    'a': {'': 'た'},
    'i': {'': 'ち'},
    'u': {'': 'つ'},
    'e': {'': 'て'},
    'o': {'': 'と'},
    'y': {
      'a': {'': 'ちゃ'},
      'i': {'': 'ちぃ'},
      'u': {'': 'ちゅ'},
      'e': {'': 'ちぇ'},
      'o': {'': 'ちょ'},
    },
    's': {
      'a': {'': 'つぁ'},
      'i': {'': 'つぃ'},
      'u': {'': 'つ'},
      'e': {'': 'つぇ'},
      'o': {'': 'つぉ'},
    },
    'h': {
      'a': {'': 'てゃ'},
      'i': {'': 'てぃ'},
      'u': {'': 'てゅ'},
      'e': {'': 'てぇ'},
      'o': {'': 'てょ'},
    },
    'w': {
      'a': {'': 'とぁ'},
      'i': {'': 'とぃ'},
      'u': {'': 'とぅ'},
      'e': {'': 'とぇ'},
      'o': {'': 'とぉ'},
    },
    't': {
      'a': {'': 'った'},
      'i': {'': 'っち'},
      'u': {'': 'っつ'},
      'e': {'': 'って'},
      'o': {'': 'っと'},
      'y': {
        'a': {'': 'っちゃ'},
        'i': {'': 'っちぃ'},
        'u': {'': 'っちゅ'},
        'e': {'': 'っちぇ'},
        'o': {'': 'っちょ'},
      },
      's': {
        'a': {'': 'っつぁ'},
        'i': {'': 'っつぃ'},
        'u': {'': 'っつ'},
        'e': {'': 'っつぇ'},
        'o': {'': 'っつぉ'},
      },
      'h': {
        'a': {'': 'ってゃ'},
        'i': {'': 'ってぃ'},
        'u': {'': 'ってゅ'},
        'e': {'': 'ってぇ'},
        'o': {'': 'ってょ'},
      },
      'w': {
        'a': {'': 'っとぁ'},
        'i': {'': 'っとぃ'},
        'u': {'': 'っとぅ'},
        'e': {'': 'っとぇ'},
        'o': {'': 'っとぉ'},
      },
    },
  },
  'n': {
    'a': {'': 'な'},
    'i': {'': 'に'},
    'u': {'': 'ぬ'},
    'e': {'': 'ね'},
    'o': {'': 'の'},
    'y': {
      'a': {'': 'にゃ'},
      'i': {'': 'にぃ'},
      'u': {'': 'にゅ'},
      'e': {'': 'にぇ'},
      'o': {'': 'にょ'},
    },
    '': 'ん',
    "'": {'': 'ん'},
  },
  'h': {
    'a': {'': 'は'},
    'i': {'': 'ひ'},
    'u': {'': 'ふ'},
    'e': {'': 'へ'},
    'o': {'': 'ほ'},
    'y': {
      'a': {'': 'ひゃ'},
      'i': {'': 'ひぃ'},
      'u': {'': 'ひゅ'},
      'e': {'': 'ひぇ'},
      'o': {'': 'ひょ'},
    },
    'h': {
      'a': {'': 'っは'},
      'i': {'': 'っひ'},
      'u': {'': 'っふ'},
      'e': {'': 'っへ'},
      'o': {'': 'っほ'},
      'y': {
        'a': {'': 'っひゃ'},
        'i': {'': 'っひぃ'},
        'u': {'': 'っひゅ'},
        'e': {'': 'っひぇ'},
        'o': {'': 'っひょ'},
      },
    },
  },
  'm': {
    'a': {'': 'ま'},
    'i': {'': 'み'},
    'u': {'': 'む'},
    'e': {'': 'め'},
    'o': {'': 'も'},
    'y': {
      'a': {'': 'みゃ'},
      'i': {'': 'みぃ'},
      'u': {'': 'みゅ'},
      'e': {'': 'みぇ'},
      'o': {'': 'みょ'},
    },
    'm': {
      'a': {'': 'っま'},
      'i': {'': 'っみ'},
      'u': {'': 'っむ'},
      'e': {'': 'っめ'},
      'o': {'': 'っも'},
      'y': {
        'a': {'': 'っみゃ'},
        'i': {'': 'っみぃ'},
        'u': {'': 'っみゅ'},
        'e': {'': 'っみぇ'},
        'o': {'': 'っみょ'},
      },
    },
  },
  'y': {
    'a': {'': 'や'},
    'u': {'': 'ゆ'},
    'o': {'': 'よ'},
    'i': {'': 'い'},
    'e': {'': 'いぇ'},
    'y': {
      'a': {'': 'っや'},
      'u': {'': 'っゆ'},
      'o': {'': 'っよ'},
      'i': {'': 'っい'},
      'e': {'': 'っいぇ'},
    },
  },
  'r': {
    'a': {'': 'ら'},
    'i': {'': 'り'},
    'u': {'': 'る'},
    'e': {'': 'れ'},
    'o': {'': 'ろ'},
    'y': {
      'a': {'': 'りゃ'},
      'i': {'': 'りぃ'},
      'u': {'': 'りゅ'},
      'e': {'': 'りぇ'},
      'o': {'': 'りょ'},
    },
    'r': {
      'a': {'': 'っら'},
      'i': {'': 'っり'},
      'u': {'': 'っる'},
      'e': {'': 'っれ'},
      'o': {'': 'っろ'},
      'y': {
        'a': {'': 'っりゃ'},
        'i': {'': 'っりぃ'},
        'u': {'': 'っりゅ'},
        'e': {'': 'っりぇ'},
        'o': {'': 'っりょ'},
      },
    },
  },
  'w': {
    'a': {'': 'わ'},
    'i': {'': 'うぃ'},
    'e': {'': 'うぇ'},
    'o': {'': 'を'},
    'h': {
      'a': {'': 'うぁ'},
      'i': {'': 'うぃ'},
      'u': {'': 'う'},
      'e': {'': 'うぇ'},
      'o': {'': 'うぉ'},
    },
    'u': {'': 'う'},
    'w': {
      'a': {'': 'っわ'},
      'i': {'': 'っうぃ'},
      'e': {'': 'っうぇ'},
      'o': {'': 'っを'},
      'h': {
        'a': {'': 'っうぁ'},
        'i': {'': 'っうぃ'},
        'u': {'': 'っう'},
        'e': {'': 'っうぇ'},
        'o': {'': 'っうぉ'},
      },
      'u': {'': 'っう'},
    },
  },
  'g': {
    'a': {'': 'が'},
    'i': {'': 'ぎ'},
    'u': {'': 'ぐ'},
    'e': {'': 'げ'},
    'o': {'': 'ご'},
    'y': {
      'a': {'': 'ぎゃ'},
      'i': {'': 'ぎぃ'},
      'u': {'': 'ぎゅ'},
      'e': {'': 'ぎぇ'},
      'o': {'': 'ぎょ'},
    },
    'w': {
      'a': {'': 'ぐぁ'},
      'i': {'': 'ぐぃ'},
      'u': {'': 'ぐぅ'},
      'e': {'': 'ぐぇ'},
      'o': {'': 'ぐぉ'},
    },
    'g': {
      'a': {'': 'っが'},
      'i': {'': 'っぎ'},
      'u': {'': 'っぐ'},
      'e': {'': 'っげ'},
      'o': {'': 'っご'},
      'y': {
        'a': {'': 'っぎゃ'},
        'i': {'': 'っぎぃ'},
        'u': {'': 'っぎゅ'},
        'e': {'': 'っぎぇ'},
        'o': {'': 'っぎょ'},
      },
      'w': {
        'a': {'': 'っぐぁ'},
        'i': {'': 'っぐぃ'},
        'u': {'': 'っぐぅ'},
        'e': {'': 'っぐぇ'},
        'o': {'': 'っぐぉ'},
      },
    },
  },
  'z': {
    'a': {'': 'ざ'},
    'i': {'': 'じ'},
    'u': {'': 'ず'},
    'e': {'': 'ぜ'},
    'o': {'': 'ぞ'},
    'y': {
      'a': {'': 'じゃ'},
      'i': {'': 'じぃ'},
      'u': {'': 'じゅ'},
      'e': {'': 'じぇ'},
      'o': {'': 'じょ'},
    },
    'z': {
      'a': {'': 'っざ'},
      'i': {'': 'っじ'},
      'u': {'': 'っず'},
      'e': {'': 'っぜ'},
      'o': {'': 'っぞ'},
      'y': {
        'a': {'': 'っじゃ'},
        'i': {'': 'っじぃ'},
        'u': {'': 'っじゅ'},
        'e': {'': 'っじぇ'},
        'o': {'': 'っじょ'},
      },
    },
  },
  'd': {
    'a': {'': 'だ'},
    'i': {'': 'ぢ'},
    'u': {'': 'づ'},
    'e': {'': 'で'},
    'o': {'': 'ど'},
    'y': {
      'a': {'': 'ぢゃ'},
      'i': {'': 'ぢぃ'},
      'u': {'': 'ぢゅ'},
      'e': {'': 'ぢぇ'},
      'o': {'': 'ぢょ'},
    },
    'h': {
      'a': {'': 'でゃ'},
      'i': {'': 'でぃ'},
      'u': {'': 'でゅ'},
      'e': {'': 'でぇ'},
      'o': {'': 'でょ'},
    },
    'w': {
      'a': {'': 'どぁ'},
      'i': {'': 'どぃ'},
      'u': {'': 'どぅ'},
      'e': {'': 'どぇ'},
      'o': {'': 'どぉ'},
    },
    'd': {
      'a': {'': 'っだ'},
      'i': {'': 'っぢ'},
      'u': {'': 'っづ'},
      'e': {'': 'っで'},
      'o': {'': 'っど'},
      'y': {
        'a': {'': 'っぢゃ'},
        'i': {'': 'っぢぃ'},
        'u': {'': 'っぢゅ'},
        'e': {'': 'っぢぇ'},
        'o': {'': 'っぢょ'},
      },
      'h': {
        'a': {'': 'っでゃ'},
        'i': {'': 'っでぃ'},
        'u': {'': 'っでゅ'},
        'e': {'': 'っでぇ'},
        'o': {'': 'っでょ'},
      },
      'w': {
        'a': {'': 'っどぁ'},
        'i': {'': 'っどぃ'},
        'u': {'': 'っどぅ'},
        'e': {'': 'っどぇ'},
        'o': {'': 'っどぉ'},
      },
    },
  },
  'b': {
    'a': {'': 'ば'},
    'i': {'': 'び'},
    'u': {'': 'ぶ'},
    'e': {'': 'べ'},
    'o': {'': 'ぼ'},
    'y': {
      'a': {'': 'びゃ'},
      'i': {'': 'びぃ'},
      'u': {'': 'びゅ'},
      'e': {'': 'びぇ'},
      'o': {'': 'びょ'},
    },
    'b': {
      'a': {'': 'っば'},
      'i': {'': 'っび'},
      'u': {'': 'っぶ'},
      'e': {'': 'っべ'},
      'o': {'': 'っぼ'},
      'y': {
        'a': {'': 'っびゃ'},
        'i': {'': 'っびぃ'},
        'u': {'': 'っびゅ'},
        'e': {'': 'っ���ぇ'},
        'o': {'': 'っびょ'},
      },
    },
  },
  'p': {
    'a': {'': 'ぱ'},
    'i': {'': 'ぴ'},
    'u': {'': 'ぷ'},
    'e': {'': 'ぺ'},
    'o': {'': 'ぽ'},
    'y': {
      'a': {'': 'ぴゃ'},
      'i': {'': 'ぴぃ'},
      'u': {'': 'ぴゅ'},
      'e': {'': 'ぴぇ'},
      'o': {'': 'ぴょ'},
    },
    'p': {
      'a': {'': 'っぱ'},
      'i': {'': 'っぴ'},
      'u': {'': 'っぷ'},
      'e': {'': 'っぺ'},
      'o': {'': 'っぽ'},
      'y': {
        'a': {'': 'っぴゃ'},
        'i': {'': 'っぴぃ'},
        'u': {'': 'っぴゅ'},
        'e': {'': 'っぴぇ'},
        'o': {'': 'っぴょ'},
      },
    },
  },
  'v': {
    'a': {'': 'ゔぁ'},
    'i': {'': 'ゔぃ'},
    'u': {'': 'ゔ'},
    'e': {'': 'ゔぇ'},
    'o': {'': 'ゔぉ'},
    'y': {
      'a': {'': 'ゔゃ'},
      'i': {'': 'ゔぃ'},
      'u': {'': 'ゔゅ'},
      'e': {'': 'ゔぇ'},
      'o': {'': 'ゔょ'},
    },
    'v': {
      'a': {'': 'っゔぁ'},
      'i': {'': 'っゔぃ'},
      'u': {'': 'っゔ'},
      'e': {'': 'っゔぇ'},
      'o': {'': 'っゔぉ'},
      'y': {
        'a': {'': 'っゔゃ'},
        'i': {'': 'っゔぃ'},
        'u': {'': 'っゔゅ'},
        'e': {'': 'っゔぇ'},
        'o': {'': 'っゔょ'},
      },
    },
  },
  'q': {
    'y': {
      'a': {'': 'くゃ'},
      'i': {'': 'くぃ'},
      'u': {'': 'くゅ'},
      'e': {'': 'くぇ'},
      'o': {'': 'くょ'},
    },
    'w': {
      'a': {'': 'くぁ'},
      'i': {'': 'くぃ'},
      'u': {'': 'くぅ'},
      'e': {'': 'くぇ'},
      'o': {'': 'くぉ'},
    },
    'a': {'': 'くぁ'},
    'i': {'': 'くぃ'},
    'u': {'': 'くぅ'},
    'e': {'': 'くぇ'},
    'o': {'': 'くぉ'},
    'q': {
      'y': {
        'a': {'': 'っくゃ'},
        'i': {'': 'っくぃ'},
        'u': {'': 'っくゅ'},
        'e': {'': 'っくぇ'},
        'o': {'': 'っくょ'},
      },
      'w': {
        'a': {'': 'っくぁ'},
        'i': {'': 'っくぃ'},
        'u': {'': 'っくぅ'},
        'e': {'': 'っくぇ'},
        'o': {'': 'っくぉ'},
      },
      'a': {'': 'っくぁ'},
      'i': {'': 'っくぃ'},
      'u': {'': 'っくぅ'},
      'e': {'': 'っくぇ'},
      'o': {'': 'っくぉ'},
    },
  },
  'f': {
    'y': {
      'a': {'': 'ふゃ'},
      'i': {'': 'ふぃ'},
      'u': {'': 'ふゅ'},
      'e': {'': 'ふぇ'},
      'o': {'': 'ふょ'},
    },
    'w': {
      'a': {'': 'ふぁ'},
      'i': {'': 'ふぃ'},
      'u': {'': 'ふぅ'},
      'e': {'': 'ふぇ'},
      'o': {'': 'ふぉ'},
    },
    'a': {'': 'ふぁ'},
    'i': {'': 'ふぃ'},
    'u': {'': 'ふ'},
    'e': {'': 'ふぇ'},
    'o': {'': 'ふぉ'},
    'f': {
      'y': {
        'a': {'': 'っふゃ'},
        'i': {'': 'っふぃ'},
        'u': {'': 'っふゅ'},
        'e': {'': 'っふぇ'},
        'o': {'': 'っふょ'},
      },
      'w': {
        'a': {'': 'っふぁ'},
        'i': {'': 'っふぃ'},
        'u': {'': 'っふぅ'},
        'e': {'': 'っふぇ'},
        'o': {'': 'っふぉ'},
      },
      'a': {'': 'っふぁ'},
      'i': {'': 'っふぃ'},
      'u': {'': 'っふ'},
      'e': {'': 'っふぇ'},
      'o': {'': 'っふぉ'},
    },
  },
  '.': {'': '。'},
  ',': {'': '、'},
  ':': {'': '：'},
  '/': {'': '・'},
  '!': {'': '！'},
  '?': {'': '？'},
  '~': {'': '〜'},
  '-': {'': 'ー'},
  '‘': {'': '「'},
  '’': {'': '」'},
  '“': {'': '『'},
  '”': {'': '』'},
  '[': {'': '［'},
  ']': {'': '］'},
  '(': {'': '（'},
  ')': {'': '）'},
  '{': {'': '｛'},
  '}': {'': '｝'},
  ' ': {'': '　'},
  'x': {
    'n': {'': 'ん'},
    't': {
      'u': {'': 'っ'},
      's': {
        'u': {'': 'っ'},
      },
    },
    'w': {
      'a': {
        '': 'ゎ',
        'a': 'ゎー',
      },
    },
    'k': {
      'a': {'': 'ヵ'},
      'e': {'': 'ヶ'},
    },
    'c': {
      'a': {'': 'ヵ'},
      'e': {'': 'ヶ'},
    },
    'a': {'': 'ぁ'},
    'i': {'': 'ぃ'},
    'u': {'': 'ぅ'},
    'e': {'': 'ぇ'},
    'o': {'': 'ぉ'},
    'y': {
      'a': {'': 'ゃ'},
      'i': {'': 'ぃ'},
      'u': {'': 'ゅ'},
      'e': {'': 'ぇ'},
      'o': {'': 'ょ'},
    },
  },
  'c': {
    'a': {'': 'か'},
    'i': {'': 'き'},
    'u': {'': 'く'},
    'e': {'': 'け'},
    'o': {'': 'こ'},
    'y': {
      'a': {'': 'ちゃ'},
      'i': {'': 'ちぃ'},
      'u': {'': 'ちゅ'},
      'e': {'': 'ちぇ'},
      'o': {'': 'ちょ'},
    },
    'h': {
      'a': {'': 'ちゃ'},
      'i': {'': 'ち'},
      'u': {'': 'ちゅ'},
      'e': {'': 'ちぇ'},
      'o': {'': 'ちょ'},
      'y': {
        'a': {'': 'ちゃ'},
        'i': {'': 'ちぃ'},
        'u': {'': 'ちゅ'},
        'e': {'': 'ちぇ'},
        'o': {'': 'ちょ'},
      },
    },
    'c': {
      'a': {'': 'っか'},
      'i': {'': 'っき'},
      'u': {'': 'っく'},
      'e': {'': 'っけ'},
      'o': {'': 'っこ'},
      'y': {
        'a': {'': 'っちゃ'},
        'i': {'': 'っちぃ'},
        'u': {'': 'っちゅ'},
        'e': {'': 'っちぇ'},
        'o': {'': 'っちょ'},
      },
      'h': {
        'a': {'': 'っちゃ'},
        'i': {'': 'っち'},
        'u': {'': 'っちゅ'},
        'e': {'': 'っちぇ'},
        'o': {'': 'っちょ'},
        'y': {
          'a': {'': 'っちゃ'},
          'i': {'': 'っちぃ'},
          'u': {'': 'っちゅ'},
          'e': {'': 'っちぇ'},
          'o': {'': 'っちょ'},
        },
      },
    },
  },
  'j': {
    'a': {'': 'じゃ'},
    'i': {'': 'じ'},
    'u': {'': 'じゅ'},
    'e': {'': 'じぇ'},
    'o': {'': 'じょ'},
    'y': {
      'a': {'': 'じゃ'},
      'i': {'': 'じぃ'},
      'u': {'': 'じゅ'},
      'e': {'': 'じぇ'},
      'o': {'': 'じょ'},
    },
    'j': {
      'a': {'': 'っじゃ'},
      'i': {'': 'っじ'},
      'u': {'': 'っじゅ'},
      'e': {'': 'っじぇ'},
      'o': {'': 'っじょ'},
      'y': {
        'a': {'': 'っじゃ'},
        'i': {'': 'っじぃ'},
        'u': {'': 'っじゅ'},
        'e': {'': 'っじぇ'},
        'o': {'': 'っじょ'},
      },
    },
  },
  'l': {
    't': {
      'u': {'': 'っ'},
      's': {
        'u': {'': 'っ'},
      },
    },
    'w': {
      'a': {
        '': 'ゎ',
        'a': 'ゎー',
      },
    },
    'k': {
      'a': {'': 'ヵ'},
      'e': {'': 'ヶ'},
    },
    'c': {
      'a': {'': 'ヵ'},
      'e': {'': 'ヶ'},
    },
    'a': {'': 'ぁ'},
    'i': {'': 'ぃ'},
    'u': {'': 'ぅ'},
    'e': {'': 'ぇ'},
    'o': {'': 'ぉ'},
    'y': {
      'a': {'': 'ゃ'},
      'i': {'': 'ぃ'},
      'u': {'': 'ゅ'},
      'e': {'': 'ぇ'},
      'o': {'': 'ょ'},
    },
  },
};
