extension Normalizer on String {
  String normalize() {
    String normalizedString = this;
    //Convert the string to lower case before replacing characters
    normalizedString = normalizedString.toLowerCase();
    //Avoid unnecessary recursion on empty strings
    if (normalizedString.isNotEmpty) {
      for (String uneditedCharacter in _diacritics.keys) {
        normalizedString = normalizedString.replaceAll(uneditedCharacter, _diacritics[uneditedCharacter]!);
      }
    }
    return normalizedString;
  }
}

//List of diacritical marks
Map<String, String> _diacritics = {
  //letter with diacritical mark : letter without diacritical mark
  "á": "a",
  "ấ": "a",
  "ā́": "a",
  "ắ": "a",
  "ǻ": "a",
  "ą́": "a",
  //I'm not sure about how to normilize ǽ so I just put ae
  "ǽ": "ae",
  "b́": "b",
  "ć": "c",
  "ć̣": "c",
  "ḉ": "c",
  "d́": "d",
  "é": "e",
  "ế": "e",
  "ḗ": "e",
  "ė́": "e",
  "ę́": "e",
  "é̩": "e",
  //Not sure about ɚ́
  "ɚ́": "e",
  "f́": "f",
  "ǵ": "g",
  "h́": "h",
  "í": "i",
  "ī́": "i",
  "i̇́": "i",
  "į̇́": "i",
  "ḯ": "i",
  "ȷ́": "j",
  "ḱ": "k",
  "ĺ": "l",
  "ḿ": "m",
  "ń": "n",
  "ó": "o",
  "ố": "o",
  "ớ": "o",
  "ṍ": "o",
  "ṓ": "o",
  "ó̩": "o",
  "ǫ́": "o",
  "ǿ": "o",
  "ɔ́": "c",
  "ṕ": "p",
  "q́": "q",
  "ŕ": "r",
  "ś": "s",
  "ṥ": "s",
  "t́": "t",
  "ú": "u",
  "ǘ": "u",
  "ứ": "u",
  "ṹ": "u",
  "ū́": "u",
  "ų́": "u",
  "v́": "v",
  "ʌ́": "v",
  "ẃ": "w",
  "x́ ": "x",
  "ý": "y",
  "ȳ́": "y",
  "ź": "z",
  "ά": "a",
  "έ": "e",
  "ή": "n",
  "ί": "i",
  "ΐ": "i",
  "ό": "o",
  "ύ": "u",
  "ΰ": "u",
  "ϓ": "u",
  "ώ": "ω",
  "ѓ": "г",
  "ќ": "k",
  "ë": "e",
  "ä": "o",
  "ö": "o",
  "ü": "u",
  "à": "a",
  "è": "e",
  "ù": "u",
  "ē": "e",
  //Start of Macron(diacritic) from wikipedia's list
  "ā": "a",
  "ā̀": "a",
  "ā̂": "a",
  "ā̃": "a",
  "ǟ": "a",
  "ā̈": "a",
  "ǡ": "a",
  "a̱": "a",
  "å̄": "a",
  "ǣ": "ae",
  "b̄": "b",
  "ḇ": "b",
  "c̄": "c",
  "c̱": "c",
  "d̄": "d",
  "ḏ": "d",
  "ḕ": "e",
  "ē̂": "e",
  "ē̃": "e",
  "ê̄": "e",
  "e̱": "e",
  "ë̄": "e",
  "e̊̄": "e",
  "ḡ": "g",
  "g̱": "g",
  "ẖ": "h",
  "ī": "i",
  "ī̀": "i",
  "ī̂": "i",
  "ī̃": "i",
  "j̄": "j",
  "j̱": "j",
  "ḵ": "k",
  "l̄": "l",
  "ḹ": "l",
  "ḻ": "l",
  "m̄": "m",
  "m̱": "m",
  "n̄": "n",
  "ṉ": "n",
  "ō": "o",
  "ṑ": "o",
  "ō̂": "o",
  "ō̃": "o",
  "ȫ": "o",
  "ō̈": "o",
  "ǭ": "o",
  "ȭ": "o",
  "ȱ": "o",
  "o̱": "o",
  "ø̄": "o",
  "œ̄": "oe",
  "p̄": "p",
  "p̱": "p",
  "q̄": "q",
  "r̄": "r",
  "ṟ": "r",
  "ṝ": "r",
  "s̄": "s",
  "s̱": "s",
  "t̄": "t",
  "ṯ ": "t",
  "ū": "u",
  "ū̀": "u",
  "ū̂": "u",
  "ū̃": "u",
  "u̇̄": "u",
  "ǖ": "u",
  "ṻ": "u",
  "ṳ̄": "u",
  "u̱": "u",
  "v̄": "v",
  "w̄": "w",
  "x̄": "x",
  "x̱": "x",
  "ȳ": "y",
  "ȳ̀": "y",
  "ȳ̃": "y",
  "y̱": "y",
  "z̄": "z",
  "ẕ": "z",
  "ᾱ": "a",
  "ɛ̄": "e",
  "ῑ": "i",
  "ῡ": "u",
  "а̄": "a",
  "ӣ": "n",
  "ӯ": "y",
  //End of Macron(diacritic) wikipedia
  //Start of grave accent(Wikipedia)
  "ầ": "a",
  "ằ": "a",
  "æ̀": "ae",
  "ề": "e",
  "è̩": "e",
  "ɚ̀": "e",
  "h̀": "h",
  "ì": "i",
  "i̇̀": "i",
  "k̀": "k",
  "m̀": "m",
  "ǹ": "n",
  "ò": "o",
  "ờ": "o",
  "ồ": "o",
  "ò̩": "o",
  "ɔ̀": "c",
  "r̀": "r",
  "s̀": "s",
  "t̀": "t",
  "ǜ": "u",
  "ừ": "u",
  "v̀": "v",
  "ʌ̀": "v",
  "ẁ": "w",
  "x̀": "x",
  "ỳ": "y",
  "z̀": "z",
  "ὰ": "a",
  "ὲ": "e",
  "ὴ": "h",
  "ὶ": "i",
  "ῒ": "i",
  "ὸ": "o",
  "ὺ": "u",
  "ῢ": "u",
  "ὼ": "ω",
  "ѐ": "e",
  "ѝ": "n",
  //Circumflex list from Wikipedia
  "â": "a",
  "ẩ": "a",
  "ẫ": "a",
  "ậ": "a",
  "b̂": "b",
  "ḇ̂": "b",
  "ĉ": "c",
  "c̭": "c",
  "d̂": "d",
  "ḓ": "d",
  "ê": "e",
  "ḙ": "e",
  "ể": "e",
  "ê̌": "e",
  "ễ": "e",
  "ệ": "e",
  "ĝ": "g",
  "ĥ": "h",
  "h̭": "h",
  "î": "i",
  "i̭": "i",
  "ī̭": "i",
  "ĵ": "j",
  "k̂": "k",
  "l̂": "i",
  "ḽ": "l",
  "m̂": "m",
  "n̂": "n",
  "ṋ": "n",
  "ô": "o",
  "ổ": "o",
  "ỗ": "o",
  "ộ": "o",
  "r̂": "r",
  "r̭": "r",
  "ŝ": "s",
  "t̂": "t",
  "ṱ": "t",
  "û": "u",
  "ṷ": "",
  "v̂": "v",
  "ŵ": "w",
  "x̂": "x",
  "ŷ": "y",
  "ẑ": "z",
  //Cedilla list from Wikipedia
  "a̧": "a",
  "b̧": "b",
  "ç": "c",
  "ç̇": "c",
  "ḑ": "d",
  "ȩ": "e",
  "ȩ̇": "e",
  "ḝ": "e",
  "ə̧": "e",
  "ɛ̧": "e",
  "ģ": "g",
  "ḩ": "h",
  "i̧": "i",
  "ɨ̧": "i",
  "ķ": "k",
  "ļ": "l",
  "m̧": "m",
  "ņ": "n",
  "o̧": "o",
  "ɔ̧": "c",
  "q̧": "q",
  "ŗ": "r",
  "ş": "s",
  "ţ": "t",
  "u̧": "u",
  "x̧": "x",
  "z̧": "z",
  //Tilde
  "ñ": "n",
  //STREG add later
  //BOLLE add later
  //CARON add later
  //BREVE add later
};
