## 4.0.2

- Bug fix: fix possible null pointer exception in `TypeChecker.typeNamed` on
  invalid code.

## 4.0.1

- Require `analyzer: '>=8.1.1 <9.0.0'`.
- Allow `build: '>=3.0.0 <5.0.0'`.

## 4.0.0

- **Breaking Change**: remove `TypeChecker.fromRuntime`, use
  `TypeChecker.typeNamed` instead. This removes all use of `dart:mirror`, so
  builders using `source_gen` can be AOT compiled for better performance.
- Keep `// GENERATED FILE` comments on the first line.

## 3.1.0

- Prepare to stop using `dart:mirrors`: deprecate `TypeChecker.fromRuntime`.
  It will be removed in version `4.0.0`. Add `TypeChecker.typeNamed` which is
  the recommended replacement.
- Prepare to stop using `dart:mirrors`: add `inPackage` and `inSdk` parameters
  to `GenerateForAnnotation`. These will start being used in version `4.0.0`
  when it switches to `TypeChecker.typeNamed`.
- `InvalidGenerationSource` support for `Fragment`, `ElementDirective` and
  `Annotatable`.
- Allow `analyzer: '>=7.4.0 <9.0.0'`.

## 3.0.0

- **Breaking Change**: use the new `element2` APIs in `analyzer`. Builders that
  do resolution need to switch to the new API, see
  https://github.com/dart-lang/sdk/blob/main/pkg/analyzer/doc/element_model_migration_guide.md.
  For questions please use https://github.com/dart-lang/build/discussions.
- **Breaking Change**: annotations are now reported separately for elements
  and directives. If you use `TypeChecker().annotatedWith()`, see also
  the new `TypeChecker().libraryDirectivesAnnotatedWith()`. If you use
  `GeneratorForAnnotation` see the new `generateForAnnotatedDirective`.
- Require `build: ^3.0.0`
- Updated the minimum package versions for a number of dependencies.
- Require Dart 3.7.0
- Update the GeneratorForAnnotation optimization to skip files with well known
  annotation names such as `override`, `Deprecated`, and `pragma`.

## 3.0.0-dev

- **Breaking Change**: use the new `element2` APIs in `analyzer`. Builders that
  do resolution need to switch to the new API, see
  https://github.com/dart-lang/sdk/blob/main/pkg/analyzer/doc/element_model_migration_guide.md.
  For questions please use https://github.com/dart-lang/build/discussions.
- Updated the minimum package versions for a number of dependencies.
- Require Dart 3.7.0

## 2.0.0

- **Breaking Change**: Change `formatOutput` function to accept a language
  version parameter.
- **Formatting Change**: Generated code will no longer apply any fixes by
  default (previously it would apply the single cascades statements fix). The
  new formatter does not support applying fixes.
- Document deduplication behavior for the output of
  `GeneratorForAnnotation.generateForAnnotatedElement`.
- Support all the glob quotes.
- Require `analyzer: '>=6.9.0 <8.0.0'`
- Support the latest `package:dart_style`
- `LibraryBuilder`, `PartBuilder`, and `SharedPartBuilder` now take an optional
  `writeDescriptions` boolean. When set to `false`, headers and generator
  descriptions for the files will not be included in the builder output.
- Include `//dart format width=80` comments in files generated by a
  `LibraryBuilder` or `PartBuilder` and formatted with the default callback.
- Require Dart 3.6.0

## 1.5.0

- Add `throwOnUnresolved` configuration to the `GeneratorForAnnotation`
  constructor.
- Rename `InvalidGenerationSourceError` to `InvalidGenerationSource`. Change
  from a subtype of `Error` to a subtype of `Exception`. This may be breaking if
  a builder relies on a `on Exception catch` to ignore this error.

## 1.4.0

- Require Dart 3.0
- Support the latest `package:analyzer`.
- Add a `node` argument to `InvalidGenerationSourceError` to allow finding the
  source location from an `AstNode` over an `Element`.

## 1.3.2

* Make `TypeChecker.isAssignableFromType()` null safe.

## 1.3.1

* Always use a Uri in `part of` directives (previously a name would be used if
  the library had a non-empty one).

## 1.3.0

* Add support for `build_extensions` configuration of builders producing
  multiple files. For example:
  `build_extensions: { '.dart': ['.stub.dart', '.web.dart', '.vm.dart'] }`
* Avoid throwing when a type without a backing class is checked with
  `TypeChecker`.
* Include imports, exports, and part directives in `LibraryReader.allElements`.
  This allows `GeneratorForAnnotation` to target annotated directives.

## 1.2.7

* Update the value of the pubspec `repository` field.
* Require Dart SDK version `2.18`.
* Fix type-checking mixin elements with `TypeChecker`.

## 1.2.6

* Add support for a `preamble` option to `combining_builder`.

## 1.2.5

* Fix another issue with overly specific types.

## 1.2.4

* Fix overly-specific cast.

## 1.2.3

* Require `analyzer: '>=4.6.0 <6.0.0'`
* Require `sdk: '>=2.17.0 <3.0.0'`

## 1.2.2

* Enable the fix for single cascade statements when formatting Dart code.
  * Individual builders can opt out of this by providing a custom `formatOutput`
    function to the `PartBuilder` or `LibraryBuilder` constructors.
* Allow analyzer version 4.x.

## 1.2.1

- Allow reviving constants which are static fields defined on the class which
  represents their type. Previously we checked this pattern only for enums,
  however there are enum-like usages in classes which are not enums.
- Allow the latest version of `package:analyzer`.

## 1.2.0

- Include the `LibraryElement` in `LibraryReader.allElements`,
  `LibraryReader.annotatedWith`, and `LibraryReader.annotatedWithExact`. Run
  `GeneratorForAnnotation` generators on library elements when the `library`
  statement has the annotation.
- Add support for `build_extensions` configuration to the `PartBuilder` and
  `LibraryBuilder`. You must forward the `BuilderOptions` object to the super
  constructor for this to work.
- Fix a bug finding source locations for reporting unresolved annotations on
  parameters.
- Fix a bug checking for `part` statements on Windows.

## 1.1.1

- Drop dependency on `package:pedantic`.

## 1.1.0

* Add the `build_extensions` option to `combining_builder`, allowing output
  files to be generated into a different directory.

## 1.0.5

* Fix a bug with reviving constant expressions which are fields defined on a
  different class than their type (but in the same library).

## 1.0.4

* Fix warnings with latest analyzer, require analyzer 2.x.

## 1.0.3

* Allow the latest version of `package:analyzer`.

## 1.0.2

* Fix `TypeChecker.fromRuntimeType` for types that come from non-package uris.

## 1.0.1

* Improve the error message for a missing part directive.
* Upgrade to `package:analyzer` version `1.7.0`.

## 1.0.0

* Migrate to null safety.
* Drop deprecated APIs:
  - `ConstantReader.isAny`.
  - `ConstantReader.anyValue`.
  - `LibraryReader.classElements`.

## 0.9.10+5

* Widen `dart_style` range to include v2.x.

## 0.9.10+4

* Upgrade to `package:build` version `2.0.0`.
* Handle alias types with `DartType.aliasElement`.

## 0.9.10+3

* Allow the latest version of `package:analyzer`.

## 0.9.10+2

* Expand allowed versions for the glob package as source_gen is compatible
  to break circular dependency issues in the ecosystem.

## 0.9.10+1

* Fix a bug in the early bailout optimization where it wouldn't check for
  annotations in part files.

## 0.9.10

* Optimize for the case where we have only GeneratorForAnnotation generators,
  and we know there are no annotations present in the file at all.

## 0.9.9

* Allow `package:analyzer` version `0.41.x`.

## 0.9.8

* Add support for `allowSyntaxErrors` flag introduced in `package:build` version `1.4.0`.
* Update minimum Dart SDK to `2.10.0`.

## 0.9.7+1

* Allow `package:analyzer` version `0.40.x`.

## 0.9.7

* Match Dart language version overrides parts generated by `PartBuilder`.

## 0.9.6

* Add support for `Set` in `ConstantReader`.
  * Updated `isLiteral` and `literalValue` to handle `Set`.
  * Added `isSet` and `setValue` members.
* Include matching Dart language version overrides in generated parts if the
  source library has a language version override.
* Streamlined error handling in all builders. There should be no user-visible
  behavior change.
* Improve the error message when source code formatting fails.
* Update minimum Dart SDK to `2.7.0`.
* Changed the behavior of `LibraryReader.allElements` to include **extensions**.

## 0.9.5

* Add support for an `ignore_for_file` option to `combining_builder`.

* Expand documentation for `GeneratorForAnnotation` to make it clear that it
  only targets elements at the top level of a library.

## 0.9.4+7

* Fix an exception during error reporting when the `Element` reported is in
  a summary file rather than a source file.

## 0.9.4+6

* Allow `package:analyzer` version `0.39.x`.

## 0.9.4+5

* Fix a bug for finding the element for a function with recent versions of
  `analyzer`.

## 0.9.4+4

* Allow `pkg:analyzer` version `0.38.x`.

## 0.9.4+3

* Allow `pkg:analyzer` version `0.37.x`.

## 0.9.4+2

* Allow `pkg:analyzer` version `0.36.x`.

## 0.9.4+1

* Support the latest `pkg:analyzer`.

## 0.9.4

* Use `ParsedLibraryResult` to find source spans for unresolvable annotations.

## 0.9.3

* Rename `LibraryReader.classElements` to `LibraryReader.classes` to better
  reflect the behavior. Deprecate the old name.
* Add `LibraryReader.enums`.

## 0.9.2

* Avoid using the AST analyzer model from `LibraryReader`.
* Don't create part files with no corresponding library.
* Update analyzer constraint to allow 0.34.x.

## 0.9.1+3

* Support the latest `pkg:analyzer`.

## 0.9.1+2

* Correctly handle properties in `spanForElement`.

## 0.9.1+1

* Allow `package:build` version 1.0.0.

## 0.9.1

* The result of `ConstantReader.revive()` now returns a `Revivable` that assumes
  access to a private class, constructor, or function _instead_ of `null` where
  possible. This allows generators that use `part` files to still use this
  functionality _and_ allows generators that use separate libraries to emit more
  actionable error messages (i.e. `"cannot use private class _X"`).

* `Revivable.isPrivate` now returns `true` when the underlying class was public
  but the constructor was private, or the `Revivable` was pointing to a
  top-level or static private field or method. Previously it was only `true`
  when referencing a private class.

## 0.9.0+1

* Fix `LibraryReader.classElements` to return classes from parts, if they exist,
  as well as from the defining library file.

## 0.9.0

* Introduce `SharedPartBuilder` for creating part files that can be merged
  with a new `CombiningBuilder`. Note that `CombiningBuilder` only outputs
  `.g.dart` files.
* **Breaking** `PartBuilder` now requires a `generatedExtensions` argument. The
  value should not be `.g.dart`. To produce `.g.dart` files please use the
  `SharedPartBuilder`.

## 0.8.3+1

* Allow using non-dev Dart 2 SDK.

## 0.8.3

* `GeneratorForAnnotation`
  * `generateForAnnotatedElement` now allow multiple return values when
    implementations return an `Iterable` or `Stream`.
  * Values from `generateForAnnotatedElement` have whitespace trimmed. `null`
    and empty values are ignored.
  * Duplicate values are collapsed into a single values. This allows emitting
    shared, top-level members without naming collisions.

## 0.8.2

* Simplification to the output of generator names in header sections.

* Update handling of whitespace in generator outputs.
  * If the output from a generator has wrapping whitespace, it is trimmed.
  * If the output from a generator is empty or whitespace-only, it is ignored.
  * These changes will likely have no effect on output, unless you customize
    the code formatter.

## 0.8.1+3

* More redundant new lines elimination.

## 0.8.1+2

* Eliminate redundant new lines in the core builder. These were almost removed
  by running the default formatter. Now the unformatted code more closely
  matches the default output.

## 0.8.1+1

* Support `package:analyzer` `0.32.0`.

## 0.8.1

* Cleanup logging output that duplicates headers provided by
  `package:build_runner`.

* `InvalidGenerationSourceError` added an optional `element`
  parameter to support more helpful error messages.

## 0.8.0

* **BREAKING** removed the deprecated `requireLibraryDirective` parameter in
  `PartBuilder`.

* `Revivable` no longer throws a type error when attempting to revive a
  reference to a top-level function or static-class method. Now is returns a
  reference to that function or method, as expected.

## 0.7.6

* `TypeChecker` now throws an `UnresolvedAnnotationException` with a more
  detailed exception body (and properties useful for further debugging) instead
  of `Could not resolve @null`.

## 0.7.5+1

* `LibraryBuilder` and `PartBuilder` now have a more readable `toString()`,
  which is useful when emitting a warning or error in a build system. For
  example you may see `Generating .g.dart: MyBuilder` instead of
  `Instance of LibraryBuilder` in your build logs.

## 0.7.5

* The `PartBuilder` constructor parameter `requireLibraryDirective` now defaults
  to `false`. It will be removed in `0.8.0`.

* Require at least Dart `2.0.0-dev.19.0`.

## 0.7.4+3

* Support the latest `analyzer` package.

## 0.7.4+2

* **BUG FIX**: `ConstantReader.revive()` now properly returns no URL fragment
  when the constant expression is resolved from a top-level or static-field.
  The documentation had said otherwise, and it was impossible to tell the
  difference between a constructor and a field. _Now_, fields are always in
  the form of accessor = `{clazz}.{field}` or `{topLevelField}`.

* Fix file URIs on windows.

## 0.7.4+1

* Removed a `log.finest` with the output source of each generator. This allows
  a verbose option (`-v`) for tools like bazel or build_runner to be much more
  readable and debuggable. Files are emitted to disk for inspection in any
  case.

## 0.7.4

* Added `typeNameOf`, which is a safe way to get the name of a `DartType`,
  even when the type is a `FunctionType`, which has a `null` name in newer
  versions of the Dart analyzer.

* Added `LibraryReader.pathToUrl(Uri|String)`, which computes the `import` or
  `export` path necessary to reach the provided URL from the current library.
  Also added `pathToAsset` and `pathToElement` as convenience functions.

* Expanded `package:build` support to allow version `0.12.0`.

## 0.7.3

* Allow null and empty outputs form `GeneratorForAnnotation`.

## 0.7.2+1

* Allow `package:build` version 0.11.0

## 0.7.2

* Support an optional `header` argument to `PartBuilder` and `LibraryBuilder`.

## 0.7.1

### `Generator{ForAnnotation}`

* Return type of `generate{ForAnnotatedElement}` is now `FutureOr<String>`.

### `LibraryReader`

* Added `annotatedElements` to return all elements annotated with something.
* Added `classElements` getter for returning all `class`-es in a library.

### `TypeChecker`

* Added `hasAnnotationOf` and `hasAnnotationOfExact`.

### `ConstantReader`

* Added `isAny` (for consistency, but _deprecated_) and `isLiteral`.
* Added `literalValue` as an alias for the now deprecated `anyValue`.
* Allow `literalValue` to return `null` if the value is actually `null`.
* Fixed a bug where a `Symbol` would return as a `String` for `anyValue`.
* Fixed a bug where a `List` and `Map` were not considered literals.

## 0.7.0

* **Breaking changes**: See [the wiki](https://github.com/dart-lang/source_gen/wiki/Migrating-to-0.7.x)
  for help upgrading.
  * `Generator.generate` now operates on a `LibraryReader` rather than being
    called for every `Element` within a library. Generators can iterate over
    elements using `LibraryReader.allElements`. `GeneratorForAnnotation` will
    continue to call `generateForAnnotatedElement` repeatedly for each element.
  * `GeneratorForAnnotation` passes in a `ConstantReader` for the annotation
    instance rather than re-creating it using mirrors.
  * `GeneratorBuilder` is replaced with `PartBuilder` and `LibraryBuilder`
    depending on whether the output is meant to be included in a `part` file.
  * Removed `JsonSerializable` and related classes. These are moved to
    `package:json_serializable`.
  * Removed `lib/builder.dart`. Import through `source_gen.dart` instead.
  * Removed `OutputFormatter` typedef.

* Add `LibraryReader.allElements` - a utility to iterate across all `Element`
  instances contained in Dart library.
* Add `LibraryReader.element` to get back to the `LibraryElement` instance.
* Add `ConstantReader.objectValue` to get back to the `DartObject` instance.
* Add `ConstantReader.peek` to read a value that returns `null` if not found:

```dart
// Tries to read the field "token" first, then "_token".
findTokenField(DartObject o) {
  final reader = new ConstantReader(o);
  final token = o.peek('token') ?? o.read('_token');
}
```

* Add `throwOnUnresolved` optional parameter to `TypeChecker.annotationsOf`,
  `TypeChecker.annotationsOfExact`, `TypeChecker.firstAnnotationOf`, and
  `TypeChecker.firstAnnotationOfExact`. Setting this to `false` will enable you
  to check for matching annotations with incomplete type information (at your
  own risk).
* Builder logs now log the primary inputs `AssetId` instead of the `library`,
  which is more useful for tracking down the actual files.

## 0.6.1+1

* Tighten constraint on `source_span`.

## 0.6.1

* Added `spanForElement`; returns a `SourceSpan` for an analyzer `Element`.
* Logs a _warning_ to the console when a `GeneratorBuilder` outputs a part file
  for a given input, but that input does not define `part 'name.g.dart';`.

## 0.6.0

* **Breaking change**: `TypeChecker#annotationsOf|firstAnnotationOf` now
  returns annotations that are _assignable_ to the `TypeChecker`'s type. As a
  result we've added `#annotationsOfExact|firstAnnotationOfExact` which has the
  old behavior for precise checks.
* `TypeChecker#annotations...`-methods now throw a `StateError` if one or more
  annotations on an element are not resolvable. This is usually a sign of a
  misspelling, missing import, or missing dependency.
* Added `TypeChecker.any`, which delegates to multiple other `TypeChecker`
  implementations when making a type check.

## 0.5.10+1

* Update minimum `analyzer` package to `0.29.10`.

## 0.5.10

* Bug fixes:
  * Do not fail when "library" is omitted but nothing would be output.
  * Do not fail on extensions that don't end in ".dart" (valid use case).

## 0.5.9

* Update the minimum Dart SDK to `1.22.1`.
* Deprecated `builder.dart`: import `source_gen.dart` instead.
* Added `TypeChecker`, a high-level API for performing static type checks:

  ```dart
  import 'package:analyzer/dart/element/type.dart';
  import 'package:source_gen/source_gen.dart';

  void checkType(DartType dartType) {
    // Checks compared to runtime type `SomeClass`.
    print(const TypeChecker.forRuntime(SomeClass).isExactlyType(dartType));

    // Checks compared to a known Url/Symbol:
    const TypeChecker.forUrl('package:foo/foo.dart#SomeClass');

    // Checks compared to another resolved `DartType`:
    const TypeChecker.forStatic(anotherDartType);
  }
  ```

* Failing to add a `library` directive to a library that is being used as a
  generator target that generates partial files (`part of`) is now an explicit
  error that gives a hint on how to name and fix your library:

  ```bash
  > Could not find library identifier so a "part of" cannot be built.
  >
  > Consider adding the following to your source file:
  >
  > "library foo.bar;"
  ```

  In Dart SDK `>=1.25.0` this can be relaxed as `part of` can refer to a path.
  To opt-in, `GeneratorBuilder` now has a new flag, `requireLibraryDirective`.
  Set it to `false`, and also set your `sdk` constraint appropriately:

  ```yaml
    sdk: '>=1.25.0 <2.0.0'
  ```

* Added `LibraryReader`, a utility class for `LibraryElement` that exposes
  high-level APIs, including `findType`, which traverses `export` directives
  for publicly exported types. For example, to find `Generator` from
  `package:source_gen/source_gen.dart`:

  ```dart
  void example(LibraryElement pkgSourceGen) {
    var library = new LibraryReader(pkgSourceGen);

    // Instead of pkgSourceGen.getType('Generator'), which is null.
    library.findType('Generator');
  }
  ```

* Added `ConstantReader`, a high-level API for reading from constant (static)
  values from Dart source code (usually represented by `DartObject` from the
  `analyzer` package):

  ```dart
  abstract class ConstantReader {
    factory ConstantReader(DartObject object) => ...

    // Other methods and properties also exist.

    /// Reads[ field] from the constant as another constant value.
    ConstantReader read(String field);

    /// Reads [field] from the constant as a boolean.
    ///
    /// If the resulting value is `null`, uses [defaultTo] if defined.
    bool readBool(String field, {bool defaultTo()});

    /// Reads [field] from the constant as an int.
    ///
    /// If the resulting value is `null`, uses [defaultTo] if defined.
    int readInt(String field, {int defaultTo()});

    /// Reads [field] from the constant as a string.
    ///
    /// If the resulting value is `null`, uses [defaultTo] if defined.
    String readString(String field, {String defaultTo()});
  }
  ```

## 0.5.8

* Add `formatOutput` optional parameter to the `GeneratorBuilder` constructor.
  This is a lambda of the form `String formatOutput(String originalCode)` which
  allows you do do custom formatting.

## 0.5.7

* Support for package:analyzer 0.30.0

## 0.5.6

* Support for package:build 0.9.0

## 0.5.5

* Support package:build 0.8.x
* Less verbose errors when analyzer fails to resolve the input.

## 0.5.4+3

* Support the latest release of `pkg/dart_style`.

## 0.5.4+2

* Use the new `log` field instead of the deprecated `buildStep.logger`

## 0.5.4+1

* Give more information when `dartfmt` fails.

## 0.5.4

* Update to latest `build`, `build_runner`, and `build_test` releases.

## 0.5.3+2

* BugFix: Always release the Resolver instance, even when generation does not
  run

## 0.5.3+1

* Don't throw when running against a non-library asset and getting no
  LibraryElement

## 0.5.3

* Add matchTypes method. As with anything imported from /src/ this is
  use-at-your-own-risk since it is not guaranteed to be stable
* Internal cleanup
  * Drop some unused utility methods
  * Move cli_util to dev_dependencies
  * Avoid some deprecated analyzer apis
  * Syntax tweaks
  * Drop results.dart which had no usages

## 0.5.2

* Use library URIs (not names) to look up annotations in the mirror system.
* Loosen version constraint to allow package:build version 0.6
* Fix a bug against the latest SDK checking whether List implements Iterable

## 0.5.1+7

* Generate valid strong-mode code for typed lists.

## 0.5.1+6

* Support the latest version of `pkg/build`.

## 0.5.1+5

* Remove "experimental" comment in `README.md`.

## 0.5.1+4

* Support `package:analyzer` 0.29.0

## 0.5.1+3

* Upgrade to be compatible with the breaking changes in analyzer 0.28.0

## 0.5.1+2

* Avoid calling `computeNode()` while instantiating annotation values

## 0.5.1+1

* Support the latest version of `build` package.

## 0.5.1

* Added GeneratorBuilder option isStandalone to generate files that aren't
  part of source file.

## 0.5.0+3

* Fixed multi-line error output.

## 0.5.0+2

* Remove an outdated work-around.

* Make strong-mode clean.

## 0.5.0+1

* Support the latest version of `pkg/build`.

## 0.5.0

* **Breaking**: Switch to the `build` package for running `Generator`s. This
  means that the top level `build` and `generate` functions are no longer
  available, and have been replaced by the top level `build`, `watch`, and
  `serve` functions from the `build` package, and the `GeneratorBuilder` class.
  See `tool/build.dart`, `tool/watch.dart`, and `tool/phases.dart` for usage.

  * Note that the `build` package is experimental, and likely to change.

* **Breaking**: The build package provides an abstraction for reading/writing
  files via the `BuildStep` class, and that is now also provided to
  `Generator#generate` and `GeneratorForAnnotation#generateForAnnotatedElement`
  as a second argument.

* Timestamps are no longer included in generated code.

* There is no longer a need to specify the files related to an individual
  generator via `AssociatedFileSet`. Simply use the `BuildStep` instance to read
  and write files and the `build` package will track any files you read in and
  run incremental rebuilds as necessary.

## 0.4.8

* Added support for `Symbol` and `Type` in annotations.

* Improved error output when unable to create an instance from an annotation.

## 0.4.7+2

* Upgrade to `analyzer '^0.27.1'` and removed a work-around for a fixed
  `analyzer` issue.

## 0.4.7+1

* Upgrade to `analyzer '^0.27.0'`.

## 0.4.7

* `JsonSerializableGenerator` now supports classes with read-only properties.

## 0.4.6

* `JsonSerializable`: Added `JsonKey` annotation.

* Improved output of generation errors and stack traces.

* Require `analyzer '^0.26.2'`.

## 0.4.5+1

* Handle `null` values for `List` properties.

## 0.4.5

* `JsonSerializable`: add support for `List` values.

## 0.4.4+1

* Updated `README.md` to highlight the `build_system` package and de-emphasize
  Dart Editor.

## 0.4.4

* Added `omitGenerateTimestamp` and `followLinks` named args to `build`.

* Added `followLinks` to `generate`.

## 0.4.3+1

* Update tests to use a more reliable method to find the current package root.

## 0.4.3

* Require Dart `1.12`.

* Add implicit support for `.packages`. If the file exists, it is used.
  If not, we fall back to using the `packages` directory.

* Support the latest releases of `analyzer` and `dart_style` packages.

## 0.4.2

* Use `fromJson` if it's defined in a child field.

## 0.4.1

* Match annotations defined in parts. *Thanks, [Greg](https://github.com/greglittlefield-wf)!*

## 0.4.0+1

* Support the latest release of `analyzer` and `args`.

## 0.4.0

* Analysis no longer parses function bodies. This greatly speeds up generation,
  but it could break any usage that needs function bodies.

## 0.3.0+2

* Fixed `README.md`.

## 0.3.0+1

* Updates for move to `dart-lang` org on GitHub.

## 0.3.0

* **BREAKING** Returning a descriptive value from `generate`.

* **BREAKING** Fixed incorrectly named argument `omitGenerateTimestamp`.

* `JsonSerializable`: Handle `dynamic` and `var` as field types.

## 0.2.4

* Added `associatedFileSet` to `Generator`. Allows a generator to specify
  that changes to any file in a directory next to a Dart source file can
  initiate a generation run.

## 0.2.3

* Use `async *`. Requires SDK >= `1.9.0-dev.10`

* Protect against crash during code format.

## 0.2.2

* Added `omitGenerateTimestamp` (incorrectly spelled) named argument to
  `generate` method.

* `Generator.generate` is now called with the `LibraryElement`, too.

## 0.2.1

* Fixed critical bug affecting annotation matching.
  [#35](https://github.com/dart-lang/source_gen/issues/35)

* Started using published `dart_style` package.

## 0.2.0+2

* Tweaks to `JsonGenerator` to address
  [#31](https://github.com/dart-lang/source_gen/issues/31) and
  [#32](https://github.com/dart-lang/source_gen/issues/32)

## 0.2.0+1
* Updated `README.md` with new examples.
* Fixed sub-bullet indenting in `CHANGELOG.md`.

## 0.2.0
* **BREAKING** Moved and renamed JSON serialization classes.
* Added a `JsonLiteral` generator.
* Improved handling and reporting of Generator errors.
* `JsonGenerator`
    * Learned how to use constructor arguments.
    * Learned how to properly handle `DateTime`.

## 0.1.1
* Support for parametrized annotations.
* Add named arguments to `JsonGenerator`.

## 0.1.0+1
* `README.md` updates.

## 0.1.0
* **BREAKING** `Generator.generate` is now async – returns `Future<String>`
* Big update to `README.md`.

## 0.0.1
* Ready for experimentation.

## 0.0.0+1
* First play release.
