import '../countly_flutter.dart';

abstract class DeviceID {
  /// Changes the device ID.
  /// It determines internally whether to change the device ID on the server or not.
  Future<void> setID(String newDeviceID);

  /// Returns the currently used device ID
  Future<String?> getID();

  /// Returns the currently used device ID's type:
  /// - SDK_GENERATED : Implies that the ID was generated by the SDK
  /// - DEVELOPER_SUPPLIED : Implies that the ID was supplied by the developer
  /// - TEMPORARY_ID : Implies that the temporary ID is being used
  Future<DeviceIdType?> getIDType();

  /// Changes the device ID with merge
  /// This would merge the current user with the new user given
  /// This is a costly operation and should be used only once!
  Future<void> changeWithMerge(String newDeviceID);

  /// Changes the device ID without merge
  /// This would create a new user and reset sessions and consent
  Future<void> changeWithoutMerge(String newDeviceID);

  /// Enables temporary ID mode
  /// All requests created under this mode would be keep on hold till a real device ID is set later.
  Future<void> enableTemporaryIDMode();
}
