package cash.p.terminal.core.managers

import android.content.Context
import cash.p.terminal.core.factories.AdapterFactory
import com.tonapps.wallet.data.tonconnect.entities.DAppRequestEntity
import io.horizontalsystems.tonkit.core.TonKit
import io.horizontalsystems.tonkit.models.Network
import io.horizontalsystems.tonkit.tonconnect.TonConnectKit
import kotlinx.coroutines.flow.MutableSharedFlow
import kotlinx.coroutines.flow.asSharedFlow

class TonConnectManager(
    context: Context,
    val adapterFactory: AdapterFactory,
    appName: String,
    appVersion: String,
) {
    val kit = TonConnectKit.getInstance(context, appName, appVersion)
    val transactionSigner = TonKit.getTransactionSigner(TonKit.getTonApi(Network.MainNet))

    val sendRequestFlow by kit::sendRequestFlow
    private val _dappRequestFlow = MutableSharedFlow<DAppRequestEntityWrapper>()
    val dappRequestFlow
        get() = _dappRequestFlow.asSharedFlow()

    fun start() {
        kit.start()
    }

    suspend fun handle(scannedText: String, closeAppOnResult: Boolean = false) {
        try {
            val dAppRequest = kit.readData(scannedText)
            _dappRequestFlow.emit(DAppRequestEntityWrapper(dAppRequest, closeAppOnResult))
        } catch (e: Throwable) {

        }
    }
}

data class DAppRequestEntityWrapper(
    val dAppRequest: DAppRequestEntity,
    val closeAppOnResult: Boolean
)
