## 🚀 Обновление версии 0.50.4
_Дата релиза: 23 декабря 2025_

### ✨ Новые функции

- **Автоматический скролл для QR-кода**
  Добавлен автоматический скролл, позволяющий корректно отображать QR-код целиком, даже если он не помещается на экране устройства.

### 🧭 Улучшения и доработки

- **Улучшено получение транзакций в сети BSC**
  Оптимизирован механизм получения транзакций в блокчейне Binance Smart Chain, что повышает скорость и стабильность загрузки данных.

- **Исправлена проблема отображения QR-кодов в тёмной теме**
  QR-коды теперь корректно отображаются в тёмной теме без потери контрастности и считываемости.

### 🔧 Исправления стабильности

- **Установка ноды Monero по умолчанию при сбое авто-выбора**
  Если автоматический выбор ноды Monero не удаётся, приложение теперь корректно устанавливает ноду по умолчанию через `MoneroKitManager`, предотвращая ошибки и сбои в работе кошелька.



## 🚀 Обновление версии 0.50.3
_Дата релиза: 22 декабря 2025_

### ✨ Новые функции

- **Перенос seed-фразы с помощью QR-кода**
  Добавлена возможность переноса seed-фразы через QR-код, что позволяет избежать её утечки при использовании copy-paste и значительно повышает безопасность переноса seed-фразы между устройствами.

- **Отображение заявленного и фактического курса обмена**
  При обмене через **ChangeNOW** или **Quickex** CEX-провайдер декларирует курс, который по факту может отличаться.
  Теперь приложение отображает:
    - историю заявленного курса;
    - фактический курс обмена;
    - отклонение цены между заявленным и фактическим курсом.

### 🧭 Улучшения UX

- **Корректное отображение тикера обмена до подтверждения транзакции**
  Исправлена проблема, при которой до подтверждения транзакции отображался неверный тикер — вместо тикера токена показывался тикер блокчейна.

- **Исправлен цвет процента выгоды на экране обмена**
  Устранена ошибка, из-за которой цвет процента выгоды транзакции отображался некорректно.

### 🔧 Исправления и улучшения производительности

- **Исправлен выбор активного провайдера обмена**
  Устранена проблема, при которой активный провайдер обмена периодически не выбирался.

- **Исправлен краш при создании отчёта разработчикам объёмом более 2 МБ**
  Приложение больше не падает при формировании отчётов с большим объёмом данных.

- **Ускорен парсинг транзакций для BSC**
  Реализован механизм ускорения парсинга транзакций в блокчейне **Binance Smart Chain (BSC)**, что повышает общую производительность приложения.

- **Исправлены проблемы с nullability в логике выбора Monero-ноды**
  Повышена стабильность выбора ноды для Monero-кошелька за счёт корректной обработки nullable-состояний.

- **Исправлен краш на некоторых устройствах при работе с виджетами**
  Приложение больше не падает при взаимодействии с элементами виджета на отдельных устройствах.

- **Корректная обработка отсутствующих intent extras в KeyStoreActivity**
  При отсутствии необходимых параметров приложение теперь перенаправляет пользователя в **MainModule**, вместо аварийного завершения работы.



## 🚀 Обновление версии 0.50.2
_Дата релиза: 16 декабря 2025_

### ✨ Новые функции

- **Премиум-функция Duress Backup**
  Добавлена резервная копия с шифрованием и правдоподобным отрицанием. По файлу backup невозможно определить:
    - сколько кошельков он содержит;
    - есть ли в нём скрытые данные.
      Один и тот же файл резервной копии расшифровывается по-разному в зависимости от пароля:
    - **duress-пароль** открывает только duress-кошельки;
    - **основной пароль** открывает все кошельки.

- **Очистка кеша приложения**
  Добавлена функция очистки:
    - сетевого кеша;
    - кеша изображений;
    - кеша базы данных;
    - кеша рыночных цен.
      Путь: **Настройки → О приложении → Статус приложения → Кеш приложения**.

### 🧭 Улучшения UX

- **Добавлено состояние загрузки на экране транзакций**
  Ранее пользователь мог видеть сообщение об отсутствии транзакций, хотя они ещё загружались из-за нехватки ресурсов на устройстве.
  Теперь:
    - сообщение «Нет транзакций» отображается только если их действительно нет;
    - во время загрузки показывается индикатор или скелетон, чтобы избежать ложной тревоги.

### 🔧 Исправления и улучшения

- **Улучшено сопоставление тикеров для Quickex**
  Исправлена проблема, при которой не находился **Bitcoin (BTC)**.

- **Исправлено восстановление удалённых кошельков**
  Устранена ошибка, при которой в редких случаях удалённые кошельки могли восстанавливаться обратно при наличии незавершённых операций синхронизации.



## 🛠 Обновление версии 0.50.1
_Дата релиза: 13 декабря 2025_

### 🐞 Исправления и улучшения стабильности

- **Исправлена проблема с отсутствием вариантов обмена нативных монет в Quickex**
  Ранее для нативных монет (включая **ZEC**) провайдер **Quickex.io** мог не возвращать доступные варианты обмена — проблема устранена.

- **Исправлен краш при отсутствии данных по объёмам**
  Приложение больше не падает в ситуациях, когда объёмы торгов недоступны или равны нулю.

- **Исправлен редкий краш в Bitcoin Kit**
  Повышена стабильность работы Bitcoin-кошелька в редких граничных сценариях.



## 🚀 Основные изменения версии 0.50.0
_Дата релиза: 12 декабря 2025_

### 🏴‍☠️ Ключевые нововведения

- **Добавлена поддержка брендированных карт Tangem**
  Реализована поддержка **Semiconductor Smart Card Tangem x P Cash** — полноценная интеграция брендированных аппаратных карт Tangem.

- **Добавлен CEX-обменник Quickex.io**
  Подключён новый централизованный обменник **Quickex.io** для обмена между валютами, расширяя выбор провайдеров и повышая надёжность свопов.

### 🔄 Обмен и комиссии

- **Исправлена ошибка уменьшения суммы BTC при обмене через ChangeNow**
  В редких случаях итоговая сумма BTC была меньше ожидаемой — проблема устранена.

- **Исправлён неверный расчёт комиссии при отправке Jetton**
  Комиссия теперь рассчитывается корректно и соответствует реальным сетевым затратам.

- **Улучшено отображение данных при выборе провайдера обмена**
  Теперь отображается больше информации:
    - текущий курс
    - сравнение с лучшим доступным предложением
    - на сколько выбранный обмен хуже/лучше альтернатив

### 🔐 Безопасность и UX

- **Дополнительный слой защиты при создании кошелька**
  Улучшена логика создания кошелька в момент, когда пользователь настраивает пароль для сид-фразы, чтобы избежать недопонимания и ошибочных действий.

- **Исправлена проблема с крупным шрифтом**
  Исправлена ошибка, при которой элементы управления (включая удаление кошелька) были недоступны при увеличенном размере шрифта.

- **Улучшен механизм чтения QR-кодов**
  Обновлены логика и анимации сканирования — приложение теперь корректно обрабатывает частично повреждённые или нестандартные QR-коды.

### 🛠 Стабильность и исправления

- **Исправлено падение при `WalletManager.getActiveWallets`**
  Устранён краш при получении активных кошельков.

- **Исправлено падение при `SQLiteConnection.nativeOpen`**
  Улучшена стабильность работы с локальной базой данных.



## 🚀 Основные изменения версии 0.49.4
_Дата релиза: 2 декабря 2025_

### 🛠 Исправления и улучшения

- **Исправлено отображение кнопки "Копировать"**
  Кнопка копирования теперь корректно помещается в меню для EVM-адресов и Zcash Unified Full Viewing Key.

- **Добавлены типы Zcash-адресов**
  В режиме получения монет теперь отображается тип адреса:
  **Transparent / Unified / Shielded**, в зависимости от выбранной сети.

- **Корректировка изменения цены активов**
  Исправлена ошибка, при которой цена некоторых активов не обновлялась из-за слишком малого изменения.

- **Исправлено падение WalletManager Monero на Pixel 6 Pro**
  Устранён краш, возникавший на некоторых устройствах Pixel 6 Pro при работе Monero-кошелька.

- **Исправлен краш при сканировании QR на экране Swap**
  QR-сканер теперь работает стабильно.

- **Исправлено падение Monero fee на некоторых устройствах**
  Обработка комиссии Monero стала надёжнее и больше не вызывает вылетов.

- **Улучшена инициализация WalletKit**
  Улучшена обработка ошибок при запуске WalletKit, что устраняет падения на ряде устройств.



## 🚀 Основные изменения версии 0.49.3
_Дата релиза: 1 декабря 2025_

### 🛠 Исправления и улучшения

- **Корректное отображение исходящих транзакций ZEC и TON**
  Исправлена ошибка, из-за которой исходящие транзакции **ZEC / TON** могли не отображаться в общем списке транзакций.

- **Новый механизм синхронизации BNB токенов**
  Полностью переписан механизм синхронизации токенов сети **BNB Smart Chain**, так как **Etherscan больше не поддерживает старый метод API**.
  Теперь используется новый стабильный механизм, совместимый с текущей инфраструктурой.

- **Уменьшено количество падений SQLiteConnection.nativeOpen**
  Добавлен защитный механизм и оптимизации, которые снижают вероятность ошибки `SQLiteConnection.nativeOpen` на некоторых устройствах (особенно старых и с низкой памятью).

- **Исправлено падение NavigationExtensionKt.slideFromBottom**
  Закрыт баг, из-за которого приложение могло падать при открытии экранов через анимацию `slideFromBottom`.



## 🚀 Основные изменения версии 0.49.2
_Дата релиза: 22 ноября 2025_

### 🛠 Исправления и улучшения
- **Отображение обменных транзакций ChangeNOW**
    - Исправлена проблема, при которой в некоторых случаях при обменах через **ChangeNOW** вместо заявки отображалась только исходящая транзакция.
    - Теперь корректно отображается сама заявка и её статус.



## 🚀 Основные изменения версии 0.49.0-1
_Дата релиза: 20 ноября 2025_

### ✨ Новые возможности
- **Интеграция с Alpha AML**
    - Добавлена поддержка сервиса **alpha-aml.com** — инструмента для проверки криптокошельков и транзакций.
      Alpha AML помогает пользователю:
      - оценивать уровень риска взаимодействия с адресами;
      - выявлять кошельки из блэклистов, санкционных реестров и скам-отчётов;
      - избегать получения потенциально «грязной» криптовалюты.

### 🛠 Исправления и улучшения
- **Проверка smart contract адресов**
    - Исправлена проблема, связанная с проверкой адреса на smart contract.
- **Отправка средств на Smart Contract**
    - Исправлена и доработана логика отправки средств на smart contract:
      - устранена проблема, из-за которой RPC не возвращал корректную стоимость транзакции;
      - добавлен механизм расчёта комиссии через dummy-адрес `0x0000000000000000000000000000000000000000`;
      - добавлено предупреждение для пользователя:
      _«Не удалось точно рассчитать комиссию сети. Мы подставили примерное значение, но транзакция может не пройти или комиссия может быть выше нормы.»_
- **BalanceAdapterRepository**
    - Исправлено падение приложения, возникавшее из-за ошибки **concurrency exception** в `BalanceAdapterRepository`.



## 🚀 Основные изменения версии 0.48.9
_Дата релиза: 19 ноября 2025_

### ✨ Новые возможности
- **Премиум: Чтение QR-кода из файла**
    - Добавлена новая премиум-функция: возможность **читать QR-код из изображения/файла**.
      Удобно при оплате на сайтах, где пользователь видит QR-код, но не может отсканировать его камерой.
- **Zcash: Повышение анонимности при обмене через CEX**
    - Реализована механика использования **временных адресов refund**, что повышает приватность при операцияx с CEX.
- **Zcash: Pending-транзакции**
    - После отправки транзакции теперь автоматически создаётся **локальная pending-запись** во всех режимах t/u/z.
- **QR-коды: Улучшенная генерация**
    - Обновлён алгоритм генерации QR-кодов:
      - больше детализации,
      - улучшена коррекция ошибок,
      - устранены проблемы со сканированием на некоторых устройствах.

### 🛠 Исправления и улучшения
- **EVM-ссылки:**
    - Ссылки на транзакции теперь ведут **напрямую на нужный блокчейн-эксплорер**, а не через etherscan.io — это убрало путаницу у пользователей.
- **mempool.merkle.io:**
    - Исправлена ошибка, из-за которой иногда появлялось ложное сообщение о невозможности подключения при отправке токенов.
- **Краш-фиксы:**
    - Исправлены падения при открытии следующих модулей и экранов:
        - `SwapConfirmFragmentKt.SwapConfirmScreen`
        - `SendEvmModule$Factory.<init>`
        - `SendTonModule$Factory.<init>`
        - `SwapSelectProviderViewModel.<init>`
        - `NavigationExtensionKt.slideFromRight`
        - `SendBitcoinModule$Factory.<init>`
    - Исправлена критическая ошибка **Fatal Exception: java.lang.OutOfMemoryError**.
- **DASH:**
    - Исправлены ошибки взаимодействия с сетью DASH и оптимизирован механизм отправки.
- **Zcash SDK:**
    - Обновлена версия **Zcash SDK до 2.4.0**.



## 🚀 Основные изменения версии 0.48.8
_Дата релиза: 11 ноября 2025_

### ✨ Новые возможности
- **InstantSend:**
  - Добавлена поддержка **InstantSend** для сетей **DASH / PirateCash / Cosanta**, что ускоряет подтверждение транзакций и повышает скорость отправки средств.

### 🛠 Исправления и улучшения
- **Адреса пожертвований:**
  - Обновлены адреса **Donate**. Проект развивается за счёт поддержки сообщества — спасибо всем, кто помогает развитию приложения.
- **EVM комиссии:**
  - Исправлена ошибка, связанная с отображением **тикера комиссии** в EVM-блокчейнах.
- **Ston.fi:**
  - Исправлена проблема при покупке активов на DEX **Ston.fi**, из-за которой не всегда корректно находились котировки.



## 🚀 Основные изменения версии 0.48.7
_Дата релиза: 7 ноября 2025_

### ✨ Новые возможности
- **EVM-транзакции:**
  - Добавлена поддержка **feeCoin** и улучшено отображение **предупреждений** при подготовке транзакций в сетях EVM, что делает работу с комиссиями более понятной и безопасной.

### 🛠 Исправления и улучшения
- **Кнопка обмена:**
  - Исправлена ошибка, из-за которой **кнопка Swap** могла быть активна в ряде случаев.



## 🚀 Основные изменения версии 0.48.6
_Дата релиза: 6 ноября 2025_

### ✨ Новые возможности
- **Синхронизация рынков:**
  - Улучшен механизм **обновления и синхронизации данных по рынкам**, что повышает стабильность и скорость получения актуальной информации.

### 🛠 Исправления и улучшения
- **Monero:**
  - Улучшена работа с памятью и добавлено больше диагностических логов.
    Также исправлена потенциальная проблема, которая могла приводить к ошибке **memory allocation (std::bad_alloc)**.
- **Keystore (HONOR):**
  - Исправлена потенциальная проблема совместимости при работе с **Android Keystore** на устройствах **HONOR**.



## 🚀 Основные изменения версии 0.48.5
_Дата релиза: 5 ноября 2025_

### ✨ Новые возможности
- **Кэш токенов при первом запуске**
  - Добавлен локальный **кэш списка токенов**, который используется в случае, если при первом запуске приложения
    по каким-либо причинам не удалось загрузить данные из сети.
    Это делает запуск приложения более стабильным и предотвращает проблемы с пустым списком токенов.



## 🚀 Основные изменения версии 0.48.4
_Дата релиза: 4 ноября 2025_

### ✨ Новые возможности
- **Bitcoin-like сети:**
  - Теперь вы можете **использовать средства сразу после первого подтверждения транзакции**,
    не дожидаясь полного количества подтверждений сети — это ускоряет работу с BTC, LTC и другими подобными блокчейнами.

### 🛠 Исправления и улучшения
- **Tangem:**
  - Исправлена проблема **отправки монет с кошельков Tangem**, когда используется несколько подписей (разные адреса).
    Теперь такие транзакции проходят корректно.
- **Главный экран:**
  - Улучшен механизм **скрытия балансов** — теперь анимация и поведение более стабильны и плавны.



## 🚀 Основные изменения версии 0.48.3
_Дата релиза: 1 ноября 2025_

### ✨ Новые возможности
- **Премиум: Чтение QR-кода из файла**
  - Добавлена новая функция — **сканирование QR-кодов прямо из изображения или файла**.
    Удобно, если код сохранён заранее или получен в виде скриншота.
- **Расширенный лог Monero:**
  - Добавлен **расширенный режим логирования** для кошелька Monero,
    чтобы разработчики могли быстрее помогать пользователям при проблемах с синхронизацией или балансом.

### 🛠 Исправления и улучшения
- **Monero:**
  - Исправлена ошибка, возникавшая при **неверной дате создания кошелька Monero** — теперь такие случаи обрабатываются корректно.
- **ChangeNOW (TON Jetton):**
  - Исправлена **ошибка при обмене Jetton-токенов** на блокчейне TON через ChangeNOW.
- **Авторизация по PIN:**
  - Исправлена проблема, из-за которой **процесс входа по PIN-коду занимал слишком много времени**.



## 🚀 Основные изменения версии 0.48.2
_Дата релиза: 26 октября 2025_

### ✨ Новые возможности
- **Премиум: Удаление всех кошельков**
  - Добавлена новая функция — **удаление всех кошельков по секретному PIN-коду**.
    Позволяет мгновенно очистить приложение в экстренной ситуации, сохраняя вашу конфиденциальность.
- **Обновление курсов:**
  - При **свайпе вниз на главном экране** теперь происходит **принудительное обновление курсов монет** в реальном времени.

### 🛠 Исправления и улучшения
- **Премиум режим:**
  - Улучшена **проверка состояния премиум-функций**, что повышает стабильность работы и надёжность активации.



## 🚀 Основные изменения версии 0.48.1
_Дата релиза: 24 октября 2025_

### ✨ Новые возможности
- **Премиум: Скрытый кошелёк**
  - Добавлена новая функция — **«Скрытый кошелёк»**, позволяющая создавать отдельные кошельки, защищённые **уникальными PIN-кодами**.
    Это удобно для хранения приватных средств или разделения личных и рабочих кошельков.
- **Monero:**
  - Улучшен механизм **синхронизации кошелька Monero**, что повышает стабильность работы и точность обновления балансов.

### 🛠 Исправления и улучшения
- **Changelog (тёмная тема):**
  - Исправлена ошибка отображения **текста Changelog в тёмной теме**.
- **Журналы ошибок:**
  - Доработан механизм **ротации старых логов приложения** — теперь старые данные автоматически удаляются,
    **никогда не покидают ваше устройство**, но при необходимости вы можете безопасно поделиться логами с разработчиками для анализа проблем.



## 🚀 Основные изменения версии 0.48.0
_Дата релиза: 22 октября 2025_

### ✨ Новые возможности
- **Настройка отображения чисел:**
  - Добавлена возможность **отключать автоматическое округление** чисел на главном экране. Теперь вы можете видеть точное значение без сокращений (тыс., млн. и т.д.).
- **История транзакций:**
  - В список транзакций добавлено **время самой транзакции**.
- **Локализация чисел (RU / UA):**
  - Для русского и украинского интерфейсов числа теперь всегда отображаются с:
    - пробелом в качестве **разделителя тысяч**;
    - точкой как **знаком дробной части**, независимо от системных настроек устройства.
- **Проверка отправки на контракт (Premium):**
  - Доработан механизм проверки: теперь **адреса специфических кошельков** (например, TrustWallet и MetaMask, реализованных как контракты) **не вызывают ложное предупреждение** о переводе на контракт.
- **Мониторинг токенов:**
  - Улучшен механизм работы с токенами, добавленными вручную: если токен появляется в нашей базе, **он автоматически синхронизируется** с мониторингом цены и отображением иконки.

### 🎨 Интерфейс
- **Иконка приложения:**
  - Обновлена **иконка приложения** в соответствии с новым брендингом **p.cash**.
- **Changelog:**
  - Улучшено **форматирование текста** в разделе Changelog для большей читаемости и единообразия.



## Основные изменения версии 0.47.6
_Дата релиза: 14 октября 2025_

### ✨ Новые возможности
- **Отправка монет:**
  - Добавлена возможность **вставлять сумму** прямо из буфера обмена при отправке монет.
- **MEV Protection:**
  - Приложение теперь **запоминает последний выбранный статус MEV-защиты** и автоматически восстанавливает его при следующем запуске.
- **Аппаратная карта:**
  - Улучшено взаимодействие с аппаратной картой при добавлении токенов — теперь пользователю показывается **ошибка, если токен не может быть добавлен**.

### 🛠 Исправления
- **Аппаратная карта:**
  - Исправлена ошибка, из-за которой токен **не добавлялся в режиме обмена**.
- **ZEC обмен:**
  - Исправлено потенциальное **NullPointerException** при получении **refund-адреса ZEC**.



## Основные изменения версии 0.47.5
_Дата релиза: 11 октября 2025_

### ✨ Новые возможности
- **MEV Protection:**
  - Теперь DEX-обмены выполняются с защитой от **MEV-атак** — больше никаких фронтранеров, съедающих вашу прибыль.
- **ZEC обмен:**
  - Добавлено предупреждение при обмене **ZEC**, так как для возврата используется **t-адрес**, что может частично деанонимизировать пользователя.
- **ZEC восстановление:**
  - Теперь можно указывать **дату рождения кошелька** в формате даты, а не только высоту блока.

### 🛠 Исправления
- **Ton Connect:**
  - Удалены кошельки, не поддерживающие Ton Connect (например, **Monero** с 25 словами).
- **Monero:**
  - Исправлена проблема, из-за которой данные кошелька могли повреждаться — добавлен механизм **автоматического восстановления**.



## Основные изменения версии 0.47.4
_Дата релиза: 8 октября 2025_

### 🛠 Исправления
- **Отправка DOGE и LTC:**
  - Исправлена проблема, при которой транзакция отображалась на **Blockchair**, но не попадала в блокчейн.
- **EVM-транзакции:**
  - Устранено задвоение транзакций — сумма получения больше не отображается дважды.
- **Monero:**
  - Исправлено падение приложения при использовании **Monero**.



## Основные изменения версии 0.47.3
_Дата релиза: 5 октября 2025_

### ✨ Новые возможности
- **Аппаратный кошелёк:**
  - Изменена логика добавления монет по умолчанию для аппаратного кошелька.

### 🛠 Исправления
- **Обмен TRX-20:**
  - Исправлено падение приложения при установке разрешения на обмен **TRX-20** токенов.
- **Добавление токенов:**
  - Удалено обязательное поле номера карты при добавлении токена для аппаратного кошелька.



## Основные изменения версии 0.47.2
_Дата релиза: 4 октября 2025_

### ✨ Новые возможности
- **Создание кошелька:**
  - Теперь при создании кошелька автоматически добавляются монеты **ZEC (Unified)** и **Monero**.

### 🛠 Исправления
- **Обмен TRX:**
  - Исправлена проблема, из-за которой при обмене **TRX** процесс мог зависать на этапе определения котировки.



## Основные изменения версии 0.47.1
_Дата релиза: 3 октября 2025_

### ✨ Новые возможности
- **Ston.fi (V1/V2):**
  - Теперь поддерживается работа как с **V1**, так и с **V2** версиями ликвидности.
- **Режим обмена:**
  - Добавлено отображение изменения цены по цветовой схеме:
    - 🟢 **Зелёный** — обмен выгодный (плюс).
    - 🔴 **Красный** — обмен с потерями.
    - ⚪ **Белый** — без потерь.

### 🛠 Исправления
- **Ton Connect (UI):**
  - Исправлена визуальная проблема при удалении соединения.



## Основные изменения версии 0.47.0
_Дата релиза: 1 октября 2025_

### ✨ Новые возможности
- **Обмен токенов Jetton:**
  - Добавлена возможность обмена токенов Jetton прямо в приложении через DEX-биржу **Ston.fi**.
- **Поддержка Maya Swap:**
  - Теперь доступна интеграция с **Maya Swap**.

### 🛠 Исправления
- **Orphan-блоки:**
  - Исправлена проблема с блоками orphan, что решает ошибки при отправке монет для Bitcoin-форков
    (**BTC / LTC / DASH / PIRATE / COSANTA / DOGE**).
- **Ton Connect (UI):**
  - Исправлено отсутствие скролла в селекте при выборе Ton Connect.
  - Устранена визуальная ошибка при удалении подключения, а также поправлен отступ в интерфейсе.
- **Режим премиума:**
  - Исправлена проблема отображения суммы **PIRATE** (текст не помещался на экран).



## Основные изменения версии 0.46.8
_Дата релиза: 19 сентября 2025_

### ✨ Новые возможности
- **Режим приватности:**
  - При скрытии транзакций теперь дополнительно скрывается адрес и тип операции, чтобы исключить возможность идентификации транзакции по первым и последним символам адреса.
- **Отображение суммы:**
  - На экране подтверждения транзакции убрано округление — теперь показывается точное значение отправляемой суммы.

### 🛠 Исправления
- **Etherscan API:**
  - Исправлена работа с обновлённым API транзакций (V2).
- **Стабильность:**
  - Устранена ошибка, из-за которой приложение могло падать при попытке открыть окно отправки транзакции до завершения синхронизации.



## Основные изменения версии 0.46.7
_Дата релиза: 17 сентября 2025_

### ✨ Новые возможности
- **TonConnect:**
  - Теперь вы можете подключать приложение к мини-игре [@piratecash](https://t.me/piratecash).
  - Поддержка подключения кошелька к биржам [ston.fi](https://ston.fi) и [dedust.io](https://dedust.io).
- **Сканирование TonConnect:**
  Возможность сканировать QR-код прямо с главного экрана.
- **Аппаратный кошелёк:**
  Поддержка подписания транзакций через TonConnect для аппаратного кошелька.

### 🛠 Исправления
- **TonConnect:**
  Улучшена обработка сбоев при работе с экраном TonConnect и при подписании через аппаратный кошелёк.



## Основные изменения версии 0.46.6
_Дата релиза: 16 сентября 2025_

### 🛠 Исправления
- **Список монет и токенов:**
  Теперь они отображаются в правильном порядке, как ожидает пользователь.

- **WalletConnect (Tangem):**
  При подключении карты Tangem больше не требуется резервная копия.

- **После отправки транзакции:**
  Приложение показывает статус операции и автоматически возвращается на главный экран.

- **Обозреватель блоков:**
  В режиме синхронизации для PirateCash и Cosanta исправлены названия на корректные.

- **Адреса получения:**
  Теперь отображаются все адреса даже для нестандартных транзакций.



## Основные изменения версии 0.46.5
_Дата релиза: 13 сентября 2025_

### 🎛 Улучшения
- **Интерфейс отправки:**
  Полностью переработан экран отправки — теперь **адрес и сумма находятся на одном экране**, что позволяет лучше контролировать процесс отправки.

- **Локализация (RU/UA):**
  Исправлена ошибка с отображением описания типа проверки контракта на русском и украинском языках. Добавлены небольшие визуальные улучшения для этих локализаций.



## Основные изменения версии 0.46.4
_Дата релиза: 6 сентября 2025_

### 🎛 Улучшения
- **Wallet warning:**
  Исправлена проблема, при которой иногда отображался варнинг кошелька null.

- **Wallet Connect (Reown):**
  Обновлена версия Wallet Connect и переписан код на более свежую библиотеку **Reown**, так как Wallet Connect перешёл в статус End-of-Life (17 февраля 2025).

- **Подпись сообщений через Tangem:**
  Исправлена проблема подписи сообщения Wallet Connect в некоторых случаях при использовании **карты Tangem**.

- **Синхронизация DASH (Hybrid):**
  Исправлена проблема, при которой в некоторых случаях **останавливалась синхронизация DASH** в режиме **Hybrid**.



## Основные изменения версии 0.46.3
_Дата релиза: 3 сентября 2025_

### ✨ Новые возможности
- **Просмотр адреса входящих транзакций (Bitcoin-like сети):**
  Теперь в деталях входящей транзакции отображается **адрес, на который пришли средства** для следующих блокчейнов: **BTC / LTC / DASH / DOGE / PIRATE / COSA**. Это упрощает аудит и отслеживание поступлений.

- **Monero (режим 25 слов): добавлен QR-сканер**
  Для кошельков в режиме сид-фразы из 25 слов на **главном экране** появилась возможность **сканировать адрес получателя** (QR). Это ускоряет процесс отправки и снижает риск ошибок при вводе.

### 🎛 Улучшения
- **Клонирование (копирование) кошельков:**
  Теперь при клонировании профиля кошелька **наследуется статус backup** — это делает процесс более удобным и последовательным.

### 💎 Премиум
- Исправлена проблема, из-за которой **нельзя было активировать Premium** в некоторых случаях.
- Улучшена работа механизма Premium в целом.



## Основные изменения версии 0.46.2
_Дата релиза: 29 августа 2025_

### ✨ Новые возможности
- **Клонирование кошелька (без буфера обмена):**

  Создавайте дополнительный профиль кошелька на той же **seed-фразе** с **другим паролем** — без копирования seed в буфер обмена. Это повышает безопасность и ускоряет настройку альтернативного кошелька.

### 🎛 Улучшения интерфейса
- В разделе **Stacking** теперь отображается ваш статус **Premium**

### 🛠 Важные исправления
- Исправлено падение приложения при работе с блокчейном **Solana**
- Исправлено падение приложения при работе с блокчейном **Bitcoin**
- Исправлена работа **Demo Premium**



## Основные изменения версии 0.46.1
_Дата релиза: 27 августа 2025_

### ✨ Новые возможности

- Добавлена новая механика отображения изменения цены:
  - В процентах и в фиате
  - Доступны интервалы: **1 час, 1 день, 1 неделя, 1 месяц, 1 год и всё время**
  - Добавлена поддержка **украинского языка**

### 🎛 Улучшения интерфейса

- Полностью переделан режим управления токенами:
  - Интерфейс стал более понятным и удобным
  - Добавлена новая навигация с быстрым доступом через иконку 🔍 на главном экране. При этом сохранён и старый режим, если вы к нему привыкли

### 🛠 Важные исправления

- Исправлена ошибка активации режима **Premium**
- Исправлена проблема обмена токенов **JETTON** на блокчейне **TON**
- Исправлено падение приложения при отсутствии аккаунта



## Основные изменения версии 0.46.0
_Дата релиза: 20 августа 2025_

### ✨ Новые возможности

- Добавлен новый режим **Premium**
  - Бесплатный тестовый доступ на 30 дней для каждого кошелька
  - После окончания теста премиум сохраняется без подписки при условии, что на одном кошельке:
    ≥ 10 000 **PIRATE** или
    ≥ 100 **COSA**
  - Токены остаются у вас и продолжают приносить доход, при этом открывая доступ ко всем премиум-функциям
  - 🔒 Все PIRATE в пуле ликвидности заблокированы на 10 лет — исключает rug pull

- Новые премиум-функции:
  - Проверка адреса отправки на контракт с предупреждением для защиты от ошибок
  - Экспорт нестандартных seed-фраз **Monero** в классический 25-словный формат

### 🛠 Важные исправления

- Исправлена ошибка работы с адресами **LTC (BIP-86)** при использовании Blockchair API
- Исправлено падение приложения при обмене **POL / Tangem (fdroid)**

### 🔧 Технические улучшения

- **Monero**: кошелёк теперь работает с нестандартными seed-фразами и прозрачно использует встроенный конвертор в 25 слов (без премиума)



## Основные изменения версии 0.45.4
_Дата релиза: 17 августа 2025_

- Исправлена проблема с отображением транзакций при использовании **Monero-кошельков на 12 слов**.
  Для кошельков на 25 слов ошибка не воспроизводилась.

## Рекомендации пользователям

- Если у вас Monero-кошелёк на 12 слов и **не отображаются транзакции**, необходимо:
  1. Удалить кошелёк.
  2. Заново импортировать его.
- Если вы используете **25-словный кошелёк** или **не использовали Monero 12-словный кошелёк**, никаких действий предпринимать не требуется.



## Основные изменения версии 0.45.3
_Дата релиза: 13 августа 2025_

### ✨ Новые возможности

- Добавлена поддержка **Monero** с 12-словными seed-фразами

### 🛠 Важные исправления

- Исправлено падение приложения: android.net.ConnectivityManager$TooManyRequestsException
- Исправлена проблема с подтверждением в **WalletConnect**
- Исправлено обрезание слова *staking* в описании
- Исправлено отображение отступов кнопки на экране отправки

### 🔧 Технические улучшения

- Добавлен фильтр для неподдерживаемого **LTC BIP86** в **Thorchain** (отключена поддержка Taproot для LTC)
- Обновлён **zcashAndroidSdk** до версии 2.3.0



## Основные изменения версии 0.45.2
_Дата релиза: 7 августа 2025_

## 🪙 Исправления для TRON

- 🚀 Исправлена проблема с отправкой токенов TRC-20 и монеты TRX.

## 🌙 Улучшения интерфейса

- 🌗 Исправлена ошибка отображения в тёмной теме при проверке адресов
  Все элементы интерфейса теперь читаемы как в светлом, так и в тёмном режиме.



## Основные изменения версии 0.45.1
_Дата релиза: 29 июля 2025_

## 🔐 Улучшения конфиденциальности

- 🕵️‍♂️ Повышена анонимность при отправке транзакций

  Теперь пользователь сам выбирает, проверять ли адрес на санкции и блэклисты.

  Приложение не производит скрытых проверок и не отслеживает действия без явного согласия.

  Мы продолжаем фокусироваться на безопасности без компромиссов с приватностью.



## Основные изменения версии 0.45.0
_Дата релиза: 28 июля 2025_

## 🆕 Новое

- 🛡 **Проверка адресов (санкции, блэклисты)**

  Новый раздел позволяет в любой момент проверить любой адрес на наличие в санкционных и черных списках. Особенно полезно при работе с крупными переводами от третьих лиц.

## 🔧 Улучшения

- ⚙️ Улучшена механика **автоскрытия** — теперь она работает с транзакциями и их деталями.  
- 📴 Добавлена возможность **отключения окна changelog** после обновления приложения.

## 🐞 Исправления

- 📊 Исправлена ошибка отображения графика стекинга — теперь на нем корректно отображаются **монеты**, а не **валюта**.  
- 💸 Исправлено отображение **комиссии сети** при обмене через **ChangeNow**.



## Основные изменения версии 0.44.2
_Дата релиза: 26 июля 2025_

- 🐞 Исправлена проблема, при которой в некоторых случаях после ввода адреса не удавалось нажать на кнопку **«Далее»**.
- ✏️ Устранена неточность в описании в настройках, как указано в issue #56.



## Основные изменения версии 0.44.1
_Дата релиза: 24 июля 2025_


### 💰 **Улучшения интерфейса обмена**
- Теперь **доступный баланс всегда виден во время ввода суммы**, а не только до этого 🧮

### 🛠 **Стабильность и исправления**
- Исправлены **ошибки, вызывавшие падение приложения** 📱💥  
- Обновлена логика отображения **цены на графике** — теперь **валюта отображается корректно** 📊💸

### 📱 **Поддержка Monero и Samsung**
- Исправлена проблема, при которой **клавиатура на устройствах Samsung** перекрывала данные при восстановлении Monero 🛡️🔑

### 👀 **WatchOnly-адреса**
- Улучшена логика работы с **просмотровыми (WatchOnly) адресами** — теперь они работают надёжнее 🔍🔐

### 🔒 **Автоматическое скрытие баланса**
- В некоторых случаях **числа заменялись звёздочками**, даже когда это было не нужно — теперь исправлено ⭐➡️123



## Основные изменения версии 0.44
_Дата релиза: 22 июля 2025_


## ИНТЕГРАЦИЯ THORCHAIN SWAP

Испытайте удобство кросс-чейн свопов! Обменивайте BTC ↔ ETH и другие криптовалюты прямо в кошельке. Без KYC. Без централизованных бирж. Полная конфиденциальность.

## ПОДДЕРЖКА БЛОКЧЕЙНА STELLAR

Полная совместимость с блокчейном Stellar и доступ ко всему спектру его активов — всё интегрировано прямо в вашем кошельке.

## Улучшения в приложении

- 🔐 **Улучшено поведение автоскрытия транзакций**: теперь PIN-код запрашивается только в случае изменения актива, изменения категории или после блокировки устройства.
- 🌐 **Уточнены переводы**: исправлены неточности и улучшена локализация интерфейса.
- 🚫 **Возможность запуска без системного PIN-кода**: теперь вы можете запускать приложение без ввода PIN, если соглашаетесь с потенциальными рисками.
- 🧷 **Исправлена ошибка режима Dures**: устранена проблема с настройкой режима, если в приложении много кошельков и требуется прокрутка списка.
- 🛠️ **Исправлены ошибки, вызывавшие сбои приложения** в отдельных ситуациях.



## Основные изменения версии 0.43
_Дата релиза: 9 июля 2025_

### Monero — нативная блокчейн-поддержка

Теперь вы можете хранить, отправлять и получать Monero напрямую в его родной сети.

### Отображение аппаратного кошелька без модуля

Пункт аппаратного кошелька теперь отображается даже при отсутствии модуля.
Если NFC не поддерживается на устройстве — пользователь получит предупреждение.

### Исправлена проблема с экраном создания кошелька

Решена ошибка, при которой меню создания кошельков не отображалось после смены системного PIN-кода.



## Основные изменения версии 0.42
_Дата релиза: 20 июня 2025_


### Аппаратный кошелек Tangem

Теперь с поддержкой аппаратного кошелька Tangem — приватные ключи безопасно генерируются и хранятся непосредственно на карте, никогда не раскрываются и не сохраняются где-либо еще. Нет seed-фразы для записи или хранения, что делает практически невозможным кражу ваших активов злоумышленниками.

### ChangeNow

Межблокчейновый обмен доступен через нашего партнера ChangeNow, позволяя вам обменивать монеты из одного блокчейна в другой по конкурентным тарифам.

### Нативный блокчейн DogeCoin

Теперь вы можете хранить, отправлять и получать Dogecoin напрямую в его нативном блокчейне.

### Нативный блокчейн Cosanta

Блокчейн Cosanta теперь полностью поддерживается в кошельке.

### Нативный блокчейн PirateCash

Управляйте PirateCash нативно с улучшенной производительностью и совместимостью.

### Поддержка прозрачных и унифицированных адресов zCash

Добавлена поддержка как прозрачных, так и унифицированных форматов адресов в zCash.

Мы исправили различные ошибки и внесли улучшения, чтобы ваш кошелек работал лучше каждый день.

Sic Parvis Magna ✌️