package cash.p.terminal.modules.receive

import cash.p.terminal.core.isCustom
import cash.p.terminal.wallet.MarketKitWrapper
import cash.p.terminal.core.nativeTokenQueries
import cash.p.terminal.core.sortedByFilter
import cash.p.terminal.core.supported
import cash.p.terminal.core.supports
import cash.p.terminal.wallet.Account
import cash.p.terminal.wallet.Token
import cash.p.terminal.wallet.Wallet
import io.horizontalsystems.ethereumkit.core.AddressValidator
import io.horizontalsystems.core.entities.BlockchainType
import cash.p.terminal.wallet.entities.FullCoin
import cash.p.terminal.wallet.entities.TokenType

class FullCoinsProvider(
    private val marketKit: MarketKitWrapper,
    val activeAccount: Account
) {
    private var activeWallets = listOf<Wallet>()
    private var predefinedTokens = listOf<Token>()

    private var query: String? = null

    fun setActiveWallets(wallets: List<Wallet>) {
        activeWallets = wallets

        updatePredefinedTokens()
    }

    private fun updatePredefinedTokens() {
        val allowedBlockchainTypes =
            BlockchainType.supported.filter { it.supports(activeAccount.type) }
        val tokenQueries = allowedBlockchainTypes
            .map { it.nativeTokenQueries }
            .flatten()
        val supportedNativeTokens = marketKit.tokens(tokenQueries)
        val activeTokens = activeWallets.map { it.token }
        predefinedTokens = activeTokens + supportedNativeTokens
    }

    fun setQuery(q: String) {
        query = q
    }

    suspend fun getItems(): List<FullCoin> {
        val tmpQuery = query.orEmpty()

        val customTokens = predefinedTokens.filter { it.isCustom }

        val fullCoins = if (isContractAddress(tmpQuery)) {
            val customFullCoins = customTokens
                .filter {
                    val type = it.type
                    type is TokenType.Eip20 && type.address.contains(tmpQuery, true)
                }
                .map { it.fullCoin }

            customFullCoins + marketKit.tokens(tmpQuery).map { it.fullCoin }
        } else {
            val customFullCoins = customTokens
                .filter {
                    val coin = it.coin
                    tmpQuery.isEmpty() || coin.name.contains(tmpQuery, true) || coin.code.contains(tmpQuery, true)
                }
                .map { it.fullCoin }

            customFullCoins + marketKit.fullCoins(tmpQuery,100_000)
        }
        return liftActivesKeepingSqlOrder(fullCoins, activeWallets)
    }

    fun liftActivesKeepingSqlOrder(
        fullCoins: List<FullCoin>,
        activeWallets: List<Wallet>
    ): List<FullCoin> {
        val activeUids = activeWallets.map { it.coin.uid }.toHashSet()

        val (actives, others) = fullCoins.partition { it.coin.uid in activeUids }

        return actives + others
    }

    private fun isContractAddress(filter: String) = try {
        AddressValidator.validate(filter)
        true
    } catch (e: AddressValidator.AddressValidationException) {
        false
    }

}
