package cash.p.terminal.modules.manageaccount.stellarsecretkey

import android.os.Parcelable
import androidx.compose.runtime.Composable
import androidx.compose.ui.res.stringResource
import androidx.navigation.NavController
import cash.p.terminal.R
import cash.p.terminal.modules.manageaccount.SecretKeyScreen
import cash.p.terminal.ui_compose.BaseComposeFragment
import kotlinx.parcelize.Parcelize

class StellarSecretKeyFragment : BaseComposeFragment(screenshotEnabled = false) {

    @Composable
    override fun GetContent(navController: NavController) {
        withInput<Input>(navController) { input ->
            StellarSecretKeyScreen(navController, input.stellarSecretKey)
        }
    }

    @Parcelize
    data class Input(val stellarSecretKey: String) : Parcelable
}

@Composable
fun StellarSecretKeyScreen(
    navController: NavController,
    stellarSecretKey: String,
) {
    SecretKeyScreen(
        navController = navController,
        secretKey = stellarSecretKey,
        title = stringResource(R.string.StellarSecretKey_Title),
        hideScreenText = stringResource(R.string.StellarSecretKey_ShowSecretKey)
    )
}
