package cash.p.terminal.modules.coin

import java.math.BigDecimal

object CoinInfoMap {

    val data = mapOf(
            "\$BASED" to CoinInfo(BigDecimal(100_000), null, "https://based.money"),
            "0chain" to CoinInfo(null, null, "https://0chain.net"),
            "1INCH" to CoinInfo(BigDecimal(1_500_000_000), null, "https://1inch.exchange"),
            "AAVE" to CoinInfo(BigDecimal(16_000_000), "02/10/2020", "https://aave.com"),
            "AAVEDAI" to CoinInfo(null, "08/01/2020", "https://aave.com"),
            "AKRO" to CoinInfo(BigDecimal(4_000_000_000), "06/07/2019", "https://akropolis.io"),
            "ALBT" to CoinInfo(BigDecimal(1_000_000_000), null, "https://www.allianceblock.io"),
            "ALPHA" to CoinInfo(BigDecimal(1_000_000), null, "https://alphafinance.io"),
            "AMON" to CoinInfo(BigDecimal(1_666_666_667), "13/04/2018", "https://amon.tech/"),
            "AMPL" to CoinInfo(BigDecimal(780_675_794), "14/06/2019", "https://www.ampleforth.org"),
            "ANJ" to CoinInfo(BigDecimal(128_645_461), "07/01/2020", "https://anj.aragon.org"),
            "ANKR" to CoinInfo(BigDecimal(10_000_000_000), "21/02/2019", "https://www.ankr.com"),
            "ANT" to CoinInfo(BigDecimal(39_609_524), "05/05/2017", "https://aragon.one"),
            "API3" to CoinInfo(null, null, "https://api3.org"),
            "APY" to CoinInfo(BigDecimal(100_000_000), null, "https://apy.finance"),
            "AST" to CoinInfo(BigDecimal(500_000_000), "07/01/2020", "https://www.airswap.io"),
            "AUC" to CoinInfo(null, null, "https://auctus.org"),
            "BAC" to CoinInfo(BigDecimal(50_001), null, "https://basis.cash"),
            "BADGER" to CoinInfo(BigDecimal(21_000_000), null, "https://badger.finance"),
            "BAL" to CoinInfo(BigDecimal(35_725_000), "20/06/2020", "https://balancer.finance"),
            "BAND" to CoinInfo(BigDecimal(100_000_000), "09/09/2019", "https://bandprotocol.com"),
            "BASE" to CoinInfo(BigDecimal(65_370_936), null, "https://www.baseprotocol.org"),
            "BAT" to CoinInfo(BigDecimal(1_500_000_000), "31/05/2017", "https://basicattentiontoken.org"),
            "BCH" to CoinInfo(BigDecimal(21_000_000), "01/08/2017", "https://www.bitcoincash.org"),
            "BID" to CoinInfo(BigDecimal(4_000_000_000), null, "https://bidaochain.com"),
            "BLT" to CoinInfo(BigDecimal(150_000_000), "10/11/2017", "https://bloom.co"),
            "BNB" to CoinInfo(BigDecimal(187_536_713), "27/06/2017", "https://www.binance.com"),
            "BNT" to CoinInfo(null, "13/02/2017", "https://bancor.network"),
            "BOND" to CoinInfo(null, null, "https://barnbridge.com"),
            "BONDLY" to CoinInfo(BigDecimal(100_000_000_000), null, "https://www.bondly.finance"),
            "BTC" to CoinInfo(BigDecimal(21_000_000), "03/01/2009", "https://bitcoin.org/en"),
            "BTCB" to CoinInfo(BigDecimal(9_001), "17/06/2019", "https://bitcoin.org/en/"),
            "BUSD" to CoinInfo(BigDecimal(28_603_822), "10/09/2019", "https://www.paxos.com/busd"),
            "BZRX" to CoinInfo(BigDecimal(1_030_000_000), "04/02/2019", "https://bzx.network"),
            "CAS" to CoinInfo(BigDecimal(1_000_000_000), "12/10/2017", "https://cashaa.com"),
            "CDAI" to CoinInfo(BigDecimal(2_025_596_474), "07/05/2019", "https://compound.finance"),
            "CEL" to CoinInfo(BigDecimal(695_658_161), "11/04/2018", "https://celsius.network"),
            "CELR" to CoinInfo(BigDecimal(10_000_000_000), null, "https://www.celer.network"),
            "CHAI" to CoinInfo(null, null, null),
            "CHAIN" to CoinInfo(BigDecimal(500_000_000), null, "https://chaingames.io"),
            "CHSB" to CoinInfo(BigDecimal(1_000_000_000), "08/09/2017", "https://swissborg.com"),
            "CHZ" to CoinInfo(BigDecimal(8_888_888_888), null, "https://www.chiliz.com"),
            "COMP" to CoinInfo(BigDecimal(10_000_000), "04/03/2020", "https://compound.finance"),
            "CORE" to CoinInfo(null, null, "https://cvault.finance"),
            "COS" to CoinInfo(BigDecimal(9_400_000_000), null, "https://www.contentos.io"),
            "COSA" to CoinInfo(BigDecimal(64_400_000), null, "https://www.cosanta.net"),
            "COVER" to CoinInfo(null, null, "https://www.coverprotocol.com"),
            "CREAM" to CoinInfo(BigDecimal(2_924_547), null, "https://cream.finance"),
            "CRO" to CoinInfo(BigDecimal(100_000_000_000), "14/11/2019", "https://www.crypto.com/en/chain"),
            "CRPT" to CoinInfo(BigDecimal(99_785_291), "28/09/2017", "https://crypterium.io"),
            "CRV" to CoinInfo(BigDecimal(1_356_236_799), "13/08/2020", "https://www.curve.fi/"),
            "CSAI" to CoinInfo(BigDecimal(17_342_084), "07/05/2019", "https://compound.finance/"),
            "CUSDC" to CoinInfo(BigDecimal(9_803_299_805), "07/05/2019", "https://compound.finance"),
            "CVC" to CoinInfo(BigDecimal(1_000_000_000), "21/06/2017", "https://www.civic.com"),
            "DAI" to CoinInfo(BigDecimal(127_759_558), "18/11/2019", "https://makerdao.com/en/"),
            "DASH" to CoinInfo(BigDecimal(18_900_000), "18/01/2014", "https://dash.org"),
            "DDIM" to CoinInfo(BigDecimal(1_500_000), null, "https://duckdao.io"),
            "DEFO" to CoinInfo(null, null, "https://defhold.com"),
            "DEGO" to CoinInfo(null, null, "https://dego.finance"),
            "DEUS" to CoinInfo(BigDecimal(1_793_062), null, "https://deus.finance/home"),
            "DGD" to CoinInfo(BigDecimal(2_000_000), "28/04/2016", "https://www.dgx.io"),
            "DGX" to CoinInfo(BigDecimal(120_600), "29/03/2018", "https://digix.global/dgx#/"),
            "DHT" to CoinInfo(BigDecimal(100_000_000), null, "https://www.dhedge.org/"),
            "DIA" to CoinInfo(BigDecimal(200_000_000), "27/11/2019", "https://diadata.org/"),
            "DIP" to CoinInfo(BigDecimal(1_000_000_000), "31/05/2018", "https://www.etherisc.com/"),
            "DMG" to CoinInfo(BigDecimal(249_654_286), null, "https://defimoneymarket.com"),
            "DNT" to CoinInfo(BigDecimal(1_000_000_000), "08/08/2017", "https://district0x.io"),
            "DOS" to CoinInfo(BigDecimal(949_292_114), "11/03/2019", "https://dos.network/"),
            "DPI" to CoinInfo(null, null, "https://www.indexcoop.com/dpi"),
            "DSD" to CoinInfo(BigDecimal(35_331_663), null, "https://dsd.finance/app/#/"),
            "DUSD" to CoinInfo(BigDecimal(16_697_847), null, "https://app.dusd.finance"),
            "DYP" to CoinInfo(null, null, "https://dyp.finance"),
            "ELF" to CoinInfo(BigDecimal(880_000_000), "18/12/2017", "https://aelf.io"),
            "ENJ" to CoinInfo(BigDecimal(1_000_000_000), "24/07/2017", "https://enjincoin.io"),
            "ESD" to CoinInfo(BigDecimal(443_687_674), null, "https://emptyset.finance"),
            "ETH" to CoinInfo(null, "30/07/2015", "https://www.ethereum.org"),
            "ETH-BEP2" to CoinInfo(BigDecimal(215_000), null, null),
            "ETHYS" to CoinInfo(BigDecimal(500_000), null, "https://ethereumstake.farm"),
            "EURS" to CoinInfo(null, "22/06/2018", "https://stasis.net"),
            "FARM" to CoinInfo(BigDecimal(471_639), null, "https://harvest.finance"),
            "FLASH" to CoinInfo(BigDecimal(900_000_000), null, "https://flashstake.io"),
            "FLUX" to CoinInfo(BigDecimal(259_186), null, "https://datamine.network"),
            "FNK" to CoinInfo(BigDecimal(100_000_000), null, "https://fnktoken.com"),
            "FOAM" to CoinInfo(BigDecimal(1_000_000_000), "10/10/2017", "https://foam.space"),
            "FOR" to CoinInfo(BigDecimal(1_000_000_000), null, "https://www.theforceprotocol.com"),
            "FRAX" to CoinInfo(BigDecimal(130_600_430), null, "https://frax.finance"),
            "FSW" to CoinInfo(BigDecimal(100_000_000), null, "https://falconswap.com"),
            "FUN" to CoinInfo(BigDecimal(10_999_873_621), "23/06/2017", "https://www.funfair.io"),
            "FYZ" to CoinInfo(BigDecimal(50_000_000), null, "https://www.fyooz.io"),
            "GEN" to CoinInfo(BigDecimal(60_000_000), "01/05/2018", "https://daostack.io"),
            "GLM" to CoinInfo(null, "17/11/2016", "https://golem.network"),
            "GNO" to CoinInfo(BigDecimal(10_000_000), "25/04/2017", "https://gnosis.io/"),
            "GRID" to CoinInfo(BigDecimal(300_000_000), "12/07/2017", "https://gridplus.io"),
            "GRT" to CoinInfo(BigDecimal(10_000_000_000), null, "https://thegraph.com"),
            "GST2" to CoinInfo(null, null, "https://gastoken.io"),
            "GTO" to CoinInfo(BigDecimal(1_000_000_000), "14/12/2017", "https://gifto.io"),
            "GUSD" to CoinInfo(null, "09/09/2018", "https://gemini.com/dollar"),
            "HEDG" to CoinInfo(BigDecimal(1_000_000_000), "07/12/2018", "https://hedgetrade.com"),
            "HEGIC" to CoinInfo(null, null, "https://www.hegic.co"),
            "HEZ" to CoinInfo(BigDecimal(100_000_000), null, "https://hermez.io"),
            "HH" to CoinInfo(BigDecimal(100_000_000), null, "https://holyheld.com"),
            "HLAND" to CoinInfo(null, null, "https://htw.land"),
            "HOT" to CoinInfo(BigDecimal(177_619_433_541), "16/01/2018", "https://thehydrofoundation.com"),
            "HT" to CoinInfo(BigDecimal(500_000_000), "22/01/2018", "https://www.huobi.pro"),
            "HUSD" to CoinInfo(null, "29/11/2018", "https://www.stcoins.com"),
            "IDEX" to CoinInfo(BigDecimal(1_000_000_000), "28/09/2017", "https://auroradao.com"),
            "IDLE" to CoinInfo(BigDecimal(13_000_000), null, "https://idle.finance"),
            "IOTX" to CoinInfo(BigDecimal(10_000_000_000), "21/05/2018", "https://iotex.io/"),
            "IRIS" to CoinInfo(BigDecimal(2_000_000_000), null, "https://www.irisnet.org"),
            "KCS" to CoinInfo(BigDecimal(176_863_551), "15/09/2017", "https://www.kucoin.com/#"),
            "KEEP" to CoinInfo(BigDecimal(1_000_000_000), null, "https://keep.network"),
            "KEY" to CoinInfo(BigDecimal(5_999_999_954), "11/01/2018", "https://selfkey.org/"),
            "KNC" to CoinInfo(BigDecimal(210_590_429), "20/09/2017", "https://kyber.network"),
            "KP3R" to CoinInfo(null, null, "https://keep3r.network"),
            "LDO" to CoinInfo(BigDecimal(1_000_000_000), null, "https://stake.lido.fi/"),
            "LEND" to CoinInfo(BigDecimal(1_299_999_942), "15/08/2017", "https://aave.com"),
            "LGCY" to CoinInfo(null, null, "https://lgcy.network"),
            "LINA" to CoinInfo(BigDecimal(10_000_000_199), "16/09/2020", "https://linear.finance"),
            "LINK" to CoinInfo(BigDecimal(1_000_000_000), "19/09/2017", "https://link.smartcontract.com"),
            "LON" to CoinInfo(BigDecimal(200_000_000), null, "https://tokenlon.im/lon"),
            "LOOM" to CoinInfo(BigDecimal(1_000_000_000), "03/03/2018", "https://loomx.io"),
            "LPT" to CoinInfo(BigDecimal(22_537_813), "08/11/2018", "https://livepeer.org"),
            "LQD" to CoinInfo(BigDecimal(100_000_000), "01/11/2015", "https://liquidity.network"),
            "LRC" to CoinInfo(BigDecimal(1_374_513_897), "06/08/2017", "https://loopring.org/#/"),
            "LTC" to CoinInfo(BigDecimal(84_000_000), "13/10/2011", "https://litecoin.com"),
            "LTO" to CoinInfo(BigDecimal(500_000_000), null, "https://lto.network"),
            "MANA" to CoinInfo(BigDecimal(2_644_403_343), "08/08/2017", "https://decentraland.org"),
            "MATIC" to CoinInfo(BigDecimal(10_000_000_000), "26/03/2018", "https://matic.network"),
            "MATIC-BEP2" to CoinInfo(BigDecimal(10_000_000_000), null, null),
            "MCB" to CoinInfo(BigDecimal(150_000_000), null, "https://mcdex.io"),
            "MCO" to CoinInfo(BigDecimal(31_587_682), "18/05/2017", "https://crypto.com/en/index.html"),
            "MEME" to CoinInfo(BigDecimal(28_000), null, "https://dontbuymeme.com"),
            "MET" to CoinInfo(BigDecimal(12_488_971), "23/05/2018", "https://www.metronome.io"),
            "MFT" to CoinInfo(BigDecimal(10_000_000_000), null, "https://mainframe.com"),
            "MIR" to CoinInfo(null, null, "https://eth.mirror.finance"),
            "MKR" to CoinInfo(BigDecimal(1_000_000), "15/08/2015", null),
            "MLN" to CoinInfo(BigDecimal(1_524_032), "26/01/2018", "https://melonprotocol.com"),
            "MPH" to CoinInfo(BigDecimal(304_412), null, "https://88mph.app"),
            "MTA" to CoinInfo(BigDecimal(100_000_000), "13/07/2020", "https://mstable.org"),
            "MTXLT" to CoinInfo(BigDecimal(90_000), null, "https://tixl.me"),
            "MUSD" to CoinInfo(BigDecimal(100_000_000), "05/01/2018", "https://mstable.org"),
            "NEST" to CoinInfo(null, null, "https://nestprotocol.org"),
            "NEXO" to CoinInfo(BigDecimal(1_000_000_000), "29/04/2018", "https://nexo.io"),
            "NMR" to CoinInfo(BigDecimal(11_000_000), "21/06/2017", "https://erasure.world"),
            "NPXS" to CoinInfo(BigDecimal(259_810_708_833), "27/09/2017", "https://pundix.com"),
            "NXM" to CoinInfo(BigDecimal(6_696_774), null, "https://nexusmutual.io"),
            "Nsure" to CoinInfo(null, null, "https://nsure.network"),
            "OCEAN" to CoinInfo(BigDecimal(613_099_141), "23/04/2019", "https://oceanprotocol.com"),
            "OCTO" to CoinInfo(BigDecimal(800_000), null, "https://octo.fi"),
            "OGN" to CoinInfo(BigDecimal(1_000_000_000), null, "https://www.originprotocol.com"),
            "OMG" to CoinInfo(supply = null, "23/06/2017", "https://omg.network"),
            "ONE" to CoinInfo(BigDecimal(12_600_000_000), null, "https://harmony.one"),
            "ORAI" to CoinInfo(BigDecimal(23_037_721), null, "https://orai.io"),
            "ORBS" to CoinInfo(BigDecimal(10_000_000_000), "14/03/2018", "https://www.orbs.com"),
            "ORN" to CoinInfo(BigDecimal(100_000_000), "13/07/2020", "https://orionprotocol.io"),
            "OXT" to CoinInfo(BigDecimal(10_000_000_000), "03/12/2019", "https://www.orchid.com"),
            "PAN" to CoinInfo(null, null, "https://panvala.com"),
            "PAR" to CoinInfo(BigDecimal(999_628_334), null, "https://www.parachutetoken.com"),
            "PAX" to CoinInfo(BigDecimal(249_952_065), "10/09/2018", "https://www.paxos.com/pax"),
            "PERP" to CoinInfo(BigDecimal(150_000_000), null, "https://perp.fi"),
            "PIRATE" to CoinInfo(BigDecimal(105_000_000), null, "https://p.cash"),
            "PICKLE" to CoinInfo(BigDecimal(1_289_763), null, "https://pickle.finance"),
            "PLOT" to CoinInfo(BigDecimal(200_000_000), null, "https://plotx.io"),
            "PNK" to CoinInfo(BigDecimal(764_626_704), "15/03/2018", "https://kleros.io"),
            "POA" to CoinInfo(null, null, "https://poa.net"),
            "POLS" to CoinInfo(BigDecimal(100_000_000), null, "https://www.polkastarter.com"),
            "POLY" to CoinInfo(BigDecimal(1_000_000_000), "25/12/2017", "https://www.polymath.network"),
            "PPT" to CoinInfo(BigDecimal(53_252_246), "12/04/2017", "https://populous.world"),
            "QNT" to CoinInfo(BigDecimal(14_612_493), "25/06/2018", "https://www.quant.network/"),
            "QSP" to CoinInfo(BigDecimal(976_442_388), "17/11/2017", "https://quantstamp.com/"),
            "RARI" to CoinInfo(BigDecimal(25_000_000), "15/07/2020", "https://rarible.com/"),
            "RDN" to CoinInfo(BigDecimal(100_000_000), null, "https://raiden.network"),
            "REN" to CoinInfo(BigDecimal(999_999_633), "31/12/2017", "https://renproject.io"),
            "RENBCH" to CoinInfo(null, null, "https://renproject.io"),
            "RENBTC" to CoinInfo(null, null, "https://renproject.io"),
            "RENZEC" to CoinInfo(null, null, "https://renproject.io"),
            "REP" to CoinInfo(null, "17/11/2014", "https://www.augur.net"),
            "REPv2" to CoinInfo(null, null, "https://www.augur.net"),
            "REV" to CoinInfo(BigDecimal(1_000_000_000), "04/08/2017", "https://revain.org"),
            "RFI" to CoinInfo(BigDecimal(10_000_000), null, "https://reflect.finance"),
            "RFuel" to CoinInfo(null, null, "https://riodefi.com"),
            "RING" to CoinInfo(BigDecimal(1_590_567_953), "13/09/2018", "https://darwinia.network"),
            "RLC" to CoinInfo(BigDecimal(86_999_785), "10/01/2017", "https://iex.ec/"),
            "ROOT" to CoinInfo(BigDecimal(10_000), null, "https://rootkit.finance"),
            "RPL" to CoinInfo(BigDecimal(17_922_515), "07/09/2017", "https://www.rocketpool.net"),
            "RSR" to CoinInfo(BigDecimal(100_000_000_000), null, "https://reserve.org"),
            "RUNE" to CoinInfo(BigDecimal(500_000_000), null, "https://thorchain.org"),
            "SAI" to CoinInfo(null, "18/12/2017", "https://makerdao.com/en"),
            "SALT" to CoinInfo(BigDecimal(120_000_000), "28/07/2017", "https://saltlending.com"),
            "SAN" to CoinInfo(BigDecimal(83_337_000), "09/02/2017", "https://santiment.net"),
            "SAND" to CoinInfo(BigDecimal(3_000_000_000), null, "http://www.sandbox.game"),
            "SFI" to CoinInfo(BigDecimal(83_284), null, "http://saffron.finance"),
            "SHARE" to CoinInfo(BigDecimal(21_000_000), null, "https://dollarprotocol.com"),
            "SHR" to CoinInfo(BigDecimal(4_396_000_000), null, "https://sharering.network"),
            "SNT" to CoinInfo(BigDecimal(6_804_870_174), "20/06/2017", "https://status.im"),
            "SNX" to CoinInfo(BigDecimal(190_075_446), "07/01/2018", "https://www.synthetix.io"),
            "SOCKS" to CoinInfo(BigDecimal(326), "08/05/2019", "https://unisocks.exchange"),
            "SPANK" to CoinInfo(BigDecimal(1_000_000_000), "31/10/2017", "https://spankchain.com"),
            "SPDR" to CoinInfo(null, null, "https://spiderdao.io"),
            "SRM" to CoinInfo(BigDecimal(161_000_001), "31/07/2020", "https://projectserum.com"),
            "STAKE" to CoinInfo(BigDecimal(8_288_374), "31/07/2020", "https://xdaichain.com"),
            "STORJ" to CoinInfo(BigDecimal(424_999_998), "19/07/2017", "https://storj.io"),
            "SURF" to CoinInfo(null, null, "https://surf.finance"),
            "SUSD" to CoinInfo(BigDecimal(22_510_653), null, "https://www.synthetix.io"),
            "SWFL" to CoinInfo(null, null, "https://swapfol.io"),
            "SWISS" to CoinInfo(BigDecimal(10_000), null, "https://swissfarming.finance"),
            "SWRV" to CoinInfo(BigDecimal(33_000_000), null, "https://swerve.fi"),
            "SXP" to CoinInfo(BigDecimal(289_612_084), "16/08/2019", "https://swipe.io"),
            "Swap" to CoinInfo(BigDecimal(100_000_000), "09/07/2020", "https://trustswap.org"),
            "TAUD" to CoinInfo(null, null, "https://www.trusttoken.com/trueaud"),
            "TAUDB" to CoinInfo(BigDecimal(90_000_000_000), null, "https://trusttoken.com"),
            "TBTC" to CoinInfo(null, null, "https://tbtc.network"),
            "TCAD" to CoinInfo(null, null, "https://www.trusttoken.com/truecad"),
            "TGBP" to CoinInfo(null, null, "https://www.trusttoken.com/truegbp"),
            "THKD" to CoinInfo(null, null, "https://www.trusttoken.com/truehkd"),
            "THKDB" to CoinInfo(BigDecimal(90_000_000_000), null, "https://trusttoken.com"),
            "TKN" to CoinInfo(BigDecimal(39_406_760), "25/04/2017", "https://monolith.xyz"),
            "TRB" to CoinInfo(BigDecimal(1_622_063), "10/09/2019", "https://tellor.io"),
            "TRST" to CoinInfo(BigDecimal(100_000_000), "07/12/2016", "https://www.wetrust.io"),
            "TRU" to CoinInfo(BigDecimal(1_446_312_655), null, "https://truefi.io"),
            "TUSD" to CoinInfo(null, "31/03/2018", "https://www.trusttoken.com"),
            "TUSDB" to CoinInfo(BigDecimal(90_000_000_000), null, "https://trusttoken.com"),
            "UBT" to CoinInfo(BigDecimal(150_000_000), "11/12/2017", "https://unibright.io"),
            "UMA" to CoinInfo(BigDecimal(101_104_951), "09/01/2020", "https://umaproject.org"),
            "UNI" to CoinInfo(BigDecimal(1_000_000_000), null, "https://uniswap.org"),
            "USDC" to CoinInfo(null, "17/05/2018", "https://www.centre.io/usdc"),
            "USDN" to CoinInfo(BigDecimal(125_679_184), null, "https://neutrino.at"),
            "USDS" to CoinInfo(BigDecimal(90_000_486_303), "15/08/2018", "https://www.stably.io"),
            "USDT" to CoinInfo(BigDecimal(9_479_177_442), "10/06/2014", "https://tether.to"),
            "USDx" to CoinInfo(null, null, null),
            "UTK" to CoinInfo(BigDecimal(500_000_000), null, "https://utrust.com"),
            "VERI" to CoinInfo(BigDecimal(100_000_000), "25/04/2017", "https://veritas.veritaseum.com"),
            "WAVES" to CoinInfo(null, null, "https://waves.tech"),
            "WBTC" to CoinInfo(BigDecimal(21_000_000), "27/11/2018", "https://wbtc.network"),
            "WETH" to CoinInfo(BigDecimal(1_153_917), "31/12/2018", "https://weth.io"),
            "WFIL" to CoinInfo(null, null, "https://www.wrapped.com"),
            "WHITE" to CoinInfo(null, null, "https://www.whiteheart.finance"),
            "WICC" to CoinInfo(BigDecimal(210_000_000), null, "https://www.waykichain.com"),
            "WISE" to CoinInfo(null, null, "https://wisetoken.net"),
            "WRX" to CoinInfo(BigDecimal(995_833_334), null, "https://wazirx.com"),
            "WTC" to CoinInfo(BigDecimal(70_000_000), "27/08/2017", "https://www.waltonchain.org/en"),
            "WZEC" to CoinInfo(BigDecimal(9_082), null, "https://www.wrapped.com"),
            "XCHF" to CoinInfo(BigDecimal(100_000_000), "01/11/2018", "https://swisscryptotokens.ch"),
            "XFT" to CoinInfo(BigDecimal(10_000_000), null, "https://offshift.io"),
            "XIO" to CoinInfo(BigDecimal(100_000_000), "22/10/2019", "https://xio.network"),
            "XOR" to CoinInfo(BigDecimal(350_000), null, "https://sora.org"),
            "XRP" to CoinInfo(BigDecimal(99_990_932_726), "02/02/2013", "https://ripple.com/xrp"),
            "XRT" to CoinInfo(BigDecimal(9_984_038), null, "https://robonomics.network/en/"),
            "YAX" to CoinInfo(BigDecimal(305_540), null, "https://yaxis.io"),
            "YFI" to CoinInfo(BigDecimal(30_000), null, "https://yearn.finance"),
            "YFII" to CoinInfo(BigDecimal(39_375), null, "https://dfi.money"),
            "YFIM" to CoinInfo(BigDecimal(60_000), null, null),
            "Yf-DAI" to CoinInfo(BigDecimal(21_000_000), null, "https://www.yfdai.finance"),
            "ZAI" to CoinInfo(null, null, "https://zai.finance"),
            "ZEC" to CoinInfo(BigDecimal(21_000_000), "28/10/2016", "https://z.cash"),
            "ZRX" to CoinInfo(BigDecimal(1_000_000_000), "15/08/2017", "https://www.0xproject.com/#home"),
            "eXRD" to CoinInfo(BigDecimal(4_410_000_000), null, "https://www.radixdlt.com"),
            "imBTC" to CoinInfo(BigDecimal(21_000_000), null, "https://tokenlon.im/imbtc#"),
            "pBTC" to CoinInfo(BigDecimal(21_000_000), null, "https://ptokens.io"),
            "sETH" to CoinInfo(BigDecimal(29_935), null, "https://www.synthetix.io"),
            "sXAU" to CoinInfo(BigDecimal(225.36884553), null, "https://www.synthetix.io"),
            "wANATHA" to CoinInfo(null, null, "https://anatha.io"),
            "RGT" to CoinInfo(null, null, "http://rari.capital"),
            "COMBO" to CoinInfo(null, null, "https://anatha.io"),
            "DEFI5" to CoinInfo(null, null, "https://anatha.io"),
            "CC10" to CoinInfo(null, null, "https://indexed.finance"),
            "MX" to CoinInfo(null, null, "https://www.mxc.ceo"),
            "GT" to CoinInfo(null, null, "https://gatechain.io"),
            "FTT" to CoinInfo(null, null, "https://indexed.finance"),


            )


    data class CoinInfo(val supply: BigDecimal?, val startDate: String?, val website: String?)
;
}
