package cash.p.terminal.entities.nft

import androidx.room.Embedded
import androidx.room.Entity
import androidx.room.ForeignKey
import cash.p.terminal.wallet.entities.AccountRecord
import io.horizontalsystems.core.entities.BlockchainType

@Entity(
    primaryKeys = ["blockchainType", "accountId", "nftUid"],
    foreignKeys = [ForeignKey(
        entity = AccountRecord::class,
        parentColumns = ["id"],
        childColumns = ["accountId"],
        onDelete = ForeignKey.CASCADE,
        deferred = true
    )
    ]
)
data class NftAssetRecord(
    val blockchainType: BlockchainType,
    val accountId: String,
    val nftUid: NftUid,
    val collectionUid: String,
    val name: String?,
    val imagePreviewUrl: String?,
    val onSale: Boolean,

    @Embedded(prefix = "lastSale_")
    val lastSale: NftPriceRecord?
)
