## Dark Theme

```kotlin
val darkColors = darkColors(
  primary = Color(0xFFB3BF16),
  primaryVariant = Color(0xFF879017),
  secondary = Color(0xFFB71D76),
  secondaryVariant = Color(0xFF9D1C66),
  background = Color(0xFF191919),
  surface = Color(0xFF191919),
  error = Color(0xFFCF72A8),
  onPrimary = Color(0xFF191919),
  onSecondary = Color(0xFF191919),
  onBackground = Color(0xFFF2F2F2),
  onSurface = Color(0xFFF2F2F2),
  onError = Color(0xFF191919)
)
```

| **Color Name**     |   **Hex** | **Swatch**                                              | **Material Role**                                                           |
|--------------------|----------:|---------------------------------------------------------|-----------------------------------------------------------------------------|
| `primary`          | `#B3BF16` | ![#B3BF16](https://img.shields.io/badge/-B3BF16-B3BF16) | Primary brand color. Used to highlight key UI elements.                     |
| `primaryVariant`   | `#879017` | ![#879017](https://img.shields.io/badge/-879017-879017) | Variation of primary. Used for emphasis or tonal variations in brand color. |
| `secondary`        | `#B71D76` | ![#B71D76](https://img.shields.io/badge/-B71D76-B71D76) | Secondary accent color. Supports the primary color in the UI.               |
| `secondaryVariant` | `#9D1C66` | ![#9D1C66](https://img.shields.io/badge/-9D1C66-9D1C66) | Variation of secondary. Used for subtle or alternative accent emphasis.     |
| `background`       | `#191919` | ![#191919](https://img.shields.io/badge/-191919-191919) | Main background color for darker themes.                                    |
| `surface`          | `#191919` | ![#191919](https://img.shields.io/badge/-191919-191919) | Background color for surfaces (cards, sheets, etc.) in dark theme.          |
| `error`            | `#CF72A8` | ![#CF72A8](https://img.shields.io/badge/-CF72A8-CF72A8) | Color used to represent errors or destructive actions.                      |
| `onPrimary`        | `#191919` | ![#191919](https://img.shields.io/badge/-191919-191919) | Text/icon color shown on top of `primary`.                                  |
| `onSecondary`      | `#191919` | ![#191919](https://img.shields.io/badge/-191919-191919) | Text/icon color shown on top of `secondary`.                                |
| `onBackground`     | `#F2F2F2` | ![#F2F2F2](https://img.shields.io/badge/-F2F2F2-F2F2F2) | Text/icon color used on `background`.                                       |
| `onSurface`        | `#F2F2F2` | ![#F2F2F2](https://img.shields.io/badge/-F2F2F2-F2F2F2) | Text/icon color used on `surface`.                                          |
| `onError`          | `#191919` | ![#191919](https://img.shields.io/badge/-191919-191919) | Text/icon color shown on top of `error`.                                    |

---

## Light Theme

```kotlin
val lightColors = lightColors(
  primary = Color(0xFF5B6018),
  primaryVariant = Color(0xFF717817),
  secondary = Color(0xFFB71D76),
  secondaryVariant = Color(0xFF9D1C66),
  background = Color(0xFFF2F2F2),
  surface = Color(0xFFF2F2F2),
  error = Color(0xFFCF72A8),
  onPrimary = Color(0xFFF2F2F2),
  onSecondary = Color(0xFFF2F2F2),
  onBackground = Color(0xFF191919),
  onSurface = Color(0xFF191919),
  onError = Color(0xFF191919)
)
```

| **Color Name**     |   **Hex** | **Swatch**                                              | **Material Role**                                                           |
|--------------------|----------:|---------------------------------------------------------|-----------------------------------------------------------------------------|
| `primary`          | `#5B6018` | ![#5B6018](https://img.shields.io/badge/-5B6018-5B6018) | Primary brand color. Used to highlight key UI elements.                     |
| `primaryVariant`   | `#717817` | ![#717817](https://img.shields.io/badge/-717817-717817) | Variation of primary. Used for emphasis or tonal variations in brand color. |
| `secondary`        | `#B71D76` | ![#B71D76](https://img.shields.io/badge/-B71D76-B71D76) | Secondary accent color. Supports the primary color in the UI.               |
| `secondaryVariant` | `#9D1C66` | ![#9D1C66](https://img.shields.io/badge/-9D1C66-9D1C66) | Variation of secondary. Used for subtle or alternative accent emphasis.     |
| `background`       | `#F2F2F2` | ![#F2F2F2](https://img.shields.io/badge/-F2F2F2-F2F2F2) | Main background color for lighter themes.                                   |
| `surface`          | `#F2F2F2` | ![#F2F2F2](https://img.shields.io/badge/-F2F2F2-F2F2F2) | Background color for surfaces (cards, sheets, etc.) in light theme.         |
| `error`            | `#CF72A8` | ![#CF72A8](https://img.shields.io/badge/-CF72A8-CF72A8) | Color used to represent errors or destructive actions.                      |
| `onPrimary`        | `#F2F2F2` | ![#F2F2F2](https://img.shields.io/badge/-F2F2F2-F2F2F2) | Text/icon color shown on top of `primary`.                                  |
| `onSecondary`      | `#F2F2F2` | ![#F2F2F2](https://img.shields.io/badge/-F2F2F2-F2F2F2) | Text/icon color shown on top of `secondary`.                                |
| `onBackground`     | `#191919` | ![#191919](https://img.shields.io/badge/-191919-191919) | Text/icon color used on `background`.                                       |
| `onSurface`        | `#191919` | ![#191919](https://img.shields.io/badge/-191919-191919) | Text/icon color used on `surface`.                                          |
| `onError`          | `#191919` | ![#191919](https://img.shields.io/badge/-191919-191919) | Text/icon color shown on top of `error`.                                    |

---

## White & Black (Grayscale) Palette

Below are commonly used grayscale values, each displayed via a shields.io badge.

| **Hex**   | **Swatch**                                              | **Usage**                             |
|-----------|---------------------------------------------------------|---------------------------------------|
| `#000000` | ![#000000](https://img.shields.io/badge/-000000-000000) | True black, often for text or accents |
| `#191919` | ![#191919](https://img.shields.io/badge/-191919-191919) | Very dark gray, UI backgrounds        |
| `#303030` | ![#303030](https://img.shields.io/badge/-303030-303030) | Dark gray variant                     |
| `#474747` | ![#474747](https://img.shields.io/badge/-474747-474747) | Mid-dark gray                         |
| `#5e5e5e` | ![#5e5e5e](https://img.shields.io/badge/-5e5e5e-5e5e5e) | Dark neutral gray                     |
| `#747474` | ![#747474](https://img.shields.io/badge/-747474-747474) | Medium gray for borders or text       |
| `#8b8b8b` | ![#8b8b8b](https://img.shields.io/badge/-8b8b8b-8b8b8b) | Lighter mid-tone gray                 |
| `#a2a2a2` | ![#a2a2a2](https://img.shields.io/badge/-a2a2a2-a2a2a2) | Light gray                            |
| `#b9b9b9` | ![#b9b9b9](https://img.shields.io/badge/-b9b9b9-b9b9b9) | Light-medium gray                     |
| `#d0d0d0` | ![#d0d0d0](https://img.shields.io/badge/-d0d0d0-d0d0d0) | Very light gray                       |
| `#e7e7e7` | ![#e7e7e7](https://img.shields.io/badge/-e7e7e7-e7e7e7) | Near-white gray                       |
| `#f2f2f2` | ![#f2f2f2](https://img.shields.io/badge/-f2f2f2-f2f2f2) | Very subtle gray                      |
| `#ffffff` | ![#ffffff](https://img.shields.io/badge/-ffffff-ffffff) | Pure white, often for backgrounds     |

---

## Extended Green Palette

| **Hex**   | **Swatch**                                              | **Description**                             |
|-----------|---------------------------------------------------------|---------------------------------------------|
| `#2f3119` | ![#2f3119](https://img.shields.io/badge/-2f3119-2f3119) | Very dark olive, used for deep accents      |
| `#454818` | ![#454818](https://img.shields.io/badge/-454818-454818) | Dark olive green                            |
| `#5b6018` | ![#5b6018](https://img.shields.io/badge/-5b6018-5b6018) | Mid-range brand green (Light theme primary) |
| `#717817` | ![#717817](https://img.shields.io/badge/-717817-717817) | Secondary/variant green                     |
| `#879017` | ![#879017](https://img.shields.io/badge/-879017-879017) | Lighter olive for UI or backgrounds         |
| `#9da716` | ![#9da716](https://img.shields.io/badge/-9da716-9da716) | Pale olive accent                           |
| `#b3bf16` | ![#b3bf16](https://img.shields.io/badge/-b3bf16-b3bf16) | Bright brand green (Dark theme primary)     |
| `#c0c942` | ![#c0c942](https://img.shields.io/badge/-c0c942-c0c942) | Light lime accent                           |
| `#ccd36e` | ![#ccd36e](https://img.shields.io/badge/-ccd36e-ccd36e) | Soft lime hue                               |
| `#d9de9a` | ![#d9de9a](https://img.shields.io/badge/-d9de9a-d9de9a) | Subtle lime tint for backgrounds            |

---

## Extended Pink Palette

| **Hex**   | **Swatch**                                              | **Description**                               |
|-----------|---------------------------------------------------------|-----------------------------------------------|
| `#331a29` | ![#331a29](https://img.shields.io/badge/-331a29-331a29) | Very dark plum, used for deep accents         |
| `#4e1a38` | ![#4e1a38](https://img.shields.io/badge/-4e1a38-4e1a38) | Dark magenta hue                              |
| `#681b48` | ![#681b48](https://img.shields.io/badge/-681b48-681b48) | Mid-plum pink                                 |
| `#821c57` | ![#821c57](https://img.shields.io/badge/-821c57-821c57) | Dark raspberry                                |
| `#9d1c66` | ![#9d1c66](https://img.shields.io/badge/-9d1c66-9d1c66) | Subtle brand accent for dark themes           |
| `#b71d76` | ![#b71d76](https://img.shields.io/badge/-b71d76-b71d76) | Core pink brand accent (Dark/Light secondary) |
| `#c3488f` | ![#c3488f](https://img.shields.io/badge/-c3488f-c3488f) | Lighter fuchsia accent                        |
| `#cf72a8` | ![#cf72a8](https://img.shields.io/badge/-cf72a8-cf72a8) | Used for error states (lighter pink)          |
| `#da9dc0` | ![#da9dc0](https://img.shields.io/badge/-da9dc0-da9dc0) | Soft pink-lavender hue                        |
| `#e6c7d9` | ![#e6c7d9](https://img.shields.io/badge/-e6c7d9-e6c7d9) | Subtle pastel pink tint                       |

---

## Usage Notes

1. **Dark Theme**
    - Ideal for night-mode contexts, with strong contrast on a dark background (`#191919`).
2. **Light Theme**
    - Designed for bright environments with a light background (`#F2F2F2`) and dark text (`#191919`).
3. **White & Black (Grayscale) Palette**
    - Commonly used for borders, typography, shadows, or UI elements not requiring brand colors.
4. **Extended Green Palette**
    - Additional shades that complement the primary brand color (greens).
5. **Extended Pink Palette**
    - Additional pink/magenta tones matching the secondary accent.

Each color role follows Material guidelines:

- **Primary / Secondary**: Core brand colors.
- **Variant**: Tonal variation of primary/secondary.
- **Background / Surface**: Page background vs. card/sheet backgrounds.
- **Error**: Destructive or error states.
- **onX**: Foreground color (text/icons) displayed atop that “X” background.
