# Healthy Battery Charging

## Screenshots

<p float="center">
  <img src="https://github.com/vbresan/HealthyBatteryCharging/blob/master/metadata/en-US/images/phoneScreenshots/1.png" width="20%" alt="Screenshot discharging" title="Screenshot discharging" />
  <img src="https://github.com/vbresan/HealthyBatteryCharging/blob/master/metadata/en-US/images/phoneScreenshots/2.png" width="20%" alt="Screenshot charging" title="Screenshot charging" />
  <img src="https://github.com/vbresan/HealthyBatteryCharging/blob/master/metadata/en-US/images/phoneScreenshots/4.png" width="20%" alt="Screenshot connect the charger notification" title="Screenshot connect the charger notification" />
  <img src="https://github.com/vbresan/HealthyBatteryCharging/blob/master/metadata/en-US/images/phoneScreenshots/3.png" width="20%" alt="Screenshot disconnect the charger notification" title="Screenshot disconnect the charger notification" />
</p>

## About the app

Make your smartphone or tablet battery last longer!

Good range to aim for when charging a Li-ion battery is from about 40 to 80 percent in one go. A bunch of tiny charges throughout the day is your second best bet, and going from zero to 100 and then 100 to zero on a regular basis will put the most strain on your lithium-ion battery.

Healthy Battery Charging notifies you when to plug or unplug your phone from the charger in order to improve the battery life. The app itself is optimized for low battery consumption, running in the background and checking the battery level every 15 minutes. The exact timing of these checks depends on the Android OS, which might schedule them alongside other tasks or delay them when in sleep mode. As a result, the battery level may slightly exceed the high threshold while charging or drop slightly below the low threshold while discharging before you receive a notification.

For those who want to know more technical details about Li-ion batteries:  
http://batteryuniversity.com/learn/article/how_to_prolong_lithium_based_batteries

## Get it on ...

[<img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png" alt="Get it on F-Droid" height="80">](https://f-droid.org/packages/biz.binarysolutions.healthybatterycharging/)
[<img src="https://gitlab.com/IzzyOnDroid/repo/-/raw/master/assets/IzzyOnDroid.png" alt="Get it on IzzyOnDroid" height="80">](https://apt.izzysoft.de/fdroid/index/apk/biz.binarysolutions.healthybatterycharging)
[<img src="https://raw.githubusercontent.com/andOTP/andOTP/master/assets/badges/get-it-on-github.png" alt="Get it on GitHub" height="80">](https://github.com/vbresan/HealthyBatteryCharging/releases/latest)

The app is not available on the Google Play Store, as it got suspended for [alleged violations of the Descriptive Behavior Policy](https://viktorbresan.blogspot.com/2024/08/why-am-i-so-afraid-to-update-my-google.html).

## Support and contributions

Open-source projects often struggle to be financially sustainable. You are more 
than welcome to sponsor the project by donating via 
[Ko-fi](https://ko-fi.com/vbresan/?utm_source=hbc&utm_medium=github-readme&utm_campaign=regular) 
or 
[Liberapay](https://liberapay.com/vbresan/?utm_source=hbc&utm_medium=github-readme&utm_campaign=regular). 
Such support can help ensure the continued development of this app.

If you like the app, you can show your support by starring the repository and joining the [stargazers](https://github.com/vbresan/HealthyBatteryCharging/stargazers)!

If you would like to get directly involved in the project, you can contribute by providing a translation.

### Translations

Translations are managed through [Weblate](https://weblate.org). App string resources are available in the [App](https://hosted.weblate.org/projects/healthy-battery-charging/app/) component, while [Metadata](https://hosted.weblate.org/projects/healthy-battery-charging/metadata/) component contains the app description and other details. You can log in to Weblate with your GitHub account. *(When your Weblate and GitHub accounts are connected, and your contributions are merged into the main branch, you will be shown in the GitHub [Contributors](https://github.com/vbresan/HealthyBatteryCharging/graphs/contributors) sidebar.)*

Your contributions are greatly appreciated.

#### Current translation status

![Bar chart with current translation status](https://camo.githubusercontent.com/d72883b914ec90080faeec601bf3c7f0fd1cc1c82d34539228339b7cffc961ae/68747470733a2f2f686f737465642e7765626c6174652e6f72672f7769646765742f6865616c7468792d626174746572792d6368617267696e672f6170702f686f72697a6f6e74616c2d6175746f2e737667 "Current translation status")

#### Notes to translators

When translating app string resources:
* For context, please refer to the provided screenshots.

When translating metadata:
* It's not necessary to translate changelogs related to app releases made before your language was added.

#### Translators

Big thanks to:
* Arabic - **[islam2hamy](https://github.com/islam2hamy)**, Med
* Chinese (Simplified) - **[poipoipoipoipoipoipoipoipoi](https://github.com/poipoipoipoipoipoipoipoipoi)**, Assem Askarova
* Chinese (Traditional) - **[shinebrillant](https://github.com/shinebrillant)**
* Czech - **[Fjuro](https://github.com/fjuro)**
* Dutch - **[Rudi Timmermans](https://github.com/ruditimmermans)**
* Esperanto - Assem Askarova
* Estonian - Priit Jõerüüt
* French - **[Ilithy](https://github.com/Ilithy)**
* Galician - josé m
* German - **[Maurits van der Zee](https://github.com/MauritsvanderZee)**
* Hebrew - **[elid](https://github.com/elid34)**
* Italian - **[albanobattistella](https://github.com/albanobattistella)**
* Japanese - Assem Askarova
* Korean - Assem Askarova
* Norwegian Bokmål - **[comradekingu](https://github.com/comradekingu)**
* Polish - **[diskacz](https://github.com/diskacz)**
* Portuguese - **[SantosSi](https://github.com/SantosSi)**
* Portuguese (Brazil) - **[AsmodeumX](https://github.com/AsmodeumX)**, **[Jose Delvani](https://github.com/jsdelvani)**, José Roberto, dedakir923
* Russian - **[Korb](https://github.com/Korb)**, Lowri Olsen
* Spanish - gallegonovato, **[Kamborio](https://github.com/Kamborio)**
* Tamil - **[தமிழ் நேரம்](https://github.com/TamilNeram)**
* Toki Pona - Assem Askarova
* Ukrainian - **[Korb](https://github.com/Korb)**, Lowri Olsen, Максим Горпиніч
