/*
 * Copyright (c) 2021 The Hydra authors
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package be.ugent.zeus.hydra.feed.cards.library;

import android.util.Pair;

import java.util.List;
import java.util.Optional;

import be.ugent.zeus.hydra.common.request.Result;
import be.ugent.zeus.hydra.feed.cards.Card;
import be.ugent.zeus.hydra.feed.cards.PriorityUtils;
import be.ugent.zeus.hydra.library.details.OpeningHours;

/**
 * A card that will display the opening hours of libraries that are in the user's favourites.
 *
 * @author Niko Strijbol
 */
class LibraryCard extends Card {

    /**
     * This is used in the database; do not rename.
     */
    private static final String TAG = "LibraryCard";

    private final List<Pair<String, Result<Optional<OpeningHours>>>> libraries;

    LibraryCard(List<Pair<String, Result<Optional<OpeningHours>>>> libraries) {
        this.libraries = libraries;
    }

    public List<Pair<String, Result<Optional<OpeningHours>>>> getLibraries() {
        return libraries;
    }

    @Override
    public int priority() {
        return PriorityUtils.FEED_SPECIAL_SHIFT + 1;
    }

    @Override
    public String identifier() {
        return TAG;
    }

    @Override
    public int cardType() {
        return Type.LIBRARY;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof LibraryCard;
    }

    @Override
    public int hashCode() {
        return LibraryCard.class.hashCode();
    }
}